/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;

public class CostRecordVoucherInvBillStatusValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length < 1) {
            return;
        }
        HashMap<String, Set<Long>> invEntityBillIdsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, List<ExtendedDataEntity>> invBillIdDataEntitysMap = new HashMap<Long, List<ExtendedDataEntity>>(16);
        this.collectData(invEntityBillIdsMap, invBillIdDataEntitysMap);
        HashMap<Long, String> invBillIdBillStatusMap = new HashMap<Long, String>(16);
        HashMap<Long, Date> invBillIdModifyTimeMap = new HashMap<Long, Date>(16);
        this.loadInvBillDataFromDb(invEntityBillIdsMap, invBillIdBillStatusMap, invBillIdModifyTimeMap);
        this.addErrorMsg(invBillIdDataEntitysMap, invBillIdBillStatusMap, invBillIdModifyTimeMap);
    }

    private void addErrorMsg(Map<Long, List<ExtendedDataEntity>> invBillIdDataEntitysMap, Map<Long, String> invBillIdBillStatusMap, Map<Long, Date> invBillIdModifyTimeMap) {
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        String billNotAuditMsg = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5355\u636e\u5728\u5e93\u5b58\u7cfb\u7edf\u5df2\u53cd\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u3002", (String)"CostRecordBuildVoucherOP_11", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        String invBillModifyTimeMsg = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5355\u636e\u5728\u5e93\u5b58\u7cfb\u7edf\u518d\u6b21\u5ba1\u6838\u540e\uff0c\u9700\u8981\u91cd\u65b0\u540c\u6b65\u540e\uff0c\u518d\u751f\u6210\u51ed\u8bc1\u3002", (String)"CostRecordVoucherInvBillStatusValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        for (Map.Entry<Long, List<ExtendedDataEntity>> invBillIdDataEntityEntry : invBillIdDataEntitysMap.entrySet()) {
            Long invBillId = invBillIdDataEntityEntry.getKey();
            String invBillStatus = invBillIdBillStatusMap.get(invBillId);
            if (invBillStatus == null || !"C".equals(invBillStatus)) {
                for (ExtendedDataEntity dataEntity : invBillIdDataEntityEntry.getValue()) {
                    if (isBizFinInt && "B".equals(invBillStatus)) continue;
                    this.addMessage(dataEntity, billNotAuditMsg, ErrorLevel.Error);
                }
            }
            if (invBillStatus == null) continue;
            Date invModifyTime = invBillIdModifyTimeMap.get(invBillId);
            for (ExtendedDataEntity costRecordDataEntity : invBillIdDataEntityEntry.getValue()) {
                boolean recordLessBizBillModifyTime;
                DynamicObject costRecordDyc = costRecordDataEntity.getDataEntity();
                Date costRecordModifyTime = costRecordDyc.getDate("modifytime");
                Date costRecordLastModifyTime = costRecordDyc.getDate("lastupdatetime");
                if (costRecordLastModifyTime != null) {
                    costRecordModifyTime = costRecordLastModifyTime;
                }
                if (invModifyTime == null || costRecordModifyTime == null) continue;
                boolean bl = recordLessBizBillModifyTime = costRecordModifyTime.getTime() < invModifyTime.getTime();
                Boolean voucher_modifytime = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.VOUCHER_MODIFYTIME);
                if (!voucher_modifytime.booleanValue() || !recordLessBizBillModifyTime) continue;
                this.addMessage(costRecordDataEntity, invBillModifyTimeMsg, ErrorLevel.Error);
            }
        }
    }

    private void loadInvBillDataFromDb(Map<String, Set<Long>> invEntityBillIdsMap, Map<Long, String> invBillIdBillStatusMap, Map<Long, Date> invBillIdModifyTimeMap) {
        HashMap<String, Boolean> invEntityContainsLastModifyTimeMap = new HashMap<String, Boolean>(16);
        for (String string : invEntityBillIdsMap.keySet()) {
            boolean bl = EntityMetadataCache.getDataEntityType((String)string).getProperties().containsKey((Object)"lastupdatetime");
            invEntityContainsLastModifyTimeMap.put(string, bl);
        }
        ArrayList<OrmInput> invBillInputs = new ArrayList<OrmInput>(16);
        for (Map.Entry<String, Set<Long>> entry : invEntityBillIdsMap.entrySet()) {
            String entity = entry.getKey();
            boolean containsLastUpdateTimeField = (Boolean)invEntityContainsLastModifyTimeMap.get(entity);
            QFilter invBillIdFilter = new QFilter("id", "in", entry.getValue());
            String selectFields = "id,billstatus";
            selectFields = containsLastUpdateTimeField ? selectFields + ",lastupdatetime as modifytime" : selectFields + ",modifytime";
            OrmInput billOI = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, selectFields, new QFilter[]{invBillIdFilter});
            invBillInputs.add(billOI);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        try (DataSet dataSet = algo.createDataSet((Input[])invBillInputs.toArray(new OrmInput[invBillInputs.size()]));){
            for (Row row : dataSet) {
                Long invBillId = row.getLong("id");
                invBillIdBillStatusMap.put(invBillId, row.getString("billstatus"));
                Date modifyTime = row.getDate("modifytime");
                invBillIdModifyTimeMap.put(invBillId, modifyTime);
            }
        }
    }

    private void collectData(Map<String, Set<Long>> invEntityBillIdsMap, Map<Long, List<ExtendedDataEntity>> invBillIdDataEntitysMap) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject costRecordDyc = dataEntity.getDataEntity();
            long invBillId = costRecordDyc.getLong("bizbillid");
            DynamicObject invEntityDyc = costRecordDyc.getDynamicObject("bizentityobject");
            if (invEntityDyc == null) continue;
            Set invBillIds = invEntityBillIdsMap.computeIfAbsent(invEntityDyc.getString("number"), k -> new HashSet(16));
            invBillIds.add(invBillId);
            List dataEntitys = invBillIdDataEntitysMap.computeIfAbsent(invBillId, k -> new ArrayList(16));
            dataEntitys.add(dataEntity);
        }
    }
}

