/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostUpdateApplyBillAuditHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.validator.CostUpdateApplyBillAuditValidator;

public class CostUpdateApplyBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostUpdateApplyBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("storageorgunit");
        e.getFieldKeys().add("ownertype");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("mversion");
        e.getFieldKeys().add("assist");
        e.getFieldKeys().add("lot");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("invtype");
        e.getFieldKeys().add("invstatus");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("adminorg");
        e.getFieldKeys().add("costdiff");
        e.getFieldKeys().add("costelement");
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("baldetailid");
        e.getFieldKeys().add("tracknumber");
        e.getFieldKeys().add("configuredcode");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (String entryField : exFieldSet) {
            e.getFieldKeys().add("entryentity." + entryField);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostUpdateApplyBillAuditValidator(){});
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] applybills = e.getDataEntities();
        new CostUpdateApplyBillAuditHelper().exeAudit(applybills);
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject applybill : applybills) {
            if (applybill.get("bookdate") == null) {
                applybill.set("bookdate", applybill.get("bizdate"));
            }
            if (null != applybill.get("lastupdateuser")) continue;
            applybill.set("lastupdateuser", (Object)userDyc);
            applybill.set("lastupdatetime", (Object)new Date());
        }
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] applybills = e.getDataEntities();
        try {
            this.StartSyncBizBill(applybills);
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
        super.afterExecuteOperationTransaction(e);
    }

    private void StartSyncBizBill(DynamicObject[] applybills) {
        HashMap calOrgMaterialMap = new HashMap(16);
        for (DynamicObject applyBill : applybills) {
            Long calorg = applyBill.getDynamicObject("calorg").getLong("id");
            HashSet<Long> materials = new HashSet<Long>(16);
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                Long material = dynamicObject.getDynamicObject("material").getLong("id");
                materials.add(material);
            }
            if (calorg == null || calorg == 0L || materials.isEmpty()) continue;
            Set materialids = (Set)calOrgMaterialMap.get(calorg);
            if (materialids == null) {
                calOrgMaterialMap.put(calorg, materials);
                continue;
            }
            materialids.addAll(materials);
        }
        HashSet calOrgSet = new HashSet(32);
        boolean isstopsync = false;
        for (Map.Entry entry : calOrgMaterialMap.entrySet()) {
            calOrgSet.add(entry.getKey());
            new StopSyncSettingModifyHelper().modifySetting(calOrgSet, null, "", null, (Set)entry.getValue(), isstopsync, TimeServiceHelper.now());
            calOrgSet.clear();
        }
    }
}

