/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.validator.CostUpdateApplyBillSubmitValidator;
import kd.fi.cal.opplugin.validator.MTOValidator;

public class CostUpdateApplyBillSubmitOp
extends AbstractOperationServicePlugIn {
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("storageorgunit");
        e.getFieldKeys().add("ownertype");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("mversion");
        e.getFieldKeys().add("assist");
        e.getFieldKeys().add("lot");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("invtype");
        e.getFieldKeys().add("invstatus");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("adminorg");
        e.getFieldKeys().add("costdiff");
        e.getFieldKeys().add("costelement");
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("baldetailid");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("unitcost");
        e.getFieldKeys().add("cost");
        e.getFieldKeys().add("newunitcost");
        e.getFieldKeys().add("newcost");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (String entryField : exFieldSet) {
            e.getFieldKeys().add("entryentity." + entryField);
        }
        e.getFieldKeys().add("entryentity.configuredcode");
        e.getFieldKeys().add("entryentity.tracknumber");
        e.getFieldKeys().add("entryentity.seq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] applybills = e.getDataEntities();
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject applybill : applybills) {
            if (!"submit".equals(e.getOperationKey())) continue;
            if (applybill.get("bookdate") == null) {
                applybill.set("bookdate", applybill.get("bizdate"));
            }
            applybill.set("lastupdateuser", (Object)userDyc);
            applybill.set("lastupdatetime", (Object)new Date());
        }
        Set<Object> balDetailIds = this.StopSyncBizBill(applybills);
        this.updateApplyBills(applybills, balDetailIds);
        super.beginOperationTransaction(e);
    }

    private void updateApplyBills(DynamicObject[] applybills, Set<Object> balDetailIds) {
        DataSet balDetailDataSet;
        QFilter qbalDetail = new QFilter("id", "in", balDetailIds);
        String entity = "cal_balance_detail";
        String select = "id,periodendqty,periodendactualcost";
        if (this.isNewBalance) {
            entity = "cal_bal";
            select = "id,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost";
        } else {
            qbalDetail.and("periodendqty", "!=", (Object)0);
        }
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (!this.isNewBalance || !balCompress) {
            if (this.isNewBalance) {
                qbalDetail.and("baseqty_bal", "!=", (Object)0);
            }
            balDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)select, (QFilter[])qbalDetail.toArray(), null);
        } else {
            ArrayList<QFilter> ql = new ArrayList<QFilter>();
            ql.add(qbalDetail);
            balDetailDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, null, ql).where(new QFilter("baseqty_bal", "!=", (Object)0).toString()).select(select);
        }
        HashMap<String, BigDecimal> baseqtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>();
        int newSize = 0;
        for (Row row : balDetailDataSet) {
            ++newSize;
            String balDetailid = row.getString("id");
            BigDecimal baseqty = row.getBigDecimal("periodendqty");
            BigDecimal cost = row.getBigDecimal("periodendactualcost");
            baseqtyMap.put(balDetailid, baseqty);
            costMap.put(balDetailid, cost);
        }
        int oldSize = 0;
        for (DynamicObject applyBill : applybills) {
            StringBuilder msg = new StringBuilder();
            Date now = TimeServiceHelper.now();
            applyBill.set("bizdate", (Object)now);
            applyBill.set("bookdate", (Object)now);
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entryentity");
            oldSize = entry.size() + oldSize;
            String billno = applyBill.getString("billno");
            HashSet<String> errorRowIndex = new HashSet<String>();
            DynamicObject currency = applyBill.getDynamicObject("currency");
            int amtPrecision = 10;
            if (currency != null) {
                amtPrecision = currency.getInt("amtprecision");
            }
            for (int i = entry.size() - 1; i >= 0; --i) {
                DynamicObject dynamicObject = (DynamicObject)entry.get(i);
                String balDetailid = dynamicObject.getString("baldetailid");
                BigDecimal baseqty = (BigDecimal)baseqtyMap.get(balDetailid);
                BigDecimal cost = (BigDecimal)costMap.get(balDetailid);
                BigDecimal newunitcost = dynamicObject.getBigDecimal("newunitcost");
                BigDecimal bigDecimal = cost = cost == null ? BigDecimal.ZERO : cost;
                if (baseqty != null && newunitcost != null) {
                    BigDecimal unitcost = cost.divide(baseqty, 10, RoundingMode.HALF_UP);
                    BigDecimal newcost = newunitcost.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP);
                    BigDecimal costdiff = newcost.subtract(cost);
                    if (costdiff.compareTo(BigDecimal.ZERO) != 0) {
                        dynamicObject.set("baseqty", (Object)baseqty);
                        dynamicObject.set("cost", (Object)cost);
                        dynamicObject.set("unitcost", (Object)unitcost);
                        dynamicObject.set("newcost", (Object)newcost);
                        dynamicObject.set("costdiff", (Object)costdiff);
                        continue;
                    }
                    errorRowIndex.add(i + 1 + "");
                    continue;
                }
                errorRowIndex.add(i + 1 + "");
            }
            if (errorRowIndex.isEmpty()) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\uff1a%1$s\uff0c\u7b2c%2$s\u884c,\u7531\u4e8e\u4e1a\u52a1\u64cd\u4f5c\u5bfc\u81f4\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5220\u9664\u76f8\u5e94\u884c\u540e\u91cd\u65b0\u5f55\u5165\u6570\u636e\u3002", (String)"CostUpdateApplyBillSubmitOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), billno, String.join((CharSequence)",", errorRowIndex));
            throw new KDBizException(errorMsg);
        }
    }

    private Set<Object> StopSyncBizBill(DynamicObject[] applybills) {
        HashSet<Object> balDetailIds = new HashSet<Object>();
        HashMap calOrgMaterialMap = new HashMap();
        for (DynamicObject applyBill : applybills) {
            Long calorg = applyBill.getDynamicObject("calorg").getLong("id");
            HashSet<Long> materials = new HashSet<Long>();
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                long material = dynamicObject.getDynamicObject("material").getLong("id");
                Object balDetailid = dynamicObject.get("baldetailid");
                materials.add(material);
                balDetailIds.add(balDetailid);
            }
            if (calorg == null || calorg == 0L || materials.isEmpty()) continue;
            Set materialids = (Set)calOrgMaterialMap.get(calorg);
            if (materialids == null) {
                calOrgMaterialMap.put(calorg, materials);
                continue;
            }
            materialids.addAll(materials);
        }
        HashSet calOrgSet = new HashSet(32);
        boolean isstopsync = true;
        for (Map.Entry entry : calOrgMaterialMap.entrySet()) {
            calOrgSet.add(entry.getKey());
            new StopSyncSettingModifyHelper().modifySetting(calOrgSet, null, "", null, (Set)entry.getValue(), isstopsync, TimeServiceHelper.now());
            calOrgSet.clear();
        }
        return balDetailIds;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CostUpdateApplyBillSubmitValidator());
        e.addValidator((AbstractValidator)new MTOValidator());
    }
}

