/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class CostUpdateApplyBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] applybills;
        HashSet applyids = new HashSet(32);
        for (DynamicObject dynamicObject : applybills = e.getDataEntities()) {
            Iterator applyid = dynamicObject.getPkValue();
            applyids.add(applyid);
        }
        QFilter q = new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costupdateapplybill");
        q.and("entryentity.invbillid", "in", applyids);
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity");
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.setLength(fields.length() - 1);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)fields.toString(), (QFilter[])new QFilter[]{q});
        if (infos == null || infos.length == 0) {
            return;
        }
        Set billids = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            billids.add(info.getLong("id"));
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (DynamicObject[])infos, (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!errors.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder(ResManager.loadKDString((String)"\u4e0b\u6e38\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"CostUpdateApplyBillUnAuditOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
                errorMsg.append('\n');
            }
            throw new KDBizException(errorMsg.toString());
        }
        if (!(billids = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", billids)).isEmpty()) {
            QFilter filter = new QFilter("id", "in", billids);
            DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{filter});
        }
        super.beginOperationTransaction(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("material");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashSet<Object> applyids = new HashSet<Object>(32);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    Object applyid = dynamicObject.getPkValue();
                    applyids.add(applyid);
                }
                QFilter q = new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costupdateapplybill");
                q.and("entryentity.invbillid", "in", applyids);
                DataSet costadjustDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)"id,costaccount,bizdate,isvoucher,entryentity.invbillid,srcsys", (QFilter[])q.toArray(), null).groupBy(new String[]{"id", "costaccount", "bizdate", "isvoucher", "entryentity.invbillid", "srcsys"}).finish();
                HashMap currentPeriodBeginDateMap = new HashMap();
                HashSet<String> isvoucherId = new HashSet<String>(16);
                HashSet<String> notCurrentperiodIds = new HashSet<String>(16);
                for (Row row : costadjustDataset) {
                    long costaccount = row.getLong("costaccount");
                    Date bizdate = row.getDate("bizdate");
                    boolean isvoucher = row.getBoolean("isvoucher");
                    String applybillId = row.getString("entryentity.invbillid");
                    String srcsys = row.getString("srcsys");
                    if (isvoucher) {
                        isvoucherId.add(applybillId);
                        continue;
                    }
                    Date currentPeriodBeginDate = (Date)currentPeriodBeginDateMap.get(costaccount);
                    if (currentPeriodBeginDate == null) {
                        DynamicObject enablePeriod = PeriodHelper.getCurrentPeriod((Long)costaccount);
                        if (enablePeriod == null) {
                            notCurrentperiodIds.add(applybillId);
                        } else {
                            currentPeriodBeginDate = enablePeriod.getDate("begindate");
                        }
                    }
                    if (currentPeriodBeginDate == null || !bizdate.before(currentPeriodBeginDate) || !StringUtils.isEmpty((String)srcsys) && "C".equals(srcsys)) continue;
                    notCurrentperiodIds.add(applybillId);
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    String srcsys = dynamicObject.getString("srcsys");
                    String applyId = dynamicObject.getPkValue().toString();
                    if (!"A".equals(srcsys)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u975e\u5b58\u8d27\u6838\u7b97\u7684\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostUpdateApplyBillUnAuditOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (isvoucherId.contains(applyId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\u751f\u6210\u7684\u6210\u672c\u8c03\u6574\u5355\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostUpdateApplyBillUnAuditOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!notCurrentperiodIds.contains(applyId)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\u751f\u6210\u7684\u6210\u672c\u8c03\u6574\u5355\u4e3a\u5f80\u671f\u6570\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostUpdateApplyBillUnAuditOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

