/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.common.constant.CommonConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.opplugin.bill.FeeBackSqlParams;

public class FeeBackShareOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FeeBackShareOp.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("sharedate");
        e.getFieldKeys().add("entry.billentryid");
        e.getFieldKeys().add("entry.ismianbill");
        e.getFieldKeys().add("entry.expenseitem");
        e.getFieldKeys().add("entry.calentryid");
        e.getFieldKeys().add("writeofftypeid");
        e.getFieldKeys().add("org");
        if (this.billEntityType.getName().equals("cal_feeshare_newrecord")) {
            e.getFieldKeys().add("entry.billid");
            e.getFieldKeys().add("entry.billtypeid");
            e.getFieldKeys().add("wfnumber");
        } else {
            e.getFieldKeys().add("entry.billtypeid");
            e.getFieldKeys().add("entry.billtype");
            e.getFieldKeys().add("billno");
        }
        e.getFieldKeys().add("entry.costpricesource");
        e.getFieldKeys().add("entry.shareamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] feeShareRecordArray = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject feeShareRecord : feeShareRecordArray) {
            DynamicObjectCollection entrys = feeShareRecord.getDynamicObjectCollection("entry");
            boolean isNewRecord = this.isNewRecord(feeShareRecord);
            for (DynamicObject entry : entrys) {
                if (isNewRecord) {
                    ids.add(entry.getLong("billid"));
                    continue;
                }
                ids.add(entry.getLong("billtypeid"));
            }
        }
        DataSet costRecord = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,bizbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Row row : costRecord) {
            bizBillIds.add(row.getLong("bizbillid"));
        }
        BackFeeShareResult backFeeShareResult = new BackFeeShareResult();
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillIds)});){
            ctx.set();
            this.backShareOp(feeShareRecordArray, backFeeShareResult);
        }
        this.insertOpLog(backFeeShareResult);
        this.getOperationResult().setMessage(backFeeShareResult.getResultMsg());
    }

    private void insertOpLog(BackFeeShareResult backFeeShareResult) {
        Map<String, StringBuilder> logInfoMap = backFeeShareResult.getLogInfos();
        ArrayList<CalLogInfo> logInfos = new ArrayList<CalLogInfo>(16);
        String opName = ResManager.loadKDString((String)"\u53cd\u5206\u644a", (String)"FeeBackShareOp_14", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        String successMsg = ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\u53cd\u5206\u644a\u6210\u529f\u3002", (String)"FeeBackShareOp_15", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        String errorMsg = ResManager.loadKDString((String)"\u7f16\u53f7\u3010%1$s\u3011\u53cd\u5206\u644a\u5931\u8d25\uff1a%2$s", (String)"FeeBackShareOp_16", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        for (Map.Entry<String, StringBuilder> loginfo : logInfoMap.entrySet()) {
            String description;
            String[] key = loginfo.getKey().split("#");
            long orgId = Long.parseLong(key[0]);
            StringBuilder msg = loginfo.getValue();
            if (msg.length() <= 0) {
                description = String.format(successMsg, key[1]);
                logInfos.add(CalLogUtils.buildCalAppLog((String)this.billEntityType.getName(), (String)opName, (String)description, (long)orgId));
                continue;
            }
            description = String.format(errorMsg, key[1], msg.toString());
            logInfos.add(CalLogUtils.buildCalAppLog((String)this.billEntityType.getName(), (String)opName, (String)description, (long)orgId));
        }
        CalLogUtils.addBatchLog(logInfos);
    }

    private boolean isNewRecord(DynamicObject feeShareRecord) {
        return feeShareRecord.getDataEntityType().getName().equals("cal_feeshare_newrecord");
    }

    private void backShareOp(DynamicObject[] feeShareRecordArray, BackFeeShareResult backFeeShareResult) {
        HashSet<Long> mainEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : feeShareRecordArray) {
            try {
                boolean isEstFeeShare;
                backFeeShareResult.isBackFeeShare = true;
                long infoId = info.getLong("id");
                Date feeShareDate = info.getDate("sharedate");
                boolean isNewRecord = this.isNewRecord(info);
                String billnoField = isNewRecord ? "wfnumber" : "billno";
                String infoBillNo = info.getString(billnoField);
                Long org = info.getLong("org.id");
                backFeeShareResult.setCurrentRecordNum(org + "#" + infoBillNo);
                FeeBackSqlParams feeBackSqlParams = new FeeBackSqlParams(infoId, feeShareDate);
                feeBackSqlParams.setInfoBillNo(infoBillNo);
                Set<Long> expenseitemIds = this.getExpenseitemId(info);
                long writeofftypeid = info.getLong("writeofftypeid.id");
                boolean isWriteOffFeeShare = Long.compare(writeofftypeid, 0L) != 0;
                boolean bl = isEstFeeShare = CommonConstant.HXLB_ESTFEE_SHARE.compareTo(writeofftypeid) == 0;
                if (isEstFeeShare) {
                    this.buildBackEstFeeShare(backFeeShareResult, feeBackSqlParams, expenseitemIds);
                } else {
                    this.buildBackFeeShare(backFeeShareResult, feeBackSqlParams, expenseitemIds);
                }
                if (isEstFeeShare) {
                    mainEntryIds.addAll(this.checkEstFeeShare(info, backFeeShareResult, feeBackSqlParams, isWriteOffFeeShare));
                } else {
                    mainEntryIds.addAll(this.checkFeeShare(info, backFeeShareResult, feeBackSqlParams, expenseitemIds));
                }
                if (!mainEntryIds.isEmpty() && mainEntryIds.containsAll(feeBackSqlParams.getMainBillMap().keySet())) {
                    backFeeShareResult.increaseFaultCount();
                    continue;
                }
                if (!isEstFeeShare) {
                    this.buildCostAdjustFee(backFeeShareResult, feeBackSqlParams);
                    this.buildStdCostDiffBillFee(backFeeShareResult, feeBackSqlParams);
                }
                this.judgeFeeShareDate(backFeeShareResult, feeBackSqlParams);
                if (!backFeeShareResult.isBackFeeShare) {
                    backFeeShareResult.increaseFaultCount();
                    continue;
                }
                if (!isEstFeeShare) {
                    this.buildTotalFeeShare(infoId, feeBackSqlParams);
                }
                this.buildMainBillMap(info, feeBackSqlParams, isEstFeeShare);
                try (TXHandle h1 = TX.requiresNew();){
                    try {
                        this.doSqlOp(feeBackSqlParams, isEstFeeShare);
                        backFeeShareResult.increaseSuccessCount();
                    }
                    catch (Exception e) {
                        WriteLogHelper.writeErrorLog((Log)logger, (Throwable)e);
                        backFeeShareResult.increaseFaultCount();
                        String message = CommonUtils.getLogMessage((Throwable)e);
                        backFeeShareResult.appendMsg(message);
                        h1.markRollback();
                    }
                }
            }
            catch (Exception e) {
                WriteLogHelper.writeErrorLog((Log)logger, (Throwable)e);
                backFeeShareResult.increaseFaultCount();
                String message = CommonUtils.getLogMessage((Throwable)e);
                backFeeShareResult.appendMsg(message);
            }
        }
    }

    private Set<Long> getExpenseitemId(DynamicObject info) {
        HashSet<Long> expenseitemIds = new HashSet<Long>();
        DynamicObjectCollection expenseitem = info.getDynamicObjectCollection("entry");
        DynamicObject expenseitemObj = null;
        for (DynamicObject dynamic : expenseitem) {
            expenseitemObj = dynamic.getDynamicObject("expenseitem");
            if (expenseitemObj == null) {
                return expenseitemIds;
            }
            expenseitemIds.add(dynamic.getDynamicObject("expenseitem").getLong("id"));
        }
        return expenseitemIds;
    }

    private void buildTotalFeeShare(long infoId, FeeBackSqlParams feeBackSqlParams) {
        DynamicObjectCollection totalFeeShareDynamic = QueryServiceHelper.query((String)"cal_fee_totalsharefee", (String)"costrecordentryid,totalfee", (QFilter[])new QFilter("feeshareid", "=", (Object)infoId).toArray());
        for (DynamicObject dynamic : totalFeeShareDynamic) {
            long entryId = dynamic.getLong("costrecordentryid");
            feeBackSqlParams.addEntryIdObj(entryId);
            BigDecimal adjustAmt = dynamic.getBigDecimal("totalfee");
            feeBackSqlParams.setCostAdjustObj(entryId, adjustAmt);
            feeBackSqlParams.setStdCostDiffBillObj(entryId, adjustAmt);
        }
    }

    private void buildMainBillMap(DynamicObject info, FeeBackSqlParams feeBackSqlParams, boolean isEstFeeShare) {
        DynamicObjectCollection mainBillEntrty = info.getDynamicObjectCollection("entry");
        long bEntyId = 0L;
        boolean ismianbill = false;
        boolean isNewRecord = this.isNewRecord(info);
        DynamicObject writeofftypeid = info.getDynamicObject("writeofftypeid");
        for (DynamicObject dynamicObject : mainBillEntrty) {
            ismianbill = dynamicObject.getBoolean("ismianbill");
            if (!ismianbill) continue;
            bEntyId = dynamicObject.getLong("billentryid");
            if (isEstFeeShare) {
                feeBackSqlParams.addMainBillMap(bEntyId, "t_ap_busbillentry");
            } else {
                feeBackSqlParams.addMainBillMap(bEntyId, "t_ap_finapbilldetailentry");
            }
            BigDecimal shareamount = dynamicObject.getBigDecimal("shareamount");
            feeBackSqlParams.setMainBillFeeParams(new Object[]{shareamount, shareamount, bEntyId});
            if (isNewRecord) {
                feeBackSqlParams.setMainBillId(dynamicObject.getLong("billid"));
                break;
            }
            feeBackSqlParams.setMainBillId(dynamicObject.getLong("billtypeid"));
            break;
        }
    }

    private void judgeFeeShareDate(BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams) {
        Date maxDate = null;
        if (!feeBackSqlParams.getCostAccountIdList().isEmpty()) {
            for (int i = 0; i < feeBackSqlParams.getCostAccountIdList().size(); ++i) {
                Date periodDate;
                DynamicObject value = PeriodHelper.getCurrentPeriod((Long)feeBackSqlParams.getCostAccountIdList().get(i));
                if (value == null || (periodDate = value.getDate("beginDate")) == null) continue;
                maxDate = maxDate == null ? periodDate : (maxDate.compareTo(periodDate) >= 0 ? maxDate : periodDate);
            }
            if (feeBackSqlParams.getFeeShareDate().compareTo(maxDate) < 0) {
                backFeeShareResult.appendMsg("\r\n" + String.format(ResManager.loadKDString((String)"\u52fe\u7a3d\u5e8f\u53f7\u201c%1$s\u201d\u7684\u5206\u644a\u65e5\u671f\u5728\u5f80\u671f\u3002", (String)"FeeBackShareOp_18", (String)"fi-cal-opplugin", (Object[])new Object[0]), feeBackSqlParams.getInfoBillNo()));
                backFeeShareResult.setIsBackFeeShareFalse();
            }
        }
    }

    private void buildCostAdjustFee(BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams) {
        DynamicObject[] costAdjustBillList;
        for (DynamicObject costAdjustBill : costAdjustBillList = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"id,billno,costaccount,costaccount.id,isvoucher,entryentity.srcbillid,entryentity.id,createtype,entryentity.invbillentryid,entryentity.adjustamt,entryentity.feesharetotalamt,entryentity.srcbizentityobject", (QFilter[])new QFilter[]{new QFilter("feeshareflag", "=", (Object)feeBackSqlParams.getInfoId())})) {
            feeBackSqlParams.addCostAdjustBillIdSet(costAdjustBill.getLong("id"));
            boolean isvoucher = costAdjustBill.getBoolean("isvoucher");
            if (isvoucher) {
                String content = String.format("\r\n" + ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostEstimateBillCancelOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), costAdjustBill.get("billno"));
                backFeeShareResult.appendMsg(content);
                backFeeShareResult.setIsBackFeeShareFalse();
                break;
            }
            if (CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue().equals(costAdjustBill.getString("createtype"))) {
                Long srcbillid = ((DynamicObject)costAdjustBill.getDynamicObjectCollection("entryentity").get(0)).getLong("srcbillid");
                feeBackSqlParams.addiCostAdjustBillId(srcbillid);
            }
            feeBackSqlParams.addCostAccountId(costAdjustBill.getLong("costaccount.id"));
            DynamicObjectCollection costAdjustBillEntrys = costAdjustBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject costAdjustBillEntry : costAdjustBillEntrys) {
                feeBackSqlParams.addCostAdjustBillEntryId(costAdjustBillEntry.getLong("id"));
            }
        }
    }

    private void buildStdCostDiffBillFee(BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams) {
        DynamicObject[] costAdjustBillList;
        for (DynamicObject costAdjustBill : costAdjustBillList = BusinessDataServiceHelper.load((String)"cal_stdcostdiffbill", (String)"id,billno,costaccount,costaccount.id,isvoucher,entryentity.srcbillid,entryentity.id,createtype,entryentity.invbillentryid,entryentity.adjustamt,entryentity.feesharetotalamt,entryentity.srcbizentityobject", (QFilter[])new QFilter[]{new QFilter("feeshareflag", "=", (Object)feeBackSqlParams.getInfoId())})) {
            feeBackSqlParams.addStdCostDiffBillIdSet(costAdjustBill.getLong("id"));
            boolean isvoucher = costAdjustBill.getBoolean("isvoucher");
            if (isvoucher) {
                String content = String.format("\r\n" + ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostEstimateBillCancelOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), costAdjustBill.get("billno"));
                backFeeShareResult.appendMsg(content);
                backFeeShareResult.setIsBackFeeShareFalse();
                break;
            }
            if (CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue().equals(costAdjustBill.getString("createtype"))) {
                Long srcbillid = ((DynamicObject)costAdjustBill.getDynamicObjectCollection("entryentity").get(0)).getLong("srcbillid");
                feeBackSqlParams.addiStdCostDiffBillId(srcbillid);
            }
            feeBackSqlParams.addCostAccountId(costAdjustBill.getLong("costaccount.id"));
            DynamicObjectCollection costAdjustBillEntrys = costAdjustBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject costAdjustBillEntry : costAdjustBillEntrys) {
                feeBackSqlParams.addStdCostDiffBillEntryId(costAdjustBillEntry.getLong("id"));
            }
        }
    }

    private void buildBackFeeShare(BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams, Set<Long> expenseitemIds) {
        if (expenseitemIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection feeShareDetailList = QueryServiceHelper.query((String)"cal_fee_sharedetail", (String)"costaccount.id,costrecordid,expenseitem.id,entryid,shareamount,realshareamount", (QFilter[])new QFilter("sharercdid", "=", (Object)feeBackSqlParams.getInfoId()).toArray());
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> feeShareDetalMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject feeShareDetail : feeShareDetailList) {
            long entryId = feeShareDetail.getLong("entryid");
            feeShareDetalMap.put(entryId, feeShareDetail);
            entryIdSet.add(entryId);
            feeBackSqlParams.addCostAccountId(feeShareDetail.getLong("costaccount.id"));
        }
        long infoId = feeBackSqlParams.getInfoId();
        DynamicObjectCollection costRecordCollection = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno,calorg.id,costaccount.costtype.id,costaccount.calpolicy.calbycostelement,entry.material,entry.material.id,isfivoucher,isfeevoucher,localcurrency.amtprecision,costaccount.id,entry.id,entry.fee,entry.bizbillentryid,entry.calentryid,entry.totalsharefee,entry.baseqty,entry.materialcost,entry.actualcost,entry.unitactualcost,entry.subentryentity.expenseitem.id,entry.costpricesource as costpricesource", (QFilter[])new QFilter("entry.id", "in", entryIdSet).and("entry.subentryentity.sharercdid", "=", (Object)infoId).and("entry.subentryentity.expenseitem.id", "in", expenseitemIds).toArray());
        if (costRecordCollection.isEmpty()) {
            return;
        }
        for (DynamicObject costRecord : costRecordCollection) {
            long entryId = costRecord.getLong("entry.id");
            DynamicObject feeShareDetail = (DynamicObject)feeShareDetalMap.get(entryId);
            if (costRecord.getBoolean("isfivoucher") || costRecord.getBoolean("isfeevoucher")) {
                String content = String.format("\r\n" + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5355\u636e\u201c%1$s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"FeeBackShareOp_10", (String)"fi-cal-opplugin", (Object[])new Object[0]), costRecord.get("billno"));
                backFeeShareResult.appendMsg(content);
                backFeeShareResult.setIsBackFeeShareFalse();
                break;
            }
            feeBackSqlParams.addBackFeeShareParams(costRecord, feeShareDetail);
        }
        Map returnMap = FeeShareHelper.getBackFeeShareElementMap((DynamicObjectCollection)costRecordCollection);
        feeBackSqlParams.setCostDetailList(returnMap, costRecordCollection, feeShareDetalMap);
    }

    private void buildBackEstFeeShare(BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams, Set<Long> expenseitemIds) {
        long infoId = feeBackSqlParams.getInfoId();
        DynamicObjectCollection costRecordCollection = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"id as costrecordid,billno,calorg.id,costaccount.costtype.id,costaccount.calpolicy.calbycostelement,entry.material,entry.material.id,isfivoucher,isfeevoucher,localcurrency.amtprecision,costaccount.id,entry.id,entry.fee,entry.bizbillentryid,entry.calentryid,entry.totalsharefee,entry.baseqty,entry.materialcost,entry.actualcost,entry.unitactualcost,entry.subentryentityest.sharedetailexitem as expenseitem.id,entry.subentryentityest.sharedetailexitem as entry.subentryentity.expenseitem.id,entry.subentryentityest.sharedetailamt as shareamount", (QFilter[])new QFilter("entry.subentryentityest.estimatebillid", "=", (Object)infoId).toArray());
        if (costRecordCollection.isEmpty()) {
            return;
        }
        for (DynamicObject costRecord : costRecordCollection) {
            feeBackSqlParams.addCostAccountId(costRecord.getLong("costaccount.id"));
            long entryId = costRecord.getLong("entry.id");
            if (costRecord.getBoolean("isfivoucher") || costRecord.getBoolean("isfeevoucher")) {
                String content = String.format("\r\n" + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5355\u636e\u201c%1$s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"FeeBackShareOp_10", (String)"fi-cal-opplugin", (Object[])new Object[0]), costRecord.get("billno"));
                backFeeShareResult.appendMsg(content);
                backFeeShareResult.setIsBackFeeShareFalse();
                break;
            }
            feeBackSqlParams.addBackEstFeeShareParams(costRecord);
        }
        Map returnMap = FeeShareHelper.getBackFeeShareElementMap((DynamicObjectCollection)costRecordCollection);
        feeBackSqlParams.setEstCostDetailList(returnMap, costRecordCollection);
    }

    private void doSqlOp(FeeBackSqlParams feeBackSqlParams, boolean isEstFeeShare) {
        this.updateCostRecord(feeBackSqlParams, isEstFeeShare);
        this.updateCostAdjust(feeBackSqlParams.getCostAdjustObj(), feeBackSqlParams.getCostAdjustBillId(), feeBackSqlParams.getInfoId(), feeBackSqlParams.getCostAdjustBillEntryId());
        this.updateStdCostDiffBill(feeBackSqlParams.getStdCostDiffBillObj(), feeBackSqlParams.getStdCostDiffBillId(), feeBackSqlParams.getInfoId(), feeBackSqlParams.getStdCostDiffBillEntryId());
        this.deleteFeeShareRecord(feeBackSqlParams.getInfoId(), isEstFeeShare);
        this.updateCostEstimate(feeBackSqlParams.getEntryIdObj());
        this.updateEstCostAdjustBill(feeBackSqlParams.getiCostAdjustBillId());
        this.updateEstStdCostDiffBill(feeBackSqlParams.getiStdCostDiffBillId());
        this.updateBalance(feeBackSqlParams.getEntryIdObj(), feeBackSqlParams);
        String ignorefiroute = (String)this.getOption().getVariables().get("ignorefiroute");
        if ("true".equals(ignorefiroute)) {
            return;
        }
        try (TXHandle h2 = TX.requiresNew();){
            try {
                this.updateMainBill(feeBackSqlParams.getMainBillMap());
                this.updateMainBillFee(feeBackSqlParams, isEstFeeShare);
            }
            catch (Exception e) {
                WriteLogHelper.writeErrorLog((Log)logger, (Throwable)e);
                h2.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\r\n\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5199\u5931\u8d25\u3002", (String)"FeeBackShareOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateMainBillFee(FeeBackSqlParams feeBackSqlParams, boolean isEstFeeShare) {
        String table = "t_ap_finapbill";
        String entryTable = "t_ap_finapbilldetailentry_e";
        if (isEstFeeShare) {
            table = "t_ap_busbill";
            entryTable = "t_ap_busbillentry_e";
        }
        if (feeBackSqlParams.getMainBillId() != 0L && feeBackSqlParams.getMainBillFeeParams() != null) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)table, (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("id", FilterType.eq, (Object)feeBackSqlParams.getMainBillId())});){
                ctx.set();
                DB.execute((DBRoute)new DBRoute("fi"), (String)("update " + entryTable + " set fallocatedamt = fallocatedamt - ?,funallocatedamt = funallocatedamt + ? where fallocatedamt <> 0 and fentryid = ?"), (Object[])feeBackSqlParams.getMainBillFeeParams());
            }
        }
    }

    private void updateEstCostAdjustBill(List<Object[]> getiCostAdjustBillId) {
        if (getiCostAdjustBillId.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getEstCostAdjustBillUpdateSql(), getiCostAdjustBillId);
    }

    private void updateEstStdCostDiffBill(List<Object[]> getiCostAdjustBillId) {
        if (getiCostAdjustBillId.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getEstStdCostDiffBillUpdateSql(), getiCostAdjustBillId);
    }

    private String getEstCostAdjustBillUpdateSql() {
        return "update t_cal_costadjustbill set fcheckstrikeaccount  = 0 where FId = ? ";
    }

    private String getEstStdCostDiffBillUpdateSql() {
        return "update t_cal_stdcostdiff set fcheckstrikeaccount  = 0 where FId = ? ";
    }

    private void updateBalance(List<Object> entryIdObj, FeeBackSqlParams feeBackSqlParams) {
        List<Object[]> backFeeshareParams = feeBackSqlParams.getBackFeeshareParams();
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        for (Object[] param : backFeeshareParams) {
            costRecordIds.add(Long.valueOf(param[4].toString()));
        }
        if (this.isNewBalance) {
            HashSet<Long> idSet = new HashSet<Long>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter("entry.id", "in", entryIdObj).toArray(), null);){
                for (Row row : dataSet) {
                    idSet.add(row.getLong("id"));
                }
            }
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.FEE_DIVIDE_CANCEL);
        } else {
            BalanceCalculator calculator = new BalanceCalculator();
            calculator.updateBalance4Others(entryIdObj.toArray(new Object[entryIdObj.size()]), BalanceSourceEnum.FEE_DIVIDE_CANCEL, costRecordIds);
        }
    }

    private void updateMainBill(Map<Long, String> mainBillMap) {
        if (!mainBillMap.isEmpty()) {
            String mainBillTable;
            HashMap<String, Set> map = new HashMap<String, Set>(16);
            for (Map.Entry<Long, String> entry : mainBillMap.entrySet()) {
                Long entryid = entry.getKey();
                mainBillTable = entry.getValue();
                Set entryids = map.computeIfAbsent(mainBillTable, k -> new HashSet(16));
                entryids.add(entryid);
            }
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                Set entryids = (Set)((Object)entry.getValue());
                mainBillTable = (String)((Object)entry.getKey());
                this.updateMainBillDB(entryids, mainBillTable);
            }
        }
    }

    private void updateMainBillDB(Set<Long> entryids, String mainBillTable) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("update ", new Object[0]);
        builder.append(mainBillTable, new Object[0]);
        builder.append(" set fisallocate = '0' where ", new Object[0]);
        builder.appendIn("fentryid", entryids.toArray());
        DB.execute((DBRoute)new DBRoute("fi"), (SqlBuilder)builder);
    }

    private void deleteFeeShareRecord(Long infoId, boolean isEstFeeShare) {
        if (infoId != null) {
            ArrayList<Object[]> costRecordDetailParams = new ArrayList<Object[]>();
            Object[] costRecordDetail = new Object[]{infoId};
            costRecordDetailParams.add(costRecordDetail);
            if (isEstFeeShare) {
                DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getEstFeeShareRecordDetailSql(), costRecordDetailParams);
            } else {
                DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getShareRecordDetailSql(), costRecordDetailParams);
            }
            DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getShareRecordSql(), costRecordDetailParams);
            DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getShareRecordEntrySql(), costRecordDetailParams);
        }
    }

    private DBRoute getDbRoute(String route) {
        return new DBRoute(route);
    }

    private void updateCostAdjust(List<Object[]> costAdjustObj, Set<Long> costAdjustBillId, Long infoId, List<Object[]> costAdjustBillEntryId) {
        if (!costAdjustObj.isEmpty()) {
            DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getFeeCostUpdateSql(), costAdjustObj);
            DeleteServiceHelper.delete((String)"cal_fee_totalsharefee", (QFilter[])new QFilter("feeshareid", "=", (Object)infoId).toArray());
        }
        if (costAdjustBillId.isEmpty()) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])costAdjustBillId.toArray(), (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder strContain = new StringBuilder(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FeeBackShareOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                strContain.append("\r\n");
                strContain.append(operror.getMessage());
            }
            strContain.append(result.getMessage());
            throw new KDBizException(strContain.toString());
        }
        Set deleteIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", costAdjustBillId);
        if (!deleteIds.isEmpty()) {
            QFilter deleFilter = new QFilter("id", "in", (Object)deleteIds);
            DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
        }
        PrevCostAdjustProcessHelper helper = new PrevCostAdjustProcessHelper();
        helper.unAduitAndDelAdjustBill(costAdjustBillId);
    }

    private void updateStdCostDiffBill(List<Object[]> costAdjustObj, Set<Long> costAdjustBillId, Long infoId, List<Object[]> costAdjustBillEntryId) {
        if (costAdjustBillId == null || costAdjustBillId.isEmpty()) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])costAdjustBillId.toArray(), (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder strContain = new StringBuilder(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u53cd\u5ba1\u6838\u5931\u8d25.", (String)"FeeBackShareOp_19", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                strContain.append(operror.getMessage());
            }
            strContain.append(result.getMessage());
            throw new KDBizException(strContain.toString());
        }
        Set deleteIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_stdcostdiffbill", costAdjustBillId);
        if (!deleteIds.isEmpty()) {
            QFilter deleFilter = new QFilter("id", "in", (Object)deleteIds);
            DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
        }
    }

    private Set<Long> checkEstFeeShare(DynamicObject feeShareRecordInfo, BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams, boolean isWriteOffFeeShare) {
        String content;
        HashSet<String> isvoucherBillnos;
        HashSet<String> feeSharedBillnos;
        HashSet<String> isvoucherStdCostDiffBillno;
        HashSet<String> strikeStdCostDiffBillno;
        HashSet<String> isvoucherCostAdjustBillno;
        HashSet<String> strikeCostAdjustBillno;
        HashSet<Long> mainEntryIds;
        HashSet<Long> errorMainEntryIds;
        block70: {
            Object row2;
            long infoId = feeBackSqlParams.getInfoId();
            errorMainEntryIds = new HashSet<Long>(16);
            DynamicObjectCollection entry = feeShareRecordInfo.getDynamicObjectCollection("entry");
            mainEntryIds = new HashSet<Long>(16);
            HashSet<Long> costRecordCalEntryIds = new HashSet<Long>(16);
            for (DynamicObject entryRow : entry) {
                boolean isMainBill = entryRow.getBoolean("ismianbill");
                if (isMainBill) {
                    mainEntryIds.add(entryRow.getLong("billentryid"));
                    continue;
                }
                costRecordCalEntryIds.add(entryRow.getLong("calentryid"));
            }
            QFilter adjustfilter = new QFilter("createtype", "in", (Object)new String[]{CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue(), CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue()});
            adjustfilter.and("entryentity.srcbillentryid", "in", mainEntryIds);
            adjustfilter.and("feeshareflag", "=", (Object)infoId);
            strikeCostAdjustBillno = new HashSet<String>(16);
            isvoucherCostAdjustBillno = new HashSet<String>(16);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"id,costaccount,billno,checkstrikeaccount,isvoucher", (QFilter[])adjustfilter.toArray(), null);){
                for (Object row2 : ds) {
                    Boolean isvoucher;
                    feeBackSqlParams.addCostAccountId(row2.getLong("costaccount"));
                    Boolean checkstrikeaccount = row2.getBoolean("checkstrikeaccount");
                    if (checkstrikeaccount.booleanValue()) {
                        strikeCostAdjustBillno.add(row2.getString("billno"));
                    }
                    if ((isvoucher = row2.getBoolean("isvoucher")).booleanValue()) {
                        isvoucherCostAdjustBillno.add(row2.getString("billno"));
                    }
                    if (checkstrikeaccount.booleanValue() || isvoucher.booleanValue()) continue;
                    feeBackSqlParams.addCostAdjustBillIdSet(row2.getLong("id"));
                }
            }
            strikeStdCostDiffBillno = new HashSet<String>(16);
            isvoucherStdCostDiffBillno = new HashSet<String>(16);
            DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)"id,costaccount,billno,checkstrikeaccount,isvoucher", (QFilter[])adjustfilter.toArray(), null);
            row2 = null;
            try {
                for (Row row3 : ds) {
                    Boolean isvoucher;
                    feeBackSqlParams.addCostAccountId(row3.getLong("costaccount"));
                    Boolean checkstrikeaccount = row3.getBoolean("checkstrikeaccount");
                    if (checkstrikeaccount.booleanValue()) {
                        strikeStdCostDiffBillno.add(row3.getString("billno"));
                    }
                    if ((isvoucher = row3.getBoolean("isvoucher")).booleanValue()) {
                        isvoucherStdCostDiffBillno.add(row3.getString("billno"));
                    }
                    if (checkstrikeaccount.booleanValue() || isvoucher.booleanValue()) continue;
                    feeBackSqlParams.addStdCostDiffBillIdSet(row3.getLong("id"));
                }
            }
            catch (Throwable checkstrikeaccount) {
                row2 = checkstrikeaccount;
                throw checkstrikeaccount;
            }
            finally {
                if (ds != null) {
                    if (row2 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable checkstrikeaccount) {
                            ((Throwable)row2).addSuppressed(checkstrikeaccount);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            feeSharedBillnos = new HashSet<String>(16);
            isvoucherBillnos = new HashSet<String>(16);
            QFilter costRecordFilter = new QFilter("entry.calentryid", "in", costRecordCalEntryIds);
            costRecordFilter.and("entry.subentryentityest.estimatebillid", "=", (Object)infoId);
            costRecordFilter.and("issplitcreate", "=", (Object)false);
            try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"billno,costaccount,isvoucher,bookdate,entry.id,entry.subentryentityest.sharedetailexitem as estExpenseItemId,entry.subentryentityest.sharedetailasstact as estAsstact,entry.subentryentity.expenseitem as expenseItemId,entry.subentryentity.asstact as asstact", (QFilter[])costRecordFilter.toArray(), null).filter("estExpenseItemId <> 0 and estExpenseItemId <> null ");){
                Long estAsstact;
                Long estExpenseItemId;
                DataSet[] dataSets = ds2.splitByFilter(new String[]{"estAsstact = asstact and estExpenseItemId = expenseItemId", "estExpenseItemId <> 0 and expenseItemId = 0"}, false);
                for (Row row4 : dataSets[0]) {
                    feeBackSqlParams.addCostAccountId(row4.getLong("costaccount"));
                    String billno = row4.getString("billno");
                    boolean isvoucher = row4.getBoolean("isvoucher");
                    if (isvoucher) {
                        isvoucherBillnos.add(billno);
                    }
                    feeSharedBillnos.add(billno);
                }
                HashSet<Long> costAccountids = new HashSet<Long>(16);
                HashSet<Long> entryids = new HashSet<Long>(16);
                HashSet<Long> expenseItemIds = new HashSet<Long>(16);
                HashSet<Long> asstactIds = new HashSet<Long>(16);
                Date minBookdate = null;
                HashMap<String, String> key2BillnoMap = new HashMap<String, String>(16);
                for (Row row5 : dataSets[1]) {
                    feeBackSqlParams.addCostAccountId(row5.getLong("costaccount"));
                    String billno = row5.getString("billno");
                    Long entryid = row5.getLong("entry.id");
                    Date bookdate = row5.getDate("bookdate");
                    Long costAccountid = row5.getLong("costaccount");
                    estExpenseItemId = row5.getLong("estExpenseItemId");
                    estAsstact = row5.getLong("estAsstact");
                    boolean isvoucher = row5.getBoolean("isvoucher");
                    if (isvoucher) {
                        isvoucherBillnos.add(billno);
                    }
                    costAccountids.add(costAccountid);
                    entryids.add(entryid);
                    expenseItemIds.add(estExpenseItemId);
                    asstactIds.add(estAsstact);
                    if (minBookdate == null || minBookdate.after(bookdate)) {
                        minBookdate = bookdate;
                    }
                    key2BillnoMap.put(entryid.toString() + estExpenseItemId + estAsstact, billno);
                }
                if (entryids.isEmpty()) break block70;
                QFilter feeShareCostAdjustBillFilter = new QFilter("costaccount", "in", costAccountids);
                feeShareCostAdjustBillFilter.and("bookdate", ">=", minBookdate);
                feeShareCostAdjustBillFilter.and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue());
                feeShareCostAdjustBillFilter.and("entryentity.invbillentryid", "in", entryids);
                feeShareCostAdjustBillFilter.and("entryentity.feeprojectid", "in", expenseItemIds);
                feeShareCostAdjustBillFilter.and("custsupplier", "in", asstactIds);
                try (DataSet adjustDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.invbillentryid,entryentity.feeprojectid,custsupplier,costaccount", (QFilter[])feeShareCostAdjustBillFilter.toArray(), null);){
                    for (Row row6 : adjustDs) {
                        feeBackSqlParams.addCostAccountId(row6.getLong("costaccount"));
                        Long entryid = row6.getLong("entryentity.invbillentryid");
                        estExpenseItemId = row6.getLong("entryentity.feeprojectid");
                        estAsstact = row6.getLong("custsupplier");
                        String billno = (String)key2BillnoMap.get(entryid.toString() + estExpenseItemId + estAsstact);
                        if (billno == null) continue;
                        feeSharedBillnos.add(billno);
                    }
                }
            }
        }
        if (!strikeCostAdjustBillno.isEmpty()) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%1$s\u201d\u5df2\u51b2\u56de\u4e0d\u5141\u8bb8\u53d6\u6d88\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", strikeCostAdjustBillno));
            backFeeShareResult.appendMsg("\r\n");
            backFeeShareResult.appendMsg(content);
        }
        if (!isvoucherCostAdjustBillno.isEmpty()) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostEstimateBillCancelOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", isvoucherCostAdjustBillno));
            backFeeShareResult.appendMsg("\r\n");
            backFeeShareResult.appendMsg(content);
        }
        if (!feeSharedBillnos.isEmpty() && !isWriteOffFeeShare) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201c%s\u201d\u5df2\u7ecf\u5206\u644a\u8fc7\u4e0d\u5141\u8bb8\u53cd\u5206\u644a\u3002", (String)"FeeBackShareOp_12", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", feeSharedBillnos));
            backFeeShareResult.appendMsg("\r\n");
            backFeeShareResult.appendMsg(content);
        }
        if (!isvoucherBillnos.isEmpty()) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201c%s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u53cd\u5206\u644a\u3002", (String)"FeeBackShareOp_13", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", isvoucherBillnos));
            backFeeShareResult.appendMsg("\r\n");
            backFeeShareResult.appendMsg(content);
        }
        if (!strikeStdCostDiffBillno.isEmpty()) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u201c%1$s\u201d\u5df2\u51b2\u56de\u4e0d\u5141\u8bb8\u53d6\u6d88\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_8", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", strikeStdCostDiffBillno));
            backFeeShareResult.appendMsg(content);
        }
        if (!isvoucherStdCostDiffBillno.isEmpty()) {
            backFeeShareResult.setIsBackFeeShareFalse();
            errorMainEntryIds.addAll(mainEntryIds);
            content = String.format(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u201c%s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostEstimateBillCancelOp_9", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", isvoucherStdCostDiffBillno));
            backFeeShareResult.appendMsg(content);
        }
        return errorMainEntryIds;
    }

    private Set<Long> checkFeeShare(DynamicObject feeShareRecordInfo, BackFeeShareResult backFeeShareResult, FeeBackSqlParams feeBackSqlParams, Set<Long> expenseitemIds) {
        long infoId = feeBackSqlParams.getInfoId();
        HashSet<Long> mainEntryIds = new HashSet<Long>(16);
        DataSet costRecordData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.bill.FeeBackShareOp.checkFeeShare1", (String)"cal_fee_sharerecord", (String)"entry.bizbillentryid as bizbillEntryid", (QFilter[])new QFilter("id", "=", (Object)infoId).toArray(), null);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>(16);
        for (Row row : costRecordData) {
            bizBillEntryIds.add(row.getLong("bizbillEntryid"));
        }
        if (bizBillEntryIds.isEmpty()) {
            return mainEntryIds;
        }
        DynamicObjectCollection costRecordCollection = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"entry.calentryid,entry.subentryentityest.estimatebillid", (QFilter[])new QFilter("entry.bizbillentryid", "in", bizBillEntryIds).toArray());
        if (costRecordCollection.isEmpty()) {
            return mainEntryIds;
        }
        HashSet<Long> calBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject recordInfo : costRecordCollection) {
            calBillEntryIds.add(recordInfo.getLong("entry.calentryid"));
        }
        DynamicObjectCollection costRecordEstimateCollection = QueryServiceHelper.query((String)"cal_costestimaterecord", (String)"costdetail.id", (QFilter[])new QFilter("calentryid", "in", calBillEntryIds).toArray());
        if (costRecordEstimateCollection.isEmpty()) {
            return mainEntryIds;
        }
        HashSet<Long> estEntryIds = new HashSet<Long>(16);
        for (DynamicObject costRecordEstimate : costRecordEstimateCollection) {
            estEntryIds.add(costRecordEstimate.getLong("costdetail.id"));
        }
        QFilter shareRecordFilter = new QFilter("entry.billentryid", "in", estEntryIds);
        DataSet shareRecordData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.bill.FeeBackShareOp.checkFeeShare2", (String)"cal_fee_sharerecord", (String)"entry.id,id,billno", (QFilter[])shareRecordFilter.toArray(), null);
        HashMap futureShareMap = new HashMap(16);
        HashSet<Long> historyShareCostRecordEntryIds = new HashSet<Long>(16);
        HashMap<Long, String> feeShareRecordMap = new HashMap<Long, String>(16);
        for (Object row : shareRecordData) {
            Long l = row.getLong("entry.id");
            if (!feeShareRecordMap.containsKey(row.getLong("id"))) {
                feeShareRecordMap.put(row.getLong("id"), row.getString("billno"));
            }
            if (infoId < row.getLong("id")) {
                if (!futureShareMap.containsKey(l)) {
                    HashSet sharercdids = new HashSet(16);
                    futureShareMap.put(l, sharercdids);
                }
                ((Set)futureShareMap.get(l)).add(row.getLong("id"));
            }
            if (infoId <= row.getLong("id")) continue;
            historyShareCostRecordEntryIds.add(l);
        }
        HashSet effectShareIdSet = new HashSet(16);
        for (Map.Entry entry : futureShareMap.entrySet()) {
            if (historyShareCostRecordEntryIds.contains(entry.getKey())) continue;
            effectShareIdSet.addAll((Collection)entry.getValue());
        }
        if (effectShareIdSet.isEmpty()) {
            return mainEntryIds;
        }
        StringBuilder shareRecrdNo = new StringBuilder();
        for (Object shereId : effectShareIdSet) {
            shareRecrdNo.append((String)feeShareRecordMap.get(shereId)).append(",");
        }
        if (shareRecrdNo.length() > 0) {
            DynamicObjectCollection dynamicObjectCollection = feeShareRecordInfo.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                boolean ismianbill = dynamicObject.getBoolean("ismianbill");
                if (!ismianbill) continue;
                mainEntryIds.add(dynamicObject.getLong("billentryid"));
            }
            String content = String.format("\r\n" + ResManager.loadKDString((String)"\u52fe\u7a3d\u5e8f\u53f7\u3010 %1$s\u3011\u5b58\u5728\u540e\u7eed\u5206\u644a\uff0c\u4e0d\u80fd\u76f4\u63a5\u53cd\u5206\u644a\uff0c\u8bf7\u5148\u53cd\u5206\u644a\u5982\u4e0b\u52fe\u7a3d\u5e8f\u53f7\u7684\u5206\u644a\u8bb0\u5f55\uff1a%2$s", (String)"FeeBackShareOp_11", (String)"fi-cal-opplugin", (Object[])new Object[0]), feeBackSqlParams.getInfoBillNo(), shareRecrdNo.substring(0, shareRecrdNo.length() - 1));
            backFeeShareResult.appendMsg(content);
            backFeeShareResult.setIsBackFeeShareFalse();
        }
        return mainEntryIds;
    }

    private void updateCostRecord(FeeBackSqlParams feeBackSqlParams, boolean isEstFeeShare) {
        List<Object[]> backFeeshareParams = feeBackSqlParams.getBackFeeshareParams();
        if (backFeeshareParams.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)this.getFeeShareUpdateSql(), backFeeshareParams);
        List<Object[]> costRecordDetailList = feeBackSqlParams.getCostRecordDetailList();
        DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)FeeShareHelper.getSubCostRecordDetailSql(), costRecordDetailList);
        List<Object> entryIdObj = feeBackSqlParams.getEntryIdObj();
        HashSet<Object> entryIdSet = new HashSet<Object>(entryIdObj);
        FeeShareHelper.caculateDetailUnitActual(entryIdSet);
        if (isEstFeeShare) {
            CostElementHelper.calCostpricesourceRecordCost((Long[])entryIdSet.toArray(new Long[0]), (String)"UnCostEstimate");
        } else {
            CostElementHelper.calCostpricesourceRecordCost((Long[])entryIdSet.toArray(new Long[0]), (String)"FeeBackShare");
        }
    }

    private void updateCostEstimate(List<Object> entryIdObj) {
        HashSet<Long> entryObj = new HashSet<Long>(32);
        for (Object entryId : entryIdObj) {
            entryObj.add((Long)entryId);
        }
        HashMap<Long, Set> bizEntry2costRecordEntryMap = new HashMap<Long, Set>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.bizbillentryid,entry.id", (QFilter[])new QFilter("entry.id", "in", entryObj).toArray(), null);){
            for (Row row : ds) {
                Long costRecordEntryid = row.getLong("entry.id");
                Long bizbillentryid = row.getLong("entry.bizbillentryid");
                Set costRecordEntryids = bizEntry2costRecordEntryMap.computeIfAbsent(bizbillentryid, k -> new HashSet(4));
                costRecordEntryids.add(costRecordEntryid);
            }
        }
        ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_feeshare_newrecord", (String)"entry.bizbillentryid", (QFilter[])new QFilter("entry.bizbillentryid", "in", bizEntry2costRecordEntryMap.keySet()).and("entry.ismianbill", "=", (Object)"0").and("writeofftypeid", "in", (Object)new Long[]{CommonConstant.HXLB_ACTUALFEE_SHARE, 0L}).toArray(), null);
        var5_5 = null;
        try {
            for (Row row : ds) {
                entryObj.removeAll((Collection)bizEntry2costRecordEntryMap.get(row.getLong("entry.bizbillentryid")));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var5_5 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (entryObj.isEmpty()) {
            return;
        }
        this.updateCostRecordIsallote(entryObj);
    }

    private void updateCostRecordIsallote(Set<Long> entryObj) {
        ArrayList<Object[]> entryObjs = new ArrayList<Object[]>(32);
        for (Long objects : entryObj) {
            Object[] entryIdobj = new Object[]{objects};
            entryObjs.add(entryIdobj);
        }
        DB.executeBatch((DBRoute)this.getDbRoute("cal"), (String)" update t_cal_calcostrecordentry set fisallocate = 0  where fentryid = ?", entryObjs);
    }

    private String getFeeCostUpdateSql() {
        return " update t_cal_calcostrecordentry set  ftotalsharefee = ftotalsharefee - ?  where fentryid = ? ";
    }

    private String getFeeShareUpdateSql() {
        StringBuilder sql = new StringBuilder(32);
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" ffee =  ? ,funitfee = ? ,ftotalsharefee = ? ");
        sql.append(" where fentryid = ? and fid = ?  ");
        return sql.toString();
    }

    private String getFinapbBillsUpdateSql() {
        return "update t_ap_finapbilldetailentry set fisallocate  = 0 where fentryid = ? ";
    }

    private String getShareRecordSql() {
        StringBuilder sql = new StringBuilder(" delete from  t_cal_feerecord  ");
        sql.append(" where fid = ? ");
        return sql.toString();
    }

    private String getShareRecordEntrySql() {
        StringBuilder sql = new StringBuilder(" delete from  t_cal_feerecordentry  ");
        sql.append(" where fid = ? ");
        return sql.toString();
    }

    private String getShareRecordDetailSql() {
        StringBuilder sql = new StringBuilder(32);
        sql.append(" delete from  t_cal_sharedetailentry  ");
        sql.append(" where fsharercdid = ? ");
        return sql.toString();
    }

    private String getEstFeeShareRecordDetailSql() {
        StringBuilder sql = new StringBuilder(32);
        sql.append(" delete from  t_cal_esbilldetailentry  ");
        sql.append(" where festimatebillid = ? ");
        return sql.toString();
    }

    private static class BackFeeShareResult {
        private StringBuffer countMeg = new StringBuffer(16);
        private StringBuffer meg = new StringBuffer(16);
        private int faultsCount = 0;
        private int successCount = 0;
        private boolean isBackFeeShare = true;
        private Map<String, StringBuilder> logInfos = new HashMap<String, StringBuilder>();
        private String currentRecordNum = "";

        private BackFeeShareResult() {
        }

        public String getResultMsg() {
            String format = ResManager.loadKDString((String)"\u53cd\u5206\u644a\u6210\u529f\u6570\u91cf\uff1a%1$s,\u5931\u8d25\u6570\u91cf\uff1a%2$s\u3002", (String)"FeeBackShareOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            format = String.format(format, this.successCount, this.faultsCount);
            this.countMeg.append(format);
            this.countMeg.append("FEEBACKSHARE");
            return this.countMeg.append(this.meg).toString();
        }

        public void increaseSuccessCount() {
            ++this.successCount;
        }

        public void increaseFaultCount() {
            ++this.faultsCount;
        }

        public void setIsBackFeeShareFalse() {
            this.isBackFeeShare = false;
        }

        public void appendMsg(String str) {
            this.meg.append(str);
            StringBuilder builder = this.logInfos.get(this.currentRecordNum);
            builder.append(str);
        }

        public void setCurrentRecordNum(String currentRecordNum) {
            this.currentRecordNum = currentRecordNum;
            this.logInfos.put(currentRecordNum, new StringBuilder());
        }

        public Map<String, StringBuilder> getLogInfos() {
            return this.logInfos;
        }
    }
}

