/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.InitBillOldBalanceCalculator;
import kd.fi.cal.business.calculate.out.CalMoveInvoker;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.opplugin.validator.CalBillMustInputValidator;

public class InitCalBillAuditOp
extends AbstractOperationServicePlugIn {
    private Map<Long, DynamicObject> costAcc2StartPeriod;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        e.getFieldKeys().add("entryentity.warehouse.isopenlocation");
        e.getFieldKeys().add("entryentity.material.isuseauxpty");
        e.getFieldKeys().add("entryentity.material.configproperties");
        keyList.add("costaccount");
        keyList.add("costaccount.calpolicy");
        keyList.add("costaccount.calsystem");
        keyList.add("bizdate");
        keyList.add("billno");
        keyList.add("calorg");
        keyList.add("period");
        keyList.add("localcurrency");
        MainEntityType initCalEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        Set dimFieldSet = CalBalanceModelHelper.getDimField();
        for (String dimField : dimFieldSet) {
            if (!(initCalEntityType.findProperty(dimField).getParent() instanceof EntryType)) continue;
            keyList.add("entryentity." + dimField);
        }
        keyList.add("entryentity.seq");
        keyList.add("entryentity.baseunit");
        keyList.add("entryentity.baseqty");
        keyList.add("entryentity.amount");
        keyList.add("entryentity.costdiff");
        keyList.add("entryentity.yearinqty");
        keyList.add("entryentity.yearincost");
        keyList.add("entryentity.yearincostdiff");
        keyList.add("entryentity.yearissueqty");
        keyList.add("entryentity.yearissuecost");
        keyList.add("entryentity.yearissuecostdiff");
        keyList.add("entryentity.calrange");
        keyList.add("entryentity.accounttype");
        keyList.add("entryentity.caldimension");
        keyList.add("entryentity.createtype");
        keyList.add("entryentity.costdomainkey");
        keyList.add("entryentity.stocktype");
        keyList.add("costelement");
        keyList.add("costsubelement");
        keyList.add("sub_baseqty");
        keyList.add("sub_amount");
        keyList.add("sub_costdiff");
        keyList.add("sub_yearinqty");
        keyList.add("sub_yearincost");
        keyList.add("sub_yearincostdiff");
        keyList.add("sub_yearissueqty");
        keyList.add("sub_yearissuecost");
        keyList.add("sub_yearissuecostdiff");
        keyList.add("entryentity.ecalstatus");
        keyList.add("entryentity.entrystatus");
        keyList.add("entryentity.noupdatecalfields");
        keyList.add("calstatus");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalBillMustInputValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
                for (ExtendedDataEntity billInfo : billInfos) {
                    DynamicObject info = billInfo.getDataEntity();
                    DynamicObject costAccount = info.getDynamicObject("costaccount");
                    if (costAccount == null) continue;
                    costAccountIdSet.add(costAccount.getLong("id"));
                }
                InitCalBillAuditOp.this.costAcc2StartPeriod = new HashMap(costAccountIdSet.size());
                HashMap<Long, Boolean> costAcc2EndInit = new HashMap<Long, Boolean>(costAccountIdSet.size());
                ExtendedDataEntity[] extendedDataEntityArray = costAccountIdSet.iterator();
                while (extendedDataEntityArray.hasNext()) {
                    long costAccountId = (Long)extendedDataEntityArray.next();
                    DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity((Long)costAccountId);
                    if (sysCtrl == null) continue;
                    InitCalBillAuditOp.this.costAcc2StartPeriod.put(costAccountId, sysCtrl.getDynamicObject("startperiod"));
                    costAcc2EndInit.put(costAccountId, sysCtrl.getBoolean("isenabled"));
                }
                for (ExtendedDataEntity billInfo : billInfos) {
                    boolean isEndInit;
                    DynamicObject bill = billInfo.getDataEntity();
                    DynamicObject costAccount = bill.getDynamicObject("costaccount");
                    if (costAccount == null) continue;
                    Long costAccountId = costAccount.getLong("id");
                    String costAccountName = costAccount.getString("name");
                    Date bizDate = bill.getDate("bizdate");
                    DynamicObject startPeriod = (DynamicObject)InitCalBillAuditOp.this.costAcc2StartPeriod.get(costAccountId);
                    if (startPeriod == null) {
                        this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u5728\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u91cc\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"InitCalBillSubmitOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Date beginDate = startPeriod.getDate("begindate");
                    if (!bizDate.before(beginDate)) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalBillSubmitOp_29", (String)"fi-cal-opplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                        this.addErrorMessage(billInfo, errorMsg);
                    }
                    if (isEndInit = ((Boolean)costAcc2EndInit.get(costAccountId)).booleanValue()) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BalanceSaveValidator_19", (String)"fi-cal-opplugin", (Object[])new Object[0]), costAccountName);
                        this.addErrorMessage(billInfo, errorMsg);
                        continue;
                    }
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    if (entrys != null && entrys.size() != 0) continue;
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"InitCalBillSubmitOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] billInfos;
        super.beginOperationTransaction(e);
        for (DynamicObject info : billInfos = e.getDataEntities()) {
            long costAccountId = info.getLong("costaccount.id");
            DynamicObject period = this.costAcc2StartPeriod.get(costAccountId);
            info.set("period", (Object)period);
            info.set("calstatus", (Object)"A");
            for (DynamicObject entryDyc : info.getDynamicObjectCollection("entryentity")) {
                entryDyc.set("ecalstatus", (Object)"A");
                entryDyc.set("entrystatus", (Object)"C");
            }
        }
        MaterialCategoryHandle.handle4Bill((DynamicObject[])billInfos);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] billInfos = e.getDataEntities();
        HashMap<Long, HashSet<Long>> costAccountMap = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, DynamicObject> initIdDycMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        for (DynamicObject info : billInfos) {
            long l = info.getLong("costaccount.id");
            HashSet<Long> billIdSet = (HashSet<Long>)costAccountMap.get(l);
            allBillIds.add(info.getLong("id"));
            if (billIdSet != null) {
                billIdSet.add(info.getLong("id"));
            } else {
                billIdSet = new HashSet<Long>(64);
                billIdSet.add(info.getLong("id"));
                costAccountMap.put(l, billIdSet);
            }
            initIdDycMap.put(info.getLong("id"), info);
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(billInfos, "cal_initbill", ActionEnum.AUDIT.getValue(), false);
            handle.insertIntoPool();
            Map noInPoolBillEntryIdMap = handle.getNoInPoolBillEntryIdMap();
            Set noInPoolBillIds = noInPoolBillEntryIdMap.keySet();
            ArrayList notInPoolUpdateBalDycs = new ArrayList(16);
            for (Long noInPoolBillId : noInPoolBillIds) {
                notInPoolUpdateBalDycs.add(initIdDycMap.get(noInPoolBillId));
            }
            new InitBillOldBalanceCalculator().updateAudit(notInPoolUpdateBalDycs.toArray(new DynamicObject[0]));
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_initbill");
            balanceOpInvoker.invokeBalOp(noInPoolBillIds, null);
        } else {
            long costAccountId;
            CalMoveDlock allCalMoveDlock = new CalMoveDlock();
            Map allKeyLockMap = allCalMoveDlock.addLockBatchByInitCalBill(allBillIds);
            allCalMoveDlock.releaseLockAfterTxEnd(new ArrayList(allKeyLockMap.values()));
            new InitBillOldBalanceCalculator().updateAudit(billInfos);
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_initbill");
            balanceOpInvoker.invokeBalOp(allBillIds, null);
            for (Map.Entry<Long, Set<Long>> entry : costAccountMap.entrySet()) {
                costAccountId = (Long)entry.getKey();
                this.handleMoveAdd(entry, costAccountId);
            }
            for (Map.Entry<Long, Set<Long>> entry : costAccountMap.entrySet()) {
                costAccountId = (Long)entry.getKey();
                this.handleFifo(entry, costAccountId);
            }
        }
    }

    private void handleFifo(Map.Entry<Long, Set<Long>> entry, long costAccountId) {
        new CalMoveInvoker().doCalInitBillFifo(entry.getValue().toArray(new Long[0]), "cal_initbill", "1", costAccountId);
    }

    private void handleMoveAdd(Map.Entry<Long, Set<Long>> entry, long costAccountId) {
        new CalMoveInvoker().doCalInitBill(entry.getValue().toArray(new Long[0]), "cal_initbill", "1", costAccountId);
    }
}

