/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.DecimalHelper;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.InitCalSubEntryInfo;
import kd.fi.cal.opplugin.validator.InitCalImportValidator;

public class InitCalBillSaveOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] policyArr;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!"import".equals(dataEntities[0].getString("billcretype"))) {
            return;
        }
        HashSet<Long> materialIdSet = new HashSet<Long>(128);
        HashSet<Long> calPolicyIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> policy2CurrencyMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Boolean> costAccCalbyEleMap = new HashMap<Long, Boolean>(16);
        HashSet<Long> unCalByEleMatSet = new HashSet<Long>(128);
        for (DynamicObject entity : dataEntities) {
            DynamicObject costAccount = entity.getDynamicObject("costaccount");
            if (costAccount == null) continue;
            calPolicyIdSet.add(costAccount.getLong("calpolicy_id"));
            long costAccId = costAccount.getLong("id");
            if (costAccCalbyEleMap.get(costAccId) != null) continue;
            costAccCalbyEleMap.put(costAccId, ParamsHelper.getCostElementByCostAccount((long)costAccId));
        }
        for (DynamicObject policy : policyArr = BusinessDataServiceHelper.load((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calPolicyIdSet)})) {
            policy2CurrencyMap.put(policy.getLong("id"), policy.getDynamicObject("currency"));
        }
        this.setHeadAndEntryValue(dataEntities, materialIdSet, policy2CurrencyMap, costAccCalbyEleMap, unCalByEleMatSet);
        if (materialIdSet.size() == 0) {
            return;
        }
        new AccountType4CostAdjustHelper(dataEntities).handleCalRangeAccType4InitBill();
        HashSet stdMaterialSet = new HashSet(128);
        HashSet calDimensionIdSet = new HashSet(16);
        Map stdMaterialMap = InitCalBillHelper.cacheMatCostInfoMap((DynamicObject[])dataEntities);
        Set assistEffectPriceMatIds = InitCalBillHelper.cacheAssistAffectPriceMatIds(stdMaterialSet);
        Set hasMatVerCalDimIds = InitCalBillHelper.cacheCalDimSetHasMatVer(calDimensionIdSet);
        Map<String, InitCalSubEntryInfo> importSubEntry = this.cacheImportSubEntry(dataEntities);
        List elements = CostElementHelper.getAllCostEle4InitBill();
        for (DynamicObject entity : dataEntities) {
            long entityId = entity.getLong("id");
            DynamicObject costAccount = entity.getDynamicObject("costaccount");
            Date bizDate = entity.getDate("bizdate");
            if (costAccount == null || bizDate == null) continue;
            entity.set("period", (Object)PeriodHelper.getStartPeriod((Long)costAccount.getLong("id")));
            DynamicObject localCurrency = (DynamicObject)policy2CurrencyMap.get(costAccount.getLong("calpolicy.id"));
            if (localCurrency == null) continue;
            boolean enableStd = costAccount.getBoolean("enablestandardcost");
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entryentity");
            int amtPrecision = localCurrency.getInt("amtprecision");
            boolean calByCostElement = (Boolean)costAccCalbyEleMap.get(costAccount.getLong("id"));
            for (DynamicObject entry : entryColl) {
                if (calByCostElement) {
                    if (InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString("accounttype"))) {
                        InitCalBillHelper.setSubEntry4StdEntry((Map)stdMaterialMap, (DynamicObject)costAccount, (int)amtPrecision, (DynamicObject)entry, (Set)assistEffectPriceMatIds, (boolean)true, null, importSubEntry, (List)elements, (Set)hasMatVerCalDimIds, (long)entityId);
                        continue;
                    }
                    InitCalBillHelper.setSubEntry4NotStdCalByEle((DynamicObject)entry, (List)elements, importSubEntry, (int)amtPrecision, (long)entityId);
                    continue;
                }
                if (InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString("accounttype"))) {
                    InitCalBillHelper.setSubEntry4StdEntry((Map)stdMaterialMap, (DynamicObject)costAccount, (int)amtPrecision, (DynamicObject)entry, (Set)assistEffectPriceMatIds, (boolean)false, null, null, null, (Set)hasMatVerCalDimIds, (long)entityId);
                    continue;
                }
                InitCalBillHelper.setSubEntry4NotStdNotEle(null, (DynamicObject)costAccount, (DynamicObject)entry);
            }
        }
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(dataEntities);
        Map storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_initbill", "entryentity");
        for (DynamicObject info : dataEntities) {
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                DynamicObject material = entry.getDynamicObject("material");
                long materialId = material.getLong("id");
                DynamicObject storageorgunit = entry.getDynamicObject("storageorgunit");
                long storageOrgId = storageorgunit.getLong("id");
                String curUnionKey = storageOrgId + "#" + materialId;
                Long storageInvId = (Long)unionKeyAndStorageInvId.get(curUnionKey);
                String noUpdateStr = (String)storageInvIdAndNoUpdateStr.get(storageInvId);
                entry.set("noupdatecalfields", (Object)noUpdateStr);
            }
        }
        MaterialCategoryHandle.handle4Bill((DynamicObject[])dataEntities);
    }

    private void setHeadAndEntryValue(DynamicObject[] dataEntities, Set<Long> materialIdSet, Map<Long, DynamicObject> policy2CurrencyMap, Map<Long, Boolean> costAccCalbyEleMap, Set<Long> unCalByEleMatSet) {
        for (DynamicObject entity : dataEntities) {
            DynamicObject costAccount = entity.getDynamicObject("costaccount");
            Date bizDate = entity.getDate("bizdate");
            if (costAccount == null || bizDate == null) continue;
            entity.set("period", (Object)PeriodHelper.getStartPeriod((Long)costAccount.getLong("id")));
            DynamicObject localCurrency = policy2CurrencyMap.get(costAccount.getLong("calpolicy.id"));
            if (localCurrency == null) continue;
            entity.set("localcurrency", (Object)localCurrency);
            boolean isCalByEle = costAccCalbyEleMap.get(costAccount.getLong("id"));
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                boolean amountEqualsZero;
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) continue;
                entry.set("baseunit", (Object)material.getDynamicObject("baseunit"));
                long materialId = material.getLong("id");
                materialIdSet.add(materialId);
                if (isCalByEle) {
                    unCalByEleMatSet.add(materialId);
                    continue;
                }
                BigDecimal price = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("price"));
                BigDecimal baseQty = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("baseqty"));
                BigDecimal amount = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("amount"));
                boolean priceEqualsZero = price.compareTo(BigDecimal.ZERO) == 0;
                boolean qtyEqualsZero = baseQty.compareTo(BigDecimal.ZERO) == 0;
                boolean bl = amountEqualsZero = amount.compareTo(BigDecimal.ZERO) == 0;
                if (amountEqualsZero) {
                    if (priceEqualsZero || qtyEqualsZero) continue;
                    entry.set("amount", (Object)price.multiply(baseQty).setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
                    continue;
                }
                entry.set("amount", (Object)amount.setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
                if (priceEqualsZero && !qtyEqualsZero) {
                    entry.set("price", (Object)amount.divide(baseQty, 10, RoundingMode.HALF_UP));
                    continue;
                }
                if (!qtyEqualsZero) continue;
                entry.set("price", (Object)BigDecimal.ZERO);
            }
        }
    }

    private Map<String, InitCalSubEntryInfo> cacheImportSubEntry(DynamicObject[] dataEntities) {
        HashMap<String, InitCalSubEntryInfo> importSubEntry = new HashMap<String, InitCalSubEntryInfo>(128);
        for (DynamicObject entity : dataEntities) {
            DynamicObject costAccount = entity.getDynamicObject("costaccount");
            Date bizDate = entity.getDate("bizdate");
            if (costAccount == null || bizDate == null) continue;
            long entityId = entity.getLong("id");
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                Object entrySeq = entry.get("seq");
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntrys) {
                    long subElementId = subEntry.getLong("costsubelement_id");
                    importSubEntry.put(entityId + "|" + entrySeq + "|" + subElementId, new InitCalSubEntryInfo(subEntry.getBigDecimal("sub_price"), subEntry.getBigDecimal("sub_costdiff"), subEntry.getBigDecimal("sub_yearincost"), subEntry.getBigDecimal("sub_yearincostdiff"), subEntry.getBigDecimal("sub_yearissuecost"), subEntry.getBigDecimal("sub_yearissuecostdiff"), subEntry.getBigDecimal("sub_amount")));
                }
            }
        }
        return importSubEntry;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getDataEntities();
        if ("import".equals(e.getDataEntities()[0].getString("billcretype"))) {
            e.addValidator((AbstractValidator)new InitCalImportValidator());
        }
    }
}

