/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.opplugin.validator.CalBillMustInputValidator;
import kd.fi.cal.opplugin.validator.InitCalBillSubmitValidator;

public class InitCalBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InitCalBillSubmitValidator(this.operateOption.containsVariable("notcheckmatinvinfo")));
        e.addValidator((AbstractValidator)new CalBillMustInputValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject entity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("entryentity");
            Date bookDate = entity.getDate("bookdate");
            for (DynamicObject entry : entrys) {
                Date stockInDate = entry.getDate("stockindate");
                if (stockInDate != null) continue;
                entry.set("stockindate", (Object)bookDate);
            }
            DynamicObject costAccount = entity.getDynamicObject("costaccount");
            if (costAccount == null || ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"))) continue;
            boolean enableStd = costAccount.getBoolean("enablestandardcost");
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
                boolean isStd = InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString("accounttype"));
                for (DynamicObject subEntry : subEntryColl) {
                    subEntry.set("sub_amount", (Object)entry.getBigDecimal("amount"));
                    subEntry.set("sub_price", (Object)entry.getBigDecimal("price"));
                    subEntry.set("sub_yearincost", (Object)entry.getBigDecimal("yearincost"));
                    subEntry.set("sub_yearissuecost", (Object)entry.getBigDecimal("yearissuecost"));
                    if (!isStd) continue;
                    subEntry.set("sub_costdiff", (Object)entry.getBigDecimal("costdiff"));
                    subEntry.set("sub_yearincostdiff", (Object)entry.getBigDecimal("yearincostdiff"));
                    subEntry.set("sub_yearissuecostdiff", (Object)entry.getBigDecimal("yearissuecostdiff"));
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject dataEntity : dataEntities) {
            if ("submit".equals(e.getOperationKey())) {
                dataEntity.set("lastupdateuser", (Object)userDyc);
                dataEntity.set("lastupdatetime", (Object)new Date());
            }
            for (DynamicObject entryDyc : dataEntity.getDynamicObjectCollection("entryentity")) {
                entryDyc.set("entrystatus", (Object)"B");
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            Long bizbillid = dataEntity.getLong("bizbillid");
            if (bizbillid != null && bizbillid != 0L) continue;
            list.add(dataEntity);
        }
        DynamicObject[] handBills = list.toArray(new DynamicObject[0]);
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(handBills);
        Map storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_initbill", "entryentity");
        for (DynamicObject info : dataEntities) {
            Long bizbillid = info.getLong("bizbillid");
            if (bizbillid != null && bizbillid != 0L) continue;
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                DynamicObject material = entry.getDynamicObject("material");
                long materialId = material.getLong("id");
                DynamicObject storageorgunit = entry.getDynamicObject("storageorgunit");
                long storageOrgId = storageorgunit.getLong("id");
                String curUnionKey = storageOrgId + "#" + materialId;
                Long storageInvId = (Long)unionKeyAndStorageInvId.get(curUnionKey);
                String noUpdateStr = (String)storageInvIdAndNoUpdateStr.get(storageInvId);
                entry.set("noupdatecalfields", (Object)noUpdateStr);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity.warehouse.isopenlocation");
        e.getFieldKeys().add("entryentity.material.isuseauxpty");
        e.getFieldKeys().add("entryentity.material.configproperties");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("costaccount.calpolicy");
        e.getFieldKeys().add("costaccount.calsystem");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("localcurrency");
        e.getFieldKeys().add("bizbillid");
        e.getFieldKeys().add("entryentity.configuredcode");
        e.getFieldKeys().add("entryentity.tracknumber");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("entryentity.ispresent");
        e.getFieldKeys().add("entryentity.amount");
        e.getFieldKeys().add("costaccount.calpolicy.exratetable");
        e.getFieldKeys().add("entryentity.id");
        MainEntityType initCalEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        Set dimFieldSet = CalBalanceModelHelper.getDimField();
        for (String dimField : dimFieldSet) {
            if (!(initCalEntityType.findProperty(dimField).getParent() instanceof EntryType)) continue;
            e.getFieldKeys().add("entryentity." + dimField);
        }
        e.getFieldKeys().add("entryentity.stockInDate");
        e.getFieldKeys().add("entryentity.baseunit");
        e.getFieldKeys().add("entryentity.baseqty");
        e.getFieldKeys().add("entryentity.price");
        e.getFieldKeys().add("entryentity.amount");
        e.getFieldKeys().add("entryentity.yearinqty");
        e.getFieldKeys().add("entryentity.yearincost");
        e.getFieldKeys().add("entryentity.yearincostdiff");
        e.getFieldKeys().add("entryentity.yearissueqty");
        e.getFieldKeys().add("entryentity.yearissuecost");
        e.getFieldKeys().add("entryentity.yearissuecostdiff");
        e.getFieldKeys().add("entryentity.calrange");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.caldimension");
        e.getFieldKeys().add("entryentity.costdiff");
        e.getFieldKeys().add("entryentity.createtype");
        e.getFieldKeys().add("entryentity.storageorgunit");
        e.getFieldKeys().add("entryentity.bizbillentryid");
        e.getFieldKeys().add("entryentity.costdomainkey");
        e.getFieldKeys().add("entryentity.stocktype");
        e.getFieldKeys().add("costelement");
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("sub_price");
        e.getFieldKeys().add("sub_baseqty");
        e.getFieldKeys().add("sub_amount");
        e.getFieldKeys().add("sub_costdiff");
        e.getFieldKeys().add("sub_yearinqty");
        e.getFieldKeys().add("sub_yearincost");
        e.getFieldKeys().add("sub_yearincostdiff");
        e.getFieldKeys().add("sub_yearissueqty");
        e.getFieldKeys().add("sub_yearissuecost");
        e.getFieldKeys().add("sub_yearissuecostdiff");
        e.getFieldKeys().add("entryentity.entrystatus");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.ecostcenter");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.noupdatecalfields");
    }
}

