/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.MaterialCategoryHandle;

public class MaterialCategoryUpdateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String entity = this.billEntityType.getName();
        String entryKey = MaterialCategoryUpdateOp.getBillEntryKey(entity);
        if ("cal_price_provbill".equals(entity) || "cal_price_revbill".equals(entity)) {
            e.getFieldKeys().add("org");
        } else {
            e.getFieldKeys().add("calorg");
        }
        e.getFieldKeys().add("costaccount");
        if (entryKey == null) {
            e.getFieldKeys().add("owner");
            e.getFieldKeys().add("material");
            e.getFieldKeys().add("stocktype");
        } else {
            e.getFieldKeys().add(entryKey + ".material");
            e.getFieldKeys().add(entryKey + ".owner");
            e.getFieldKeys().add(entryKey + ".stocktype");
        }
        if (MaterialCategoryHandle.getHeadStorageorgunitEntitys().contains(entity)) {
            e.getFieldKeys().add("storageorgunit");
        } else if (StringUtils.isNotEmpty((String)entryKey)) {
            e.getFieldKeys().add(entryKey + ".storageorgunit");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        MaterialCategoryHandle.handle4Bill((DynamicObject[])bills);
    }

    private static String getBillEntryKey(String entity) {
        if ("cal_costadjust_subentity".equals(entity) || "cal_costadjustbill".equals(entity) || "cal_stdcostdiffbill".equals(entity) || "cal_initbill".equals(entity)) {
            return "entryentity";
        }
        if ("cal_bal".equals(entity) || "cal_balance".equals(entity) || "cal_standcost_bal".equals(entity) || "cal_costdiffgroupbill".equals(entity)) {
            return null;
        }
        return "entry";
    }
}

