/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;

public class RebuildDomainAndSortByAcctIdsOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("costaccount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] billDycs = e.getDataEntities();
        HashSet<Long> acctIds = new HashSet<Long>(16);
        for (DynamicObject billDyc : billDycs) {
            long acctId = billDyc.getLong("costaccount_id");
            acctIds.add(acctId);
        }
        if (acctIds.isEmpty()) {
            return;
        }
        if (AcctGroupModelHelper.isNewGroupModel()) {
            AutoSortServic sortService = new AutoSortServic();
            sortService.sortByAsyncByAccountId(acctIds);
        } else {
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(acctIds, "RebuildDomainAndSortByAcctIdsOp");
        }
    }
}

