/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CalDiffGroupBillHelper;
import kd.fi.cal.opplugin.bill.StdCostDiffBillGenerateVoucherValidator;

public class StdCostBillVoucherOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("calorg");
        keys.add("createtype");
        keys.add("bizdate");
        keys.add("bookdate");
        keys.add("costaccount");
        keys.add("entryentity.srcbillnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new StdCostDiffBillGenerateVoucherValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opKey = e.getOperationKey();
        String voucherOpkey = "generatevoucher";
        if ("caldeletevoucher".equals(opKey)) {
            voucherOpkey = "deletevoucher";
        }
        DynamicObject[] stdBills = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(stdBills.length);
        for (int i = 0; i < stdBills.length; ++i) {
            ids.add(stdBills[i].getLong("id"));
        }
        boolean isGroup = CalDiffGroupBillHelper.getIsgroupdiff();
        String entityNum = isGroup ? "cal_costdiffgroupbill" : "cal_stdcostdiffbill";
        HashSet<Long> billIds = new HashSet<Long>(16);
        if (isGroup) {
            DataSet diffBills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)"id,entryentity.groupdiffbillid", (QFilter[])new QFilter("id", "in", ids).toArray(), null);
            for (Row row : diffBills) {
                Long groupBillId = row.getLong("entryentity.groupdiffbillid");
                if (groupBillId == null || groupBillId.compareTo(0L) == 0) continue;
                billIds.add(groupBillId);
            }
        } else {
            billIds.addAll(ids);
        }
        if (billIds.isEmpty()) {
            return;
        }
        OperationResult opResult = OperationServiceHelper.executeOperate((String)voucherOpkey, (String)entityNum, (Object[])billIds.toArray(), (OperateOption)OperateOption.create());
        if (opResult != null) {
            if (opResult.isSuccess()) {
                return;
            }
            StringBuilder exceptionSb = new StringBuilder();
            for (IOperateInfo errorInfo : opResult.getAllErrorOrValidateInfo()) {
                exceptionSb.append(errorInfo.getMessage());
                exceptionSb.append('\n');
            }
            if (StringUtils.isEmpty((String)exceptionSb.toString()) && opResult.getMessage() != null) {
                exceptionSb.append(opResult.getMessage());
            }
            throw new KDBizException(exceptionSb.toString());
        }
    }
}

