/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;

public class StdCostDiffBillDeleteVoucherValidator
extends AbstractValidator {
    private Map<Long, DynamicObject> currentPeriodCache = new HashMap<Long, DynamicObject>(16);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject org = (DynamicObject)dataEntity.getValue("calorg");
            String createtype = (String)dataEntity.getValue("createtype");
            if (null == org || null == createtype || "".equals(createtype)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3001\u521b\u5efa\u7c7b\u578b\u3002", (String)"CostAdjustBillDeleteVoucherValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            Long orgId = (Long)org.get("id");
            String dischargetype = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"dischargetype");
            boolean isWriteOff = CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(createtype) || CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue().equals(createtype);
            boolean notRedWfCreated = !"".equals(((DynamicObject)dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("srcbillnum"));
            isWriteOff = isWriteOff && notRedWfCreated;
            String operationResult = this.getOperateKey();
            if (null != dischargetype && !"C".equals(dischargetype) && isWriteOff && "deletevoucher".equals(operationResult)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6682\u4f30\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u201d\u6216\u201c\u5355\u5230\u51b2\u56de\u201d\u65f6\uff0c\u521b\u5efa\u7c7b\u578b\u4e3a\u201c\u91c7\u8d2d\u6838\u9500\u201d\u3001\u201c\u59d4\u5916\u6838\u9500\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u51ed\u8bc1\uff0c\u51ed\u8bc1\u7edf\u4e00\u7531\u5e94\u4ed8\u6a21\u5757\u5904\u7406\u3002", (String)"CostAdjustBillDeleteVoucherValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            Date bookdate = (Date)dataEntity.getValue("bookdate");
            DynamicObject currentPeriod = this.getCurrentPeriod(dataEntity);
            if (null == currentPeriod) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostAdjustBillSubmitOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Date periodBeginDate = currentPeriod.getDate("begindate");
            if (bookdate.compareTo(periodBeginDate) >= 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"CostAdjustBillDeleteVoucherValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private DynamicObject getCurrentPeriod(ExtendedDataEntity dataEntity) {
        DynamicObject costaccount = (DynamicObject)dataEntity.getValue("costaccount");
        DynamicObject period = this.currentPeriodCache.get(costaccount.getLong("id"));
        if (null == period) {
            period = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
            this.currentPeriodCache.put(costaccount.getLong("id"), period);
        }
        return period;
    }
}

