/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.opplugin.validator.StdCostDiffBillImportValidator;

public class StdCostDiffBillSaveOp
extends AbstractOperationServicePlugIn {
    private Map<Long, Long> costAccountCurrencyMap = new HashMap<Long, Long>(16);
    private static final String[] SUB_AMT_FIELDS = new String[]{"ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.storageorgunit");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("billno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if ("import".equals(e.getDataEntities()[0].getString("billcretype"))) {
            e.addValidator((AbstractValidator)new StdCostDiffBillImportValidator());
        }
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos;
                for (ExtendedDataEntity billInfo : billInfos = this.getDataEntities()) {
                    DynamicObject bill = billInfo.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    int size = entrys.size();
                    if (size != 0) continue;
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"CostAdjustBillSaveOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] costAdjustBill;
        for (DynamicObject info : costAdjustBill = e.getDataEntities()) {
            long costAccountId = 0L;
            Object costAccount = info.get("costaccount");
            if (costAccount == null) {
                return;
            }
            if (costAccount instanceof Long) {
                costAccountId = (Long)costAccount;
            }
            if (costAccount instanceof DynamicObject) {
                costAccountId = ((DynamicObject)costAccount).getLong("id");
            }
            Date bookdate = info.getDate("bookdate");
            info.set("period_id", (Object)PeriodHelper.getPeriodByDate((Date)bookdate, (Long)costAccountId).getLong("id"));
            info.set("bookdate", (Object)bookdate);
            String billCreType = info.getString("billcretype");
            if (!"import".equals(billCreType)) continue;
            Long currency = this.costAccountCurrencyMap.get(costAccountId);
            if (currency == null) {
                DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency", (QFilter[])new QFilter("id", "=", (Object)costAccountId).toArray());
                currency = costAccountDy.getLong("calpolicy.currency");
                this.costAccountCurrencyMap.put(costAccountId, currency);
            }
            info.set("currency_id", (Object)currency);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject info : costAdjustBill) {
            String billCreType = info.getString("billcretype");
            if (!"import".equals(billCreType)) continue;
            list.add(info);
        }
        DynamicObject[] importBills = list.toArray(new DynamicObject[0]);
        MaterialCategoryHandle.handle4Bill((DynamicObject[])importBills);
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(importBills);
        Map storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_costadjust_subentity", "entryentity");
        for (DynamicObject info : costAdjustBill) {
            String billCreType = info.getString("billcretype");
            if (!"import".equals(billCreType)) continue;
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                DynamicObject material = entry.getDynamicObject("material");
                long materialId = material.getLong("id");
                DynamicObject storageorgunit = entry.getDynamicObject("storageorgunit");
                long storageOrgId = storageorgunit.getLong("id");
                String curUnionKey = storageOrgId + "#" + materialId;
                Long storageInvId = (Long)unionKeyAndStorageInvId.get(curUnionKey);
                String noUpdateStr = (String)storageInvIdAndNoUpdateStr.get(storageInvId);
                entry.set("noupdatecalfields", (Object)noUpdateStr);
                BigDecimal diff_g = BigDecimal.ZERO;
                BigDecimal diff_h = BigDecimal.ZERO;
                BigDecimal diff_k = BigDecimal.ZERO;
                BigDecimal diff_p = BigDecimal.ZERO;
                BigDecimal diff_q = BigDecimal.ZERO;
                BigDecimal diff_r = BigDecimal.ZERO;
                BigDecimal diff_m = BigDecimal.ZERO;
                BigDecimal diff_s = BigDecimal.ZERO;
                BigDecimal diff_t = BigDecimal.ZERO;
                BigDecimal diff_c = BigDecimal.ZERO;
                BigDecimal diff_x = BigDecimal.ZERO;
                BigDecimal diff_w = BigDecimal.ZERO;
                BigDecimal diff_y = BigDecimal.ZERO;
                DynamicObjectCollection subentryentitys = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subentryentity : subentryentitys) {
                    BigDecimal subTotalAmt = BigDecimal.ZERO;
                    for (String field : SUB_AMT_FIELDS) {
                        subTotalAmt = subTotalAmt.add(subentryentity.getBigDecimal(field));
                    }
                    subentryentity.set("sub_adjustamt", (Object)subTotalAmt);
                    if (subentryentity.getBigDecimal("ddiff_g") != null) {
                        diff_g = diff_g.add(subentryentity.getBigDecimal("ddiff_g"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_h") != null) {
                        diff_h = diff_h.add(subentryentity.getBigDecimal("ddiff_h"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_k") != null) {
                        diff_k = diff_k.add(subentryentity.getBigDecimal("ddiff_k"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_p") != null) {
                        diff_p = diff_p.add(subentryentity.getBigDecimal("ddiff_p"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_q") != null) {
                        diff_q = diff_q.add(subentryentity.getBigDecimal("ddiff_q"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_r") != null) {
                        diff_r = diff_r.add(subentryentity.getBigDecimal("ddiff_r"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_m") != null) {
                        diff_m = diff_m.add(subentryentity.getBigDecimal("ddiff_m"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_s") != null) {
                        diff_s = diff_s.add(subentryentity.getBigDecimal("ddiff_s"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_t") != null) {
                        diff_t = diff_t.add(subentryentity.getBigDecimal("ddiff_t"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_c") != null) {
                        diff_c = diff_c.add(subentryentity.getBigDecimal("ddiff_c"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_x") != null) {
                        diff_x = diff_x.add(subentryentity.getBigDecimal("ddiff_x"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_w") != null) {
                        diff_w = diff_w.add(subentryentity.getBigDecimal("ddiff_w"));
                    }
                    if (subentryentity.getBigDecimal("ddiff_y") == null) continue;
                    diff_y = diff_y.add(subentryentity.getBigDecimal("ddiff_y"));
                }
                BigDecimal totalAdjustamt = BigDecimal.ZERO;
                totalAdjustamt = diff_g.add(diff_h).add(diff_k).add(diff_p).add(diff_q).add(diff_r).add(diff_m).add(diff_s).add(diff_t).add(diff_c).add(diff_x).add(diff_w).add(diff_y);
                entry.set("diff_g", (Object)diff_g);
                entry.set("diff_h", (Object)diff_h);
                entry.set("diff_k", (Object)diff_k);
                entry.set("diff_p", (Object)diff_p);
                entry.set("diff_q", (Object)diff_q);
                entry.set("diff_r", (Object)diff_r);
                entry.set("diff_m", (Object)diff_m);
                entry.set("diff_s", (Object)diff_s);
                entry.set("diff_t", (Object)diff_t);
                entry.set("diff_c", (Object)diff_c);
                entry.set("diff_x", (Object)diff_x);
                entry.set("diff_w", (Object)diff_w);
                entry.set("diff_y", (Object)diff_y);
                entry.set("adjustamt", (Object)totalAdjustamt);
            }
        }
    }
}

