/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostAdjustBillOpHelper;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.opplugin.validator.CalBillMustInputValidator;

public class StdCostDiffBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String[] SUB_AMT_FIELDS = new String[]{"ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("isupdatecost");
        e.getFieldKeys().add("entryentity.warehouse.isopenlocation");
        e.getFieldKeys().add("entryentity.material.isuseauxpty");
        e.getFieldKeys().add("entryentity.material.configproperties");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("costaccount.id");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("entryentity.storageorgunit");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("entryentity.lot");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("entryentity.project");
        e.getFieldKeys().add("entryentity.ownertype");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.calrange");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.caldimension");
        e.getFieldKeys().add("entryentity.signnum");
        e.getFieldKeys().add("entryentity.invbillid");
        e.getFieldKeys().add("entryentity.mversion");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.costdomainkey");
        e.getFieldKeys().add("entryentity.noupdatecalfields");
        e.getFieldKeys().add("entryentity.stocktype");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (String entryField : exFieldSet) {
            e.getFieldKeys().add("entryentity." + entryField);
        }
        e.getFieldKeys().add("entryentity.configuredcode");
        e.getFieldKeys().add("entryentity.tracknumber");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("adminorg");
        e.getFieldKeys().add("entryentity.ecostcenter");
        e.getFieldKeys().add("entryentity.entrystatus");
        e.getFieldKeys().add("entryentity.subentryentity");
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("costelement");
        e.getFieldKeys().add("sub_material");
        e.getFieldKeys().add("sub_currency");
        e.getFieldKeys().add("sub_adjustamt");
        e.getFieldKeys().add("ddiff_g");
        e.getFieldKeys().add("ddiff_h");
        e.getFieldKeys().add("ddiff_k");
        e.getFieldKeys().add("ddiff_p");
        e.getFieldKeys().add("ddiff_q");
        e.getFieldKeys().add("ddiff_r");
        e.getFieldKeys().add("ddiff_m");
        e.getFieldKeys().add("ddiff_s");
        e.getFieldKeys().add("ddiff_t");
        e.getFieldKeys().add("ddiff_c");
        e.getFieldKeys().add("ddiff_x");
        e.getFieldKeys().add("ddiff_w");
        e.getFieldKeys().add("ddiff_y");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.diff_g");
        e.getFieldKeys().add("entryentity.diff_h");
        e.getFieldKeys().add("entryentity.diff_k");
        e.getFieldKeys().add("entryentity.diff_p");
        e.getFieldKeys().add("entryentity.diff_q");
        e.getFieldKeys().add("entryentity.diff_r");
        e.getFieldKeys().add("entryentity.diff_m");
        e.getFieldKeys().add("entryentity.diff_s");
        e.getFieldKeys().add("entryentity.diff_t");
        e.getFieldKeys().add("entryentity.diff_c");
        e.getFieldKeys().add("entryentity.diff_x");
        e.getFieldKeys().add("entryentity.diff_w");
        e.getFieldKeys().add("entryentity.diff_y");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalBillMustInputValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                HashMap storMaterialsMap = new HashMap(16);
                HashSet<Long> materialIds = new HashSet<Long>(16);
                for (ExtendedDataEntity billInfo : billInfos) {
                    DynamicObject bill = billInfo.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    if (entrys == null) continue;
                    for (DynamicObject dynamicObject : entrys) {
                        if (dynamicObject.get("storageorgunit") == null || dynamicObject.get("material") == null) {
                            return;
                        }
                        Long storageorgunitId = dynamicObject.getLong("storageorgunit.id");
                        Long materialId = dynamicObject.getLong("material.id");
                        materialIds.add(materialId);
                        if (storageorgunitId == null || materialId == null) continue;
                        Set materials = (Set)storMaterialsMap.get(storageorgunitId);
                        if (materials == null) {
                            HashSet<Long> set = new HashSet<Long>();
                            set.add(materialId);
                            storMaterialsMap.put(storageorgunitId, set);
                            continue;
                        }
                        materials.add(materialId);
                    }
                }
                HashMap<String, Boolean> enableMap = new HashMap<String, Boolean>();
                for (Map.Entry entry : storMaterialsMap.entrySet()) {
                    long stoId = (Long)entry.getKey();
                    Set matIds = (Set)entry.getValue();
                    QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
                    DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)qFilter, (String)"id,masterid,enablelot");
                    for (DynamicObject dynamicObject : stockMaterialInfos) {
                        Object matereial = dynamicObject.get("masterid");
                        if (matereial instanceof DynamicObject) {
                            matereial = ((DynamicObject)matereial).getLong("id");
                        }
                        String key = String.valueOf(stoId) + "_" + matereial;
                        boolean enable = dynamicObject.getBoolean("enablelot");
                        if (enableMap.get(key) != null) continue;
                        enableMap.put(key, enable);
                    }
                }
                ArrayList<String> selectKeys = new ArrayList<String>(16);
                selectKeys.add("isuseauxpty");
                selectKeys.add("name");
                selectKeys.add("auxptyentry");
                MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_material", selectKeys);
                Map materialInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (DynamicObjectType)subType);
                HashMap<Long, DynamicObject> costAccount2CurPeriodMap = new HashMap<Long, DynamicObject>(16);
                for (ExtendedDataEntity billInfo : billInfos) {
                    DynamicObject bill = billInfo.getDataEntity();
                    Date bookdate = bill.getDate("bookdate");
                    DynamicObject costaccount = bill.getDynamicObject("costaccount");
                    if (costaccount == null) {
                        return;
                    }
                    Long costaccountId = costaccount.getLong("id");
                    DynamicObject period = (DynamicObject)costAccount2CurPeriodMap.get(costaccountId);
                    if (period == null) {
                        period = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
                        costAccount2CurPeriodMap.put(costaccountId, period);
                    }
                    if (period == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostAdjustBillSubmitOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                    Date beginDate = period.getDate("begindate");
                    boolean compareDate = DateUtils.compareDate((Date)bookdate, (Date)beginDate);
                    if (!compareDate) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u6b64\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u671f\u671f\u95f4\u8d77\u59cb\u65e5\u671f\u3002", (String)"CostAdjustBillSubmitOp_8", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    int size = entrys.size();
                    for (int i = 0; i < size; ++i) {
                        DynamicObjectCollection auxCol;
                        boolean isisuseauxpty;
                        int rowNumber = i + 1;
                        DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                        if (entryInfo.getDynamicObject("material") == null) continue;
                        DynamicObjectCollection subentryentitys = entryInfo.getDynamicObjectCollection("subentryentity");
                        if (null == subentryentitys || subentryentitys.isEmpty()) {
                            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u7684\u7269\u6599\u660e\u7ec6\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u6761\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u5206\u5f55\u3002", (String)"StdCostDiffBillImportValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        }
                        boolean subentryentityAllZero = true;
                        block8: for (DynamicObject subentryentity : subentryentitys) {
                            for (String subamtfield : SUB_AMT_FIELDS) {
                                BigDecimal amtField = subentryentity.getBigDecimal(subamtfield);
                                if (amtField == null || amtField.compareTo(BigDecimal.ZERO) == 0) continue;
                                subentryentityAllZero = false;
                                continue block8;
                            }
                        }
                        if (subentryentityAllZero) {
                            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u7684\u5168\u90e8\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u7684\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u80050\u3002", (String)"StdCostDiffBillImportValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        }
                        Object materialID = entryInfo.getDynamicObject("material").getPkValue();
                        String storageorgunit = entryInfo.getString("storageorgunit.id");
                        if (StringUtils.isEmpty((String)storageorgunit)) continue;
                        StringBuilder sBuilder = new StringBuilder(32);
                        sBuilder.append(storageorgunit);
                        sBuilder.append('_');
                        sBuilder.append(materialID);
                        Object assist = entryInfo.get("assist");
                        DynamicObject materialInfo = (DynamicObject)materialInfoMap.get(materialID);
                        if (materialInfo == null || !(isisuseauxpty = materialInfo.getBoolean("isuseauxpty")) || (auxCol = materialInfo.getDynamicObjectCollection("auxptyentry")) == null || auxCol.size() == 0 || assist == null) continue;
                        String auxValue = ((DynamicObject)assist).get("value").toString();
                        try {
                            Map map = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                            int billAuxSize = map.size();
                            if (auxCol.size() == billAuxSize) continue;
                            String content = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"CostAdjustBillSubmitOp_13", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowNumber);
                            this.addErrorMessage(billInfo, content);
                            continue;
                        }
                        catch (IOException e) {
                            String content = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f85\u52a9\u5c5e\u6027\u503c\u662f\u5f02\u5e38%1$s", (String)"CostAdjustBillSubmitOp_14", (String)"fi-cal-opplugin", (Object[])new Object[0]), e.getMessage());
                            throw new KDBizException(content);
                        }
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] costAdjustBill = e.getDataEntities();
        CostAdjustBillOpHelper helper = new CostAdjustBillOpHelper(costAdjustBill);
        helper.handleBillPeriod(costAdjustBill);
        helper.handleBillCalRange(costAdjustBill);
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject info : costAdjustBill) {
            if ("submit".equals(e.getOperationKey())) {
                info.set("lastupdateuser", (Object)userDyc);
                info.set("lastupdatetime", (Object)new Date());
                info.set("bookdate", info.get("bookdate"));
            }
            for (DynamicObject entryDyc : info.getDynamicObjectCollection("entryentity")) {
                entryDyc.set("entrystatus", (Object)"B");
            }
        }
        StringBuilder msg = new StringBuilder();
        for (DynamicObject info : costAdjustBill) {
            String billnum = info.getString("billno");
            HashSet<String> seqs = new HashSet<String>(16);
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entry.get(i);
                int rowNum = i + 1;
                Object calrangeid = entryRow.get("calrange");
                entryRow.set("seq", (Object)rowNum);
                if (calrangeid != null && !"0".equals(calrangeid.toString())) continue;
                seqs.add(rowNum + "");
            }
            if (seqs.isEmpty()) continue;
            String s = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7b2c%2$s\u884c\u5206\u5f55\u672a\u627e\u5230\u6838\u7b97\u8303\u56f4\u3002", (String)"CostAdjustBillSubmitOp_23", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(s + "\r\n", billnum, String.join((CharSequence)",", seqs));
            msg.append(errorMsg);
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject bill : costAdjustBill) {
            String billsrctype = bill.getString("createtype");
            if (!CostAdjustBilCreateTypeEnum.HAND.getValue().equals(billsrctype)) continue;
            list.add(bill);
        }
        DynamicObject[] handCreateBills = list.toArray(new DynamicObject[0]);
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(handCreateBills);
        Map storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_costadjust_subentity", "entryentity");
        for (DynamicObject info : costAdjustBill) {
            String billsrctype = info.getString("createtype");
            if (!CostAdjustBilCreateTypeEnum.HAND.getValue().equals(billsrctype)) continue;
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                DynamicObject material = entry.getDynamicObject("material");
                long materialId = material.getLong("id");
                DynamicObject storageorgunit = entry.getDynamicObject("storageorgunit");
                long storageOrgId = storageorgunit.getLong("id");
                String curUnionKey = storageOrgId + "#" + materialId;
                Long storageInvId = (Long)unionKeyAndStorageInvId.get(curUnionKey);
                String noUpdateStr = (String)storageInvIdAndNoUpdateStr.get(storageInvId);
                entry.set("noupdatecalfields", (Object)noUpdateStr);
            }
        }
    }
}

