/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.datacheck;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;

public class DataCheckItemSavePlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DataCheckItemSavePlugin.class);
    private static final String CHECKMODE = "checkmode";
    private static final String BIZOBJECT = "bizobject";
    private static final String CUSTOMFILTERTEXT = "customfiltertext";
    private static final String CUSTOMFILTER = "customfilter_tag";
    private static final String PLUGIN = "plugin";
    private static final String EXPMSGFIELDS = "expmsgfields";
    private static final String CUSTOMPLUGIN = "kd.fi.cal.business.datacheck.item.CustomDataCheck";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(CHECKMODE);
        e.getFieldKeys().add(BIZOBJECT);
        e.getFieldKeys().add(CUSTOMFILTERTEXT);
        e.getFieldKeys().add(CUSTOMFILTER);
        e.getFieldKeys().add(PLUGIN);
        e.getFieldKeys().add(EXPMSGFIELDS);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] checkItems;
                block13: for (ExtendedDataEntity checkItem : checkItems = this.getDataEntities()) {
                    String checkMode;
                    DynamicObject item = checkItem.getDataEntity();
                    switch (checkMode = item.getString(DataCheckItemSavePlugin.CHECKMODE)) {
                        case "A": {
                            String expMsgFields;
                            String filterText;
                            DynamicObject bizObject = item.getDynamicObject(DataCheckItemSavePlugin.BIZOBJECT);
                            if (bizObject == null) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"DataCheckItemSavePlugin_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                            }
                            if ((filterText = item.getString(DataCheckItemSavePlugin.CUSTOMFILTER)) == null || "".equals(filterText)) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DataCheckItemSavePlugin_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                            }
                            if ((expMsgFields = item.getString(DataCheckItemSavePlugin.EXPMSGFIELDS)) == null || "".equals(expMsgFields)) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f02\u5e38\u5185\u5bb9\u63cf\u8ff0\u3002", (String)"DataCheckItemSavePlugin_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                            }
                            try {
                                if (filterText == null || "".equals(filterText)) continue block13;
                                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)item.getDynamicObject(DataCheckItemSavePlugin.BIZOBJECT).getString("number"));
                                String selectFields = DataCheckItemSavePlugin.this.getCustomSelectFields(item, entityType);
                                QFilter q = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
                                q.and(DataCheckItemSavePlugin.this.getCustomQfilter(item, entityType));
                                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityType.getName(), (String)selectFields, (QFilter[])q.toArray(), null);
                                dataSet.close();
                            }
                            catch (Exception e) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataCheckItemSavePlugin_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                                WriteLogHelper.writeErrorLog((Log)logger, (String)"DataCheckItemSavePlugin-onAddValidators1", (Throwable)e);
                            }
                            continue block13;
                        }
                        case "B": {
                            String plugin = item.getString(DataCheckItemSavePlugin.PLUGIN);
                            if (plugin == null || "".equals(plugin)) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u63d2\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCheckItemSavePlugin_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                                continue block13;
                            }
                            try {
                                Class<?> clazz = Class.forName(plugin);
                                IDataCheck iDataCheck = (IDataCheck)clazz.newInstance();
                                continue block13;
                            }
                            catch (ClassNotFoundException e) {
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u60a8\u914d\u7f6e\u7684\u63d2\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataCheckItemSavePlugin_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                                WriteLogHelper.writeErrorLog((Log)logger, (String)"DataCheckItemSavePlugin-onAddValidators2", (Throwable)e);
                                continue block13;
                            }
                            catch (Throwable e) {
                                this.addErrorMessage(checkItem, e.getMessage());
                                WriteLogHelper.writeErrorLog((Log)logger, (String)"DataCheckItemSavePlugin-onAddValidators3", (Throwable)e);
                            }
                        }
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject item = e.getDataEntities()[0];
        String checkMode = item.getString(CHECKMODE);
        if ("A".equals(checkMode)) {
            item.set(PLUGIN, (Object)CUSTOMPLUGIN);
        }
    }

    private QFilter getCustomQfilter(DynamicObject item, MainEntityType entityType) {
        String filterStr = item.getString(CUSTOMFILTER);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityType.getName());
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter baseQ = filterBuilder.getQFilter();
        String experss = condition.getExpression();
        if (!"".equals(experss)) {
            String[] subExpressArray = experss.split(" ");
            StringBuilder newExperss = new StringBuilder();
            for (String subExpress : subExpressArray) {
                String nameHead = subExpress.split("\\.")[0];
                IDataEntityProperty fieldProperty = mainEntityType.findProperty(nameHead);
                if (fieldProperty != null && fieldProperty.getParent() instanceof EntryType) {
                    EntryType entry = (EntryType)fieldProperty.getParent();
                    String entryName = entry.getName();
                    subExpress = entryName + "." + subExpress;
                }
                newExperss.append(subExpress);
                newExperss.append(' ');
            }
            QFilter expressFilter = QFilter.of((String)newExperss.toString().trim(), (Object[])new Object[0]);
            if (baseQ != null) {
                baseQ.and(expressFilter);
            } else {
                baseQ = expressFilter;
            }
        }
        return baseQ;
    }

    private String getCustomSelectFields(DynamicObject item, MainEntityType entityType) {
        String[] Fields = item.getString(EXPMSGFIELDS).split(",");
        StringBuilder selectBuilder = new StringBuilder();
        for (String field : Fields) {
            DynamicProperty fieldEntity = entityType.getProperty(field);
            if (fieldEntity instanceof BasedataProp) {
                selectBuilder.append(field).append(".name as ").append(field).append(',');
                continue;
            }
            selectBuilder.append(field).append(",");
        }
        return "id," + CommonUtils.trimComma((String)selectBuilder.toString());
    }
}

