/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.datacheck;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckParamParser;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.business.datacheck.DataCheckTaskFactory;
import kd.fi.cal.common.util.CommonUtils;

public class DataCheckPlanRunPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("costaccount");
        keyList.add("calorg");
        keyList.add("storageorgunit");
        keyList.add("material");
        keyList.add("warehouse");
        keyList.add("location");
        keyList.add("invtype");
        keyList.add("invstatus");
        keyList.add("project");
        keyList.add("mversion");
        keyList.add("checktask");
        keyList.add("startDate");
        keyList.add("endDate");
        keyList.add("msgreceiver");
        keyList.add("msgstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        for (DynamicObject plan : e.getDataEntities()) {
            DataCheckParam param = DataCheckParamParser.parse((DynamicObject)plan);
            DynamicObject checkTask = plan.getDynamicObject("checktask");
            if (checkTask == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u8fd0\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u9009\u62e9\u68c0\u67e5\u4efb\u52a1\u3002", (String)"DataCheckPlanRunPlugin_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
            DataCheckTask task = DataCheckTaskFactory.createDataCheckTask((Long)checkTask.getLong("id"));
            task.setPlanId(Long.valueOf(plan.getLong("id")));
            task.setPlanType("cal_datacheck_plan");
            task.setCalorg(this.getNamesString(plan.getDynamicObjectCollection("calorg")));
            task.setCostaccount(this.getNamesString(plan.getDynamicObjectCollection("costaccount")));
            task.setPurpose(plan.getDynamicObject("checktask").getString("purpose"));
            executor.commit(task, param);
        }
    }

    private String getNamesString(DynamicObjectCollection collections) {
        String nameString;
        StringBuilder names = new StringBuilder();
        if (collections != null && !collections.isEmpty()) {
            for (DynamicObject collection : collections) {
                names.append(collection.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue());
                names.append(',');
            }
        }
        if ((nameString = CommonUtils.trimComma((String)names.toString())).length() > 255) {
            nameString = nameString.substring(0, 252);
            nameString = nameString + "...";
        }
        return nameString;
    }
}

