/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.datacheck;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class DataCheckPlanSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String[] CKDAY = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    private static final String SCHEDULE_TASK_DEFINEID = "0N9J669IQ+R4";
    private static final String SCHEDULE_TASK_CLASSNAME = "kd.fi.cal.formplugin.datacheck.DataCheckScheduleTask";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object schduleID;
        Object jobID;
        super.beginOperationTransaction(e);
        DynamicObject plan = e.getDataEntities()[0];
        DynamicObject schedulePlan = null;
        if (plan.getDataEntityState().getFromDatabase()) {
            schedulePlan = BusinessDataServiceHelper.loadSingle((Object)plan.getDynamicObject("schedule").getPkValue(), (String)"sch_schedule");
            this.refreshScheduleDynamicObject(schedulePlan, plan);
            try (TXHandle handler = TX.beginNew();){
                this.doSaveOp(schedulePlan, "sch_schedule");
            }
        }
        try (TXHandle handler = TX.beginNew();){
            DynamicObject shceduleJob = this.createNewScheduleJob(plan);
            jobID = this.doSaveOp(shceduleJob, "sch_job");
            schedulePlan = BusinessDataServiceHelper.newDynamicObject((String)"sch_schedule");
            this.refreshScheduleDynamicObject(schedulePlan, plan);
            schedulePlan.set("job", jobID);
            schduleID = this.doSaveOp(schedulePlan, "sch_schedule");
        }
        plan.set("schedule", schduleID);
        plan.set("job", jobID);
    }

    private Object doSaveOp(DynamicObject obj, String objType) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)objType, (DynamicObject[])new DynamicObject[]{obj}, null);
        if (!saveResult.isSuccess()) {
            String message = ((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            String content = String.format(ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"DataCheckPlanSavePlugin_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), message);
            throw new KDBizException(content);
        }
        Object objId = saveResult.getSuccessPkIds().get(0);
        return objId;
    }

    private void refreshScheduleDynamicObject(DynamicObject schedulePlan, DynamicObject plan) {
        for (String month : CKMONTH) {
            schedulePlan.set(month, plan.get(month));
        }
        for (String date : CKDATE) {
            schedulePlan.set(date, plan.get(date));
        }
        for (String day : CKDAY) {
            schedulePlan.set(day, plan.get(day));
        }
        schedulePlan.set("txtdesc", plan.get("txtdesc"));
        schedulePlan.set("repeatmode", plan.get("repeatmode"));
        schedulePlan.set("cyclenum", plan.get("cyclenum"));
        schedulePlan.set("combdorw", plan.get("combdorw"));
        schedulePlan.set("comno", plan.get("comno"));
        schedulePlan.set("comweek", plan.get("comweek"));
        schedulePlan.set("number", plan.get("number"));
        schedulePlan.set("name", plan.get("name"));
        schedulePlan.set("starttime", plan.get("starttime"));
        schedulePlan.set("endtime", plan.get("endtime"));
        schedulePlan.set("plan", plan.get("plan"));
        schedulePlan.set("status", (Object)Character.valueOf('1'));
    }

    private DynamicObject createNewScheduleJob(DynamicObject plan) {
        DynamicObject shceduleJob = BusinessDataServiceHelper.newDynamicObject((String)"sch_job");
        shceduleJob.set("number", plan.get("number"));
        shceduleJob.set("name", plan.get("name"));
        shceduleJob.set("jobtype", (Object)"BIZ");
        shceduleJob.set("taskclassname", (Object)SCHEDULE_TASK_DEFINEID);
        shceduleJob.set("classname", (Object)SCHEDULE_TASK_CLASSNAME);
        shceduleJob.set("runbyuser", (Object)RequestContext.get().getUserId());
        shceduleJob.set("status", (Object)Character.valueOf('1'));
        boolean runconcurrent = true;
        shceduleJob.set("runconcurrent", (Object)runconcurrent);
        DynamicObject paramEntry = shceduleJob.getDynamicObjectCollection("entryentity").addNew();
        paramEntry.set("paramname", (Object)"number");
        paramEntry.set("paramvalue", (Object)plan.getString("number"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("number", plan.getString("number"));
        String paramStr = JSON.toJSONString(params);
        shceduleJob.set("params", (Object)paramStr);
        return shceduleJob;
    }
}

