/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.datacheck;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class DataCheckTaskSavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extendEntitys;
                for (ExtendedDataEntity extendEntity : extendEntitys = this.getDataEntities()) {
                    DynamicObjectCollection entryCol = extendEntity.getDataEntity().getDynamicObjectCollection("entryentity");
                    if (entryCol == null || entryCol.isEmpty()) {
                        this.addErrorMessage(extendEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u5b58\u5728\u4e00\u9879\u68c0\u67e5\u9879", (String)"DataCheckTaskSavePlugin_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    HashMap<String, DynamicObject> checkItemsMap = new HashMap<String, DynamicObject>(entryCol.size());
                    for (DynamicObject entry : entryCol) {
                        DynamicObject checkItem = entry.getDynamicObject("checkitem");
                        if (checkItem == null) continue;
                        String itemNumber = checkItem.getString("number");
                        if (checkItemsMap.containsKey(itemNumber)) {
                            int nowSeq = entry.getInt("seq");
                            int prevSeq = ((DynamicObject)checkItemsMap.get(itemNumber)).getInt("seq");
                            String errorMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u5b58\u5728\u91cd\u590d\u68c0\u67e5\u9879:%3$s,\u8bf7\u4fee\u6539\u3002", (String)"DataCheckTaskSavePlugin_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), prevSeq, nowSeq, itemNumber);
                            this.addErrorMessage(extendEntity, errorMsg);
                            continue;
                        }
                        checkItemsMap.put(itemNumber, entry);
                    }
                }
            }
        });
    }
}

