/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.fallprice;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.opplugin.validator.FallPriceBillDimValidator;
import kd.fi.cal.opplugin.validator.FallPriceEmptyEntryValidator;

public class FallPriceProvBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entry.seq");
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FallPriceEmptyEntryValidator());
        e.addValidator((AbstractValidator)new FallPriceBillDimValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject dataEntity : dataEntities) {
            if (!"submit".equals(e.getOperationKey())) continue;
            dataEntity.set("lastupdateuser", (Object)userDyc);
            dataEntity.set("lastupdatetime", (Object)new Date());
        }
        if (this.getOption().tryGetVariableValue("fromedit", new RefObject())) {
            FallPriceHelper.writeBackPreEndPeriod((DynamicObject[])e.getDataEntities());
        } else {
            ArrayList<DynamicObject> billDycs = new ArrayList<DynamicObject>(16);
            for (DynamicObject billDyc : dataEntities) {
                Boolean provAll;
                DynamicObject calOrgDyc = billDyc.getDynamicObject("org");
                if (calOrgDyc == null || (provAll = (Boolean)ParamsHelper.getAppParam((long)((Long)calOrgDyc.getPkValue()), (String)"provall")).booleanValue()) continue;
                billDycs.add(billDyc);
            }
            FallPriceHelper.writeBackPreEndPeriodDelEntry((DynamicObject[])billDycs.toArray(new DynamicObject[0]));
        }
    }
}

