/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.fallprice;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.opplugin.validator.FallPriceRevBillDimValidator;

public class FallPriceRevBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("curperiodrushamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FallPriceRevBillDimValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryInfos = dataEntity.getDynamicObjectCollection("entry");
            BigDecimal rushAmount = BigDecimal.ZERO;
            Iterator entryIter = entryInfos.iterator();
            while (entryIter.hasNext()) {
                DynamicObject entryInfo = (DynamicObject)entryIter.next();
                rushAmount = entryInfo.getBigDecimal("curperiodrushamount");
                if (rushAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                entryIter.remove();
            }
        }
    }
}

