/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.fallprice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.opplugin.base.CalBaseAuditOrUnAuditOP;
import kd.fi.cal.opplugin.validator.FallPriceDimValidator;

public class FallPriceSettingAuditOp
extends CalBaseAuditOrUnAuditOP {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entry.seq");
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FallPriceDimValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.calMaxInvAgeTo(e.getDataEntities());
    }

    private void calMaxInvAgeTo(DynamicObject[] settingDycs) {
        for (DynamicObject settingDyc : settingDycs) {
            DynamicObjectCollection entryDycs = settingDyc.getDynamicObjectCollection("entry");
            int maxInvAge = 0;
            int maxInvAgeFrom = 0;
            for (DynamicObject entryDyc : entryDycs) {
                int invAgeFrom;
                int invAge = entryDyc.getInt("invageto");
                if (invAge > maxInvAge && invAge < 999999) {
                    maxInvAge = invAge;
                }
                if ((invAgeFrom = entryDyc.getInt("invagefrom")) <= maxInvAgeFrom || invAgeFrom >= 999999) continue;
                maxInvAgeFrom = invAgeFrom;
            }
            if (maxInvAge > maxInvAgeFrom) {
                settingDyc.set("maximumage", (Object)maxInvAge);
                continue;
            }
            settingDyc.set("maximumage", (Object)maxInvAgeFrom);
        }
    }

    @Override
    public String getApproverName() {
        return "auditor";
    }

    @Override
    public String getApprovetimeName() {
        return "auditdate";
    }
}

