/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.log;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.ActionEnum;

public class UpdSyncbizbillLogImport
extends BatchImportPlugin {
    public String getDefaultImportType() {
        return "override";
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (!"override".equals(this.ctx.getOption().get("importtype"))) {
            String errMsg = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u66f4\u65b0\u5df2\u6709\u6570\u636e\u64cd\u4f5c\u3002", (String)"UpdSyncbizbillLogImport_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            Iterator<ImportBillData> it = billdatas.iterator();
            while (it.hasNext()) {
                logger.log(Integer.valueOf(it.next().getStartIndex()), errMsg).fail();
                it.remove();
            }
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(billdatas.size());
        for (ImportBillData data : billdatas) {
            JSONObject billdata = data.getData();
            billIds.add(billdata.getLongValue("id"));
        }
        if (billIds.isEmpty()) {
            return;
        }
        HashMap<Long, String> logStatusMap = new HashMap<Long, String>(billIds.size());
        DynamicObjectCollection logs = QueryServiceHelper.query((String)this.ctx.getBillFormId(), (String)"id,isclose,success", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        for (DynamicObject log : logs) {
            logStatusMap.put(log.getLong("id"), log.getString("success"));
        }
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            boolean submitOrUnSubmit;
            ImportBillData data = it.next();
            JSONObject billdata = data.getData();
            String actionname = billdata.getString("actionname");
            boolean bl = submitOrUnSubmit = ActionEnum.SUBMIT.getValue().equals(actionname) || ActionEnum.UN_SUBMIT.getValue().equals(actionname);
            if (!("AUDIT".equals(actionname) || "UNAUDIT".equals(actionname) || submitOrUnSubmit)) {
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u66f4\u65b0\u6838\u7b97\u5355\u540c\u6b65\u6216\u5ba1\u6838\u3001\u53cd\u5ba1\u6838\u7684\u65e5\u5fd7\u3002", (String)"UpdSyncbizbillLogImport_1", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            long id = billdata.getLongValue("id");
            if (!"5".equals(logStatusMap.get(id))) {
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u8fd0\u884c\u72b6\u6001\u4e3a\u8b66\u544a\u7684\u65e5\u5fd7\u8fdb\u884c\u662f\u5426\u5173\u95ed\u7684\u66f4\u65b0\u3002", (String)"UpdSyncbizbillLogImport_2", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            boolean close = billdata.getBoolean("isclose");
            if (close && StringUtils.isEmpty((String)billdata.getString("closereason"))) {
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u662f\u5426\u5173\u95ed\u4e3a\u662f\uff0c\u8bf7\u5f55\u5165\u5173\u95ed\u539f\u56e0\u3002", (String)"UpdSyncbizbillLogImport_3", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            if (close || !StringUtils.isNotEmpty((String)billdata.getString("closereason"))) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u662f\u5426\u5173\u95ed\u4e3a\u5426\uff0c\u8bf7\u6e05\u7a7a\u5173\u95ed\u539f\u56e0\u3002", (String)"UpdSyncbizbillLogImport_4", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
            it.remove();
        }
    }
}

