/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.queryscheme;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.util.ExceptionUtils;

public class AbstractQuerySchemeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("schemestr_tag");
        e.getFieldKeys().add("formid");
    }

    protected DynamicObject getFormDycByScheme(DynamicObject schemeDyc) {
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        String entityId = schemeDyc.getString("formid.id");
        DynamicObject formDyc = this.toDynamicObject(filterSchemeStr, entityId);
        return formDyc;
    }

    protected Map<String, List<Integer>> getEntryKeySelRowIndexMap(DynamicObject schemeDyc) {
        Map<String, List<Integer>> entrySelRowsMap = new HashMap<String, List<Integer>>(16);
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterSchemeStr, HashMap.class);
        Map custSelectRows = (Map)filterMap.get("custselectrows");
        if (custSelectRows != null) {
            entrySelRowsMap = custSelectRows;
        }
        return entrySelRowsMap;
    }

    protected int[] integerListToIntArray(List<Integer> selectRowIndexs) {
        if (selectRowIndexs == null) {
            return new int[0];
        }
        int[] selectRowIndexArrays = new int[selectRowIndexs.size()];
        for (int i = 0; i < selectRowIndexs.size(); ++i) {
            selectRowIndexArrays[i] = selectRowIndexs.get(i);
        }
        return selectRowIndexArrays;
    }

    protected void addErrorBillInfo(DynamicObject schemeDyc, Throwable throwable) {
        if (schemeDyc == null || throwable == null) {
            return;
        }
        String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(throwable));
        if (throwable instanceof KDBizException) {
            msg = throwable.getMessage();
        }
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(msg);
        operateErrorInfo.setPkValue(schemeDyc.getPkValue());
        operateErrorInfo.setEntityKey(this.billEntityType.getName());
        operateErrorInfo.setEntityKey(this.billEntityType.getName());
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        this.getOperationResult().addErrorInfo(operateErrorInfo);
    }

    protected void addNotMatchError(DynamicObject schemeDyc) {
        String notMatchStr = ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u4e0e\u65b9\u6848\u4e0d\u5339\u914d\u3002", (String)"AbstractQuerySchemeOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        this.addErrorBillInfo(schemeDyc, (Throwable)new KDBizException(notMatchStr));
    }

    private DynamicObject toDynamicObject(String schemeJson, String entityId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        if (StringUtils.isEmpty((CharSequence)schemeJson)) {
            return new DynamicObject((DynamicObjectType)type);
        }
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get("custfilters");
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject fromDataDyc = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{fromDataDyc}, (IDataEntityType)type);
        return fromDataDyc;
    }
}

