/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.queryscheme;

import java.util.HashMap;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.opplugin.queryscheme.AbstractQuerySchemeOp;

public class CalOutQuerySchemeOp
extends AbstractQuerySchemeOp {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] schemeDycs;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject schemeDyc : schemeDycs = e.getDataEntities()) {
            String entityId = schemeDyc.getString("formid.id");
            if (!"cal_out_calculate".equals(entityId)) {
                this.addNotMatchError(schemeDyc);
                continue;
            }
            DynamicObject calOutDyc = this.getFormDycByScheme(schemeDyc);
            this.setCurrentPeriod(calOutDyc);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
            BusinessDataReader.loadRefence((Object[])new DynamicObject[]{calOutDyc}, (IDataEntityType)type);
            Long querySchemeId = (Long)schemeDyc.getPkValue();
            HashMap<String, Long> cusParamMap = new HashMap<String, Long>(16);
            cusParamMap.put("querySchemeId", querySchemeId);
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"CalculateOutService", (String)"calculateOutDyc", (Object[])new Object[]{calOutDyc, cusParamMap});
            }
            catch (Throwable throwable) {
                this.addErrorBillInfo(schemeDyc, throwable);
            }
        }
    }

    private void setCurrentPeriod(DynamicObject calOutDyc) {
        DynamicObjectCollection calOutEntryDycs = calOutDyc.getDynamicObjectCollection("entry");
        HashMap<Long, DynamicObject> accountIdPeriodIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject calRangeDyc : calOutEntryDycs) {
            long costAccountId;
            DynamicObject costAccountDyc = calRangeDyc.getDynamicObject("costaccount");
            DynamicObject periodDyc = null;
            if (costAccountDyc != null && (periodDyc = (DynamicObject)accountIdPeriodIdMap.get(costAccountId = costAccountDyc.getLong("id"))) == null) {
                DynamicObject currentPeriodDyc = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (currentPeriodDyc != null) {
                    accountIdPeriodIdMap.put(costAccountId, currentPeriodDyc);
                }
                periodDyc = currentPeriodDyc;
            }
            calRangeDyc.set("period", periodDyc);
        }
    }
}

