/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.queryscheme;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class QuerySchemeAutoOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("queryscheme");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] schemeAutoDycs = e.getDataEntities();
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashMap<Object, Object> schemeIdAutoIdMap = new HashMap<Object, Object>(16);
        for (DynamicObject schemeAutoDyc : schemeAutoDycs) {
            DynamicObject querySchemeDyc = schemeAutoDyc.getDynamicObject("queryscheme");
            if (querySchemeDyc == null) continue;
            schemeIds.add((Long)querySchemeDyc.getPkValue());
            schemeIdAutoIdMap.put(querySchemeDyc.getPkValue(), schemeAutoDyc.getPkValue());
        }
        String operator = (String)this.operateMeta.get("key");
        OperateOption option = OperateOption.create();
        OperationResult result = OperationServiceHelper.executeOperate((String)operator, (String)"cal_query_scheme", (Object[])schemeIds.toArray(new Long[0]), (OperateOption)option);
        this.addErrorBillInfo(schemeIdAutoIdMap, result);
    }

    private void addErrorBillInfo(Map<Object, Object> schemeIdAutoIdMap, OperationResult result) {
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            String message;
            for (IOperateInfo error : errors) {
                message = error.getMessage();
                Object pkValue = schemeIdAutoIdMap.get(error.getPkValue());
                OperateErrorInfo operateErrorInfo = this.getOperateErrorInfo(message, pkValue);
                this.getOperationResult().addErrorInfo(operateErrorInfo);
            }
            if (errors.isEmpty()) {
                for (Object autoId : schemeIdAutoIdMap.values()) {
                    message = result.getMessage();
                    OperateErrorInfo operateErrorInfo = this.getOperateErrorInfo(message, autoId);
                    this.getOperationResult().addErrorInfo(operateErrorInfo);
                }
            }
        }
    }

    private OperateErrorInfo getOperateErrorInfo(String message, Object pkValue) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(message);
        operateErrorInfo.setPkValue(pkValue);
        operateErrorInfo.setEntityKey(this.billEntityType.getName());
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        return operateErrorInfo;
    }
}

