/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.setting;

import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;

public class AccountGroupRepairOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("period");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] infos = e.getDataEntities();
        HashSet<String> costAccountIds = new HashSet<String>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<String> periodIdStr = new HashSet<String>(16);
        for (DynamicObject info : infos) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                DynamicObject costaccount = dynamicObject.getDynamicObject("costaccount");
                DynamicObject period = dynamicObject.getDynamicObject("period");
                String costAccountid = costaccount.getString("id");
                Long periodId = period.getLong("id");
                costAccountIds.add(costAccountid);
                periodIds.add(periodId);
                periodIdStr.add(periodId.toString());
            }
        }
        Date mindate = null;
        Date maxdate = null;
        try (DataSet periodDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter("id", "in", periodIds).toArray(), null);){
            for (Row row : periodDS) {
                Date begindate = row.getDate("begindate");
                Date enddate = row.getDate("enddate");
                if (mindate == null || mindate.after(begindate)) {
                    mindate = begindate;
                }
                if (maxdate != null && !maxdate.before(enddate)) continue;
                maxdate = enddate;
            }
        }
        mindate = new Date(0L);
        new CostAccountGroupRecordHelper().repairAndRefreshGroupRecordByTime(costAccountIds, periodIdStr, mindate, maxdate);
    }
}

