/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.opplugin.validator.CalSettingDividebasisValidator;

public class CalSettingSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.doCheck(dataEntity);
                }
            }

            private void doCheck(ExtendedDataEntity dataEntity) {
                String calgroupcols;
                DynamicObject setting = CommonSettingHelper.getSettingObj();
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String newEsstandard = dynamicObject.getString("esstandards");
                String oldEsstandard = setting.getString("esstandards");
                if (newEsstandard.length() > 255) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u603b\u957f\u5ea6\u8d85\u957f\uff0c\u8bf7\u53d6\u6d88\u52fe\u9009\u4e0d\u5fc5\u8981\u7684\u5206\u644a\u6807\u51c6\u3002", (String)"CalSettingSaveOP_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)oldEsstandard)) {
                    String[] oldEsstandards = oldEsstandard.split(",");
                    List<String> newEsstandardList = Arrays.asList(newEsstandard.split(","));
                    QFilter esstandardFilter = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
                    for (String old : oldEsstandards) {
                        if (StringUtils.isBlank((CharSequence)old) || newEsstandardList.contains(old)) continue;
                        esstandardFilter.or("expenseentity.estimatestandard", "=", (Object)old);
                    }
                    DynamicObjectCollection esstandardCol = QueryServiceHelper.query((String)"cal_costestimatebill", (String)"expenseentity.estimatestandard", (QFilter[])new QFilter[]{esstandardFilter}, null);
                    if (esstandardCol.size() > 0) {
                        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costestimatebill", (String)"expenseentity.estimatestandard as estimatestandard", null, null);
                        String[] groupByArrs = new String[]{"estimatestandard"};
                        dataSet = dataSet.groupBy(groupByArrs).finish();
                        ArrayList<String> allBillList = new ArrayList<String>(32);
                        while (dataSet.hasNext()) {
                            String val = dataSet.next().getString("estimatestandard");
                            allBillList.add(val);
                        }
                        ArrayList<String> loserList = new ArrayList<String>();
                        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdetail");
                        for (String s : allBillList) {
                            if (newEsstandardList.contains(s)) continue;
                            String loser = entitytype.getProperty(s).getDisplayName().toString();
                            loserList.add(loser);
                        }
                        if (!loserList.isEmpty()) {
                            String loserStr = String.join((CharSequence)",", loserList);
                            String content = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u53d6\u6d88\u7684\u52fe\u9009\u9879\u4ecd\u5728\u4f7f\u7528 ,\u8bf7\u4fdd\u7559: %1$s", (String)"CalSettingSaveOP_4", (String)"fi-cal-opplugin", (Object[])new Object[0]), loserStr);
                            this.addErrorMessage(dataEntity, content);
                        }
                    }
                }
                String string = calgroupcols = dataEntity.getDataEntity().get("calgroupcols") == null ? "" : (String)dataEntity.getDataEntity().get("calgroupcols");
                if (StringUtils.isEmpty((CharSequence)calgroupcols)) {
                    dynamicObject.set("calgroupcols", (Object)",owner,ownertype,storageorgunit,warehouse");
                } else {
                    String[] split = calgroupcols.split(",");
                    if (split != null) {
                        boolean allEmpty = true;
                        for (String s : split) {
                            if (StringUtils.isEmpty((CharSequence)s)) continue;
                            allEmpty = false;
                        }
                        if (allEmpty) {
                            dynamicObject.set("calgroupcols", (Object)",owner,ownertype,storageorgunit,warehouse");
                        } else if (",,".equals(calgroupcols)) {
                            dynamicObject.set("calgroupcols", (Object)",owner,ownertype,storageorgunit,warehouse");
                        }
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new CalSettingDividebasisValidator());
    }
}

