/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.setting;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ChangeEstimateExcuteOp
extends AbstractOperationServicePlugIn {
    private DynamicObject costAccount;
    private DynamicObject filter_period;
    private DynamicObjectCollection filter_bizObject;
    private Date filter_startTime;
    private Date filter_endTime;
    private String nowChargeType;
    private String[] filter_billno;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                DynamicObject info = billInfos[0].getDataEntity();
                DynamicObject period = info.getDynamicObject("period");
                Date endtime = info.getDate("endtime");
                if (period == null) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"ChangeEstimateExcuteOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (endtime.getTime() < period.getDate("begindate").getTime()) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5728\u5f00\u59cb\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e4b\u540e\u3002", (String)"ChangeEstimateExcuteOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.init(e.getDataEntities()[0]);
        this.changeAllBills();
    }

    private void init(DynamicObject info) {
        this.costAccount = info.getDynamicObject("costaccount");
        this.filter_period = info.getDynamicObject("period");
        this.filter_bizObject = info.getDynamicObjectCollection("bizentityobject");
        this.filter_startTime = info.getDate("starttime");
        this.filter_endTime = info.getDate("endtime");
        this.nowChargeType = info.getString("nowchargetype");
        if (!"".equals(info.getString("billno").trim())) {
            this.filter_billno = info.getString("billno").split(" ");
        }
    }

    private void changeAllBills() {
        Date periodStartTime = new Date();
        if (this.filter_period != null) {
            periodStartTime = this.filter_period.getDate("begindate");
        }
        QFilter checkAfterPeriodQ = this.getAfterPeriodFilter(periodStartTime, true);
        this.checkAfterPeriodInfos(checkAfterPeriodQ);
        QFilter afterPeriodQ = this.getAfterPeriodFilter(periodStartTime, false);
        this.dealAfterPeriodInfos(afterPeriodQ);
    }

    private void checkAfterPeriodInfos(QFilter checkQ) {
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,billno", (QFilter[])new QFilter[]{checkQ});
        if (infos.length > 0) {
            StringBuilder errMsg = new StringBuilder();
            for (DynamicObject info : infos) {
                if (errMsg.length() == 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s", (String)"ChangeEstimateExcuteOp_31", (String)"fi-cal-opplugin", (Object[])new Object[0]), info.getString("billno"));
                    errMsg.append(msg);
                    continue;
                }
                errMsg.append(",");
                errMsg.append(info.getString("billno"));
            }
            errMsg.append(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u6682\u4f30\u51b2\u56de\u65b9\u5f0f\u5207\u6362\u3002", (String)"ChangeEstimateExcuteOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            throw new KDBizException(errMsg.toString());
        }
    }

    private void dealAfterPeriodInfos(QFilter afterPeriodQ) {
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,dischargetype", (QFilter[])new QFilter[]{afterPeriodQ});
        if (infos.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5f53\u671f\u53ca\u4ee5\u540e\u671f\u95f4\u4e2d\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u3002", (String)"ChangeEstimateExcuteOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject info : infos) {
            info.set("dischargetype", (Object)this.nowChargeType);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
    }

    private void dealBeforePeriodInfos(QFilter beforePeriodQ) {
        DynamicObject[] infos;
        block10: for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,dischargetype", (QFilter[])new QFilter[]{beforePeriodQ})) {
            String oldChargeType = info.getString("dischargetype");
            switch (this.nowChargeType) {
                case "A": {
                    if ("B".equals(oldChargeType) || !"C".equals(oldChargeType)) continue block10;
                    continue block10;
                }
                case "B": {
                    if ("A".equals(oldChargeType) || !"C".equals(oldChargeType)) continue block10;
                    continue block10;
                }
                case "C": {
                    if ("A".equals(oldChargeType) || !"B".equals(oldChargeType)) continue block10;
                    continue block10;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])infos);
    }

    private QFilter getAfterPeriodFilter(Date periodStartTime, Boolean istempvoucher) {
        QFilter q = this.getBaseFilter();
        if (istempvoucher.booleanValue()) {
            QFilter istempvoucherQ = new QFilter("istempvoucher", "=", (Object)"1");
            QFilter isVoucherQ = new QFilter("dischargetype", "=", (Object)"C").and("isvoucher", "=", (Object)"1");
            q.and(istempvoucherQ.or(isVoucherQ));
        } else {
            QFilter istempvoucherQ = new QFilter("istempvoucher", "=", (Object)"0");
            QFilter isVoucherQ = new QFilter("dischargetype", "=", (Object)"C").and("isvoucher", "=", (Object)"0");
            q.and(istempvoucherQ.or(isVoucherQ));
        }
        if (this.filter_endTime.getTime() <= periodStartTime.getTime()) {
            return new QFilter("1", "!=", (Object)"1");
        }
        if (this.filter_endTime.getTime() > periodStartTime.getTime()) {
            if (this.filter_startTime.getTime() < periodStartTime.getTime()) {
                q.and(new QFilter("bookdate", ">=", (Object)periodStartTime));
                q.and(new QFilter("bookdate", "<=", (Object)this.filter_endTime));
            } else {
                q.and(new QFilter("bookdate", ">=", (Object)this.filter_startTime));
                q.and(new QFilter("bookdate", "<=", (Object)this.filter_endTime));
            }
        }
        return q;
    }

    private QFilter getBaseFilter() {
        QFilter q = new QFilter("costaccount", "=", this.costAccount.getPkValue());
        if (this.filter_bizObject != null) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : this.filter_bizObject) {
                set.add(info.get("fbasedataid_id"));
            }
            q.and("bizentityobject", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.nowChargeType != null) {
            q.and("dischargetype", "!=", (Object)this.nowChargeType);
        }
        return q;
    }
}

