/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.setting;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.opplugin.validator.CostPriceSchemeSaveValidator;

public class CostPriceSchemeSave
extends AbstractOperationServicePlugIn {
    private static final long PRICELIB_PAGEID = 747819409392815104L;
    private static final long COSTPRICE_PAGEID = 752057291171328000L;
    private Map<String, String> priceNameMap = new HashMap<String, String>(64);
    private Map<String, String> priceEntityMap = new HashMap<String, String>(64);
    private Map<String, String> costPriceNameMap = new HashMap<String, String>(16);
    private Map<String, String> costPriceEntityMap = new HashMap<String, String>(16);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostPriceSchemeSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("save".equals(key)) {
            this.doBefore(e);
        }
    }

    private void doBefore(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        DynamicObject dynamicObject = null;
        this.createPriceLibMap();
        this.createCostPriceMap();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dynamicObject = dynamicObjects[i];
            String priceobject = dynamicObject.getString("priceobject");
            String entityobject = dynamicObject.getDynamicObject("entityobject").getString("number");
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
            int rowIndex = 0;
            for (DynamicObject entryrow : entrys) {
                ++rowIndex;
                String srcprice = entryrow.getString("srcprice");
                String destprice = entryrow.getString("destprice");
                String costprice = entryrow.getString("costprice");
                srcprice = this.trimComma(srcprice);
                destprice = this.trimComma(destprice);
                if ("cal_in_calculate".equals(entityobject) && "YS-SGLR-001".equals(costprice)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u662f\u5165\u5e93\u6c47\u603b\u6838\u7b97\u65f6\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u6210\u672c\u4ef7\u7c7b\u522b\u4e0d\u80fd\u9009\u62e9\u624b\u5de5\u5f55\u5165\u3002", (String)"CostPriceSchemeSave_6", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowIndex);
                    throw new KDBizException(msg);
                }
                String entityObject = this.costPriceEntityMap.get(costprice);
                if (StringUtils.isNotEmpty((String)entityObject) && StringUtils.isNotEmpty((String)srcprice)) {
                    String errorMsg;
                    String[] srcPrices;
                    for (String string : srcPrices = srcprice.split(",")) {
                        if (entityObject.equals(this.priceEntityMap.get(string))) continue;
                        String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u5355\u4ef7\u7c7b\u522b\u7684\u4e1a\u52a1\u5bf9\u8c61\u9700\u8981\u548c\u5bf9\u5e94\u6210\u672c\u4ef7\u7c7b\u522b\u7684\u4e1a\u52a1\u5bf9\u8c61\u76f8\u540c\u3002", (String)"CostPriceSchemeSave_7", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowIndex);
                        throw new KDBizException(errorMsg2);
                    }
                    if (srcPrices.length > 10) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u5355\u4ef7\u7c7b\u522b\u7684\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u3002", (String)"CostPriceSchemeSave_4", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowIndex);
                        throw new KDBizException(errorMsg);
                    }
                    if (srcPrices.length != 1 && ("G".equals(priceobject) || "J".equals(priceobject))) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u5bf9\u8c61\u662f\u7ec4\u7ec7\u95f4\u4ea4\u6613/\u5916\u90e8\u5355\u636e\u53d6\u6210\u672c\u4ef7\u65f6\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u5355\u4ef7\u7c7b\u522b\u53ea\u80fd\u5355\u9009\u3002", (String)"CostPriceSchemeSave_8", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowIndex);
                        throw new KDBizException(errorMsg);
                    }
                }
                if (StringUtils.isNotEmpty((String)destprice)) {
                    String[] destprices = destprice.split(",");
                    String priceEntity = this.priceEntityMap.get(destprices[0]);
                    for (String string : destprices) {
                        if (priceEntity.equals(this.priceEntityMap.get(string))) continue;
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u7684\u591a\u4e2a\u76ee\u6807\u5355\u4ef7\u7c7b\u522b\u7684\u4e1a\u52a1\u5bf9\u8c61\u5fc5\u987b\u76f8\u540c\u3002", (String)"CostPriceSchemeSave_9", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowIndex);
                        throw new KDBizException(errorMsg);
                    }
                    if (destprices.length > 10) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6240\u9009\u62e9\u76ee\u6807\u5355\u4ef7\u7c7b\u522b\u7684\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u3002", (String)"CostPriceSchemeSave_10", (String)"fi-cal-opplugin", (Object[])new Object[0]), new Object[0]);
                        throw new KDBizException(errorMsg);
                    }
                }
                if ("G".equals(priceobject) || "J".equals(priceobject)) {
                    destprice = "ys-cal-018";
                }
                entryrow.set("srcprice", (Object)srcprice);
                entryrow.set("srcdisplay", (Object)this.getDisplayName(srcprice));
                entryrow.set("destprice", (Object)destprice);
                entryrow.set("destdisplay", (Object)this.getDisplayName(destprice));
                entryrow.set("costprice", (Object)costprice);
                entryrow.set("pricedisplay", this.getCostPriceDisplayName(costprice));
            }
        }
    }

    private Object getCostPriceDisplayName(String costprice) {
        String[] pricesArr;
        StringBuilder displayname = new StringBuilder(32);
        for (String s : pricesArr = costprice.split(",")) {
            if (StringUtils.isEmpty((String)s)) continue;
            displayname.append(this.costPriceNameMap.get(s)).append(',');
        }
        if (displayname.length() > 0) {
            return displayname.substring(0, displayname.length() - 1);
        }
        return "";
    }

    private void createCostPriceMap() {
        QFilter qpricelib = new QFilter("id", "=", (Object)752057291171328000L);
        DynamicObjectCollection prices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.pricename,entry.entityobject", (QFilter[])qpricelib.toArray());
        for (DynamicObject price : prices) {
            this.costPriceNameMap.put(price.getString("entry.pricenum"), price.getString("entry.pricename"));
            this.costPriceEntityMap.put(price.getString("entry.pricenum"), price.getString("entry.entityobject"));
        }
    }

    private void createPriceLibMap() {
        QFilter qpricelib = new QFilter("id", "=", (Object)747819409392815104L);
        DynamicObjectCollection prices = QueryServiceHelper.query((String)"cal_pricelib", (String)"entry.pricenum,entry.pricename,entry.entityobject", (QFilter[])qpricelib.toArray());
        for (DynamicObject price : prices) {
            this.priceNameMap.put(price.getString("entry.pricenum"), price.getString("entry.pricename"));
            this.priceEntityMap.put(price.getString("entry.pricenum"), price.getString("entry.entityobject"));
        }
    }

    private String getDisplayName(String prices) {
        String[] pricesArr;
        StringBuilder displayname = new StringBuilder(32);
        for (String s : pricesArr = prices.split(",")) {
            if (StringUtils.isEmpty((String)s)) continue;
            displayname.append(this.priceNameMap.get(s)).append(',');
        }
        if (displayname.length() > 0) {
            return displayname.substring(0, displayname.length() - 1);
        }
        return "";
    }

    private String trimComma(String prices) {
        if (StringUtils.isEmpty((String)prices)) {
            return "";
        }
        if (prices.startsWith(",")) {
            prices = prices.substring(1, prices.length());
        }
        if (prices.endsWith(",")) {
            prices = prices.substring(0, prices.length() - 1);
        }
        return prices;
    }
}

