/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.setting;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.adjbill.OrderDiffAdjBillCreateHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.util.CommonUtils;

public class StandardCostRegainOP
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(StandardCostRegainOP.class);
    private DynamicObject filter_CostAccount;
    private Set<Long> filter_MaterailIds = new HashSet<Long>(16);
    private Set<String> filter_billnos = new HashSet<String>(16);
    private String filter_bizEntityObject;
    private Date filter_StartDate;
    private Date filter_EndDate;
    private Set<Long> costTypeIds = new HashSet<Long>(16);
    private int amtPrecison = 2;
    private static final int BATCH_SIZE = 1000;
    private Set<Long> reCreateDiffBill_CostRecordIds = new HashSet<Long>(16);
    private Set<String> omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
    private static final String detailUpdateSql = "update t_cal_costrecord_detail set funitstandardcost = ?,fstandardcost = ? where fentryid = ? and fcostelementid = ? and fcostsubelementid = ?";
    private static final String detailEquUpdateSql = "update t_cal_costrecord_detail set funitstandardcost = ?,fstandardcost = ?, funitactualcost = ?,factualcost = ? where fentryid = ? and fcostelementid = ? and fcostsubelementid = ?";
    private static final String deleteDetailUpdateSql = "update t_cal_costrecord_detail set funitstandardcost = 0,fstandardcost =0 where fentryid = ?";
    private static final String deleteDetailEquUpdateSql = "update t_cal_costrecord_detail set funitstandardcost = 0,fstandardcost = 0, funitactualcost = 0,factualcost = 0 where fentryid = ?";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.init(e.getDataEntities()[0]);
        try (AlgoContext context = Algo.newContext();){
            logger.info("\u83b7\u53d6\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u548c\u7269\u6599\u6210\u672c\u4fe1\u606f");
            DataSet costRecordDS = this.getCostRecordDS();
            DataSet materialCostInfoDS = this.getMaterialCostInfos();
            this.handStandardCost(costRecordDS, materialCostInfoDS);
            logger.info("\u5904\u7406\u6210\u7ec4\u6210\u672c");
            logger.info("\u5220\u9664\u76f8\u5173\u5355\u636e\u751f\u6210\u7684\u5dee\u5f02\u5355");
            this.deleteCostDiffBill();
            logger.info("\u91cd\u65b0\u751f\u6210\u76f8\u5173\u5355\u636e\u7684\u5dee\u5f02\u5355");
            this.reCreateDiffBilll();
        }
    }

    private void reCreateDiffBilll() {
        if (this.reCreateDiffBill_CostRecordIds.isEmpty()) {
            return;
        }
        DynamicObject[] infos = BusinessDataServiceHelper.load((Object[])this.reCreateDiffBill_CostRecordIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord"));
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u5f00\u59cb\u751f\u6210\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            Long bizbillid = info.getLong("bizbillid");
            billIdSet.add(bizbillid);
        }
        HashMap tgCalentryIdGroupIdMap = new HashMap(16);
        HashMap groupIdSrcBillValueStrMap = new HashMap(16);
        OrderDiffAdjBillCreateHelper adjBillHelper = new OrderDiffAdjBillCreateHelper(Boolean.valueOf(true), infos);
        adjBillHelper.setCalentryIdGroupIdSrcBillValue(billIdSet, tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
        adjBillHelper.createCostAdjustBill(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u7ed3\u675f\u751f\u6210\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
    }

    private void deleteCostDiffBill() {
        if (this.reCreateDiffBill_CostRecordIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.BILL_SYNC.getValue());
        filter.and("entryentity.srcbilltype", "=", (Object)0);
        filter.and("entryentity.invbillid", "in", this.reCreateDiffBill_CostRecordIds);
        DynamicObjectCollection diffBills = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> diffBillid = new HashSet<Long>();
        for (DynamicObject bill : diffBills) {
            diffBillid.add(bill.getLong("id"));
        }
        if (diffBillid.isEmpty()) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])diffBillid.toArray(), (OperateOption)op);
        if (!result.isSuccess()) {
            List errors = result.getAllErrorOrValidateInfo();
            StringBuilder errorMsg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
                errorMsg.append('\n');
            }
            errorMsg.append(result.getMessage());
            throw new KDBizException(errorMsg.toString());
        }
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])diffBillid.toArray());
    }

    private void handStandardCost(DataSet costRecordDS, DataSet materialCostInfoDS) {
        ArrayList<Object[]> list;
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(1000);
        ArrayList<ArrayList<Object[]>> updateLists = new ArrayList<ArrayList<Object[]>>(16);
        updateLists.add(updateList);
        HashSet<Long> deleteSet = new HashSet<Long>(16);
        ArrayList<Object[]> updateEquList = new ArrayList<Object[]>(1000);
        ArrayList<ArrayList<Object[]>> updateEquLists = new ArrayList<ArrayList<Object[]>>(16);
        updateEquLists.add(updateEquList);
        HashSet<Long> deleteEquSet = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        DataSet costRecordMatCostInfoDS = costRecordDS.join(materialCostInfoDS.where("storageorgunit == 0"), JoinType.INNER).on("material", "material").select(new String[]{"id", "biztype", "bizentityobject", "entryid", "material", "baseqty", "standardcost", "actualcost", "auditdate"}, new String[]{"element", "subelement", "unitstandardcost", "effectdate", "expdate", "cteffectdate", "ctinvaliddate"}).finish().where("effectdate <= auditdate and expdate > auditdate and cteffectdate <= auditdate and ctinvaliddate > auditdate").union(costRecordDS.join(materialCostInfoDS.where("storageorgunit <> 0"), JoinType.INNER).on("material", "material").on("storageorgunit", "storageorgunit").select(new String[]{"id", "biztype", "bizentityobject", "entryid", "material", "baseqty", "standardcost", "actualcost", "auditdate"}, new String[]{"element", "subelement", "unitstandardcost", "effectdate", "expdate", "cteffectdate", "ctinvaliddate"}).finish().where("effectdate <= auditdate and expdate > auditdate and cteffectdate <= auditdate and ctinvaliddate > auditdate"));
        for (Row row : costRecordMatCostInfoDS) {
            Long crId = row.getLong("id");
            String bizEntityObject = row.getString("bizentityobject");
            BigDecimal baseqty = row.getBigDecimal("baseqty");
            BigDecimal unitStandCost = row.getBigDecimal("unitstandardcost");
            Long entryid = row.getLong("entryid");
            Long element = row.getLong("element");
            Long subelement = row.getLong("subelement");
            BigDecimal recordStandardcost = row.getBigDecimal("standardcost");
            BigDecimal recordActualcost = row.getBigDecimal("actualcost");
            BigDecimal standardCost = unitStandCost.multiply(baseqty).setScale(this.amtPrecison, RoundingMode.HALF_UP);
            entryIds.add(entryid);
            if ("im_purinbill".equals(bizEntityObject) || this.omInBills.contains(bizEntityObject)) {
                this.reCreateDiffBill_CostRecordIds.add(crId);
                if (updateList.size() > 1000) {
                    updateList = new ArrayList();
                    updateLists.add(updateList);
                }
                updateList.add(new Object[]{unitStandCost, standardCost, entryid, element, subelement});
                deleteSet.add(entryid);
                continue;
            }
            if (recordStandardcost.compareTo(recordActualcost) == 0) {
                if (updateEquList.size() > 1000) {
                    updateEquList = new ArrayList();
                    updateEquLists.add(updateEquList);
                }
                updateEquList.add(new Object[]{unitStandCost, standardCost, unitStandCost, standardCost, entryid, element, subelement});
                deleteEquSet.add(entryid);
                continue;
            }
            this.reCreateDiffBill_CostRecordIds.add(crId);
            if (updateList.size() > 1000) {
                updateList = new ArrayList();
                updateLists.add(updateList);
            }
            updateList.add(new Object[]{unitStandCost, standardCost, entryid, element, subelement});
            deleteSet.add(entryid);
        }
        if (!deleteSet.isEmpty()) {
            list = new ArrayList<Object[]>(16);
            for (Long entryid : deleteSet) {
                list.add(new Object[]{entryid});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleteDetailUpdateSql, list);
        }
        if (!deleteEquSet.isEmpty()) {
            list = new ArrayList(16);
            for (Long entryid : deleteEquSet) {
                list.add(new Object[]{entryid});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleteDetailEquUpdateSql, list);
        }
        for (List list2 : updateLists) {
            if (list2.isEmpty()) continue;
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailUpdateSql, (List)list2);
        }
        for (List list3 : updateEquLists) {
            if (list3.isEmpty()) continue;
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailEquUpdateSql, (List)list3);
        }
        if (!entryIds.isEmpty()) {
            CostElementHelper.calCostRecordAllCost((Long[])entryIds.toArray(new Long[0]));
        }
    }

    private DataSet getMaterialCostInfos() {
        QFilter orgCostTypeFilter = new QFilter("costaccount", "=", this.filter_CostAccount.getPkValue());
        orgCostTypeFilter.and("effectdate", "<=", (Object)this.filter_EndDate);
        orgCostTypeFilter.and("invaliddate", ">", (Object)this.filter_StartDate);
        orgCostTypeFilter.and("bizstatus", "=", (Object)"1");
        DataSet orgCostTypeDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costtypeorg", (String)"costaccount,storageorgunit,costtype,effectdate as cteffectdate,invaliddate as ctinvaliddate", (QFilter[])orgCostTypeFilter.toArray(), null);
        for (Row row : orgCostTypeDS.copy()) {
            this.costTypeIds.add(row.getLong("costtype"));
        }
        QFilter filter = new QFilter("costtype", "in", this.costTypeIds);
        if (!this.filter_MaterailIds.isEmpty()) {
            filter.and("material", "in", this.filter_MaterailIds);
        }
        filter.and("effectdate", "<=", (Object)this.filter_EndDate);
        filter.and("expdate", ">", (Object)this.filter_StartDate);
        DataSet materialInfoDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_matcostinfo", (String)"costtype,material,entryentity.element as element,entryentity.subelement as subelement,entryentity.standardcost as unitstandardcost,effectdate,expdate", (QFilter[])filter.toArray(), null);
        DataSet dataSet = orgCostTypeDS.join(materialInfoDS, JoinType.INNER).on("costtype", "costtype").select(new String[]{"costaccount", "storageorgunit", "cteffectdate", "ctinvaliddate"}, new String[]{"material", "element", "subelement", "unitstandardcost", "effectdate", "expdate"}).finish();
        return dataSet;
    }

    private DataSet getCostRecordDS() {
        QFilter filter = new QFilter("costaccount", "=", this.filter_CostAccount.getPkValue());
        filter.and("auditdate", ">=", (Object)this.filter_StartDate);
        filter.and("auditdate", "<", (Object)this.filter_EndDate);
        if (!this.filter_MaterailIds.isEmpty()) {
            filter.and("entry.material", "in", this.filter_MaterailIds);
        }
        filter.and("entry.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        if (!this.filter_billnos.isEmpty()) {
            filter.and("billno", "in", this.filter_billnos);
        }
        if (StringUtils.isNotEmpty((String)this.filter_bizEntityObject)) {
            filter.and("bizentityobject", "=", (Object)this.filter_bizEntityObject);
        }
        filter.and(new QFilter("issplitcreate", "=", (Object)false).or("bizentityobject", "=", (Object)"im_saloutbill"));
        DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,storageorgunit,bizentityobject,biztype, entry.id as entryid,entry.material as material,entry.baseqty as baseqty, entry.standardcost as standardcost, entry.actualcost as actualcost, auditdate", (QFilter[])filter.toArray(), null);
        return costRecordDS;
    }

    private void init(DynamicObject setting) {
        DynamicObject bizentityobject;
        this.filter_CostAccount = setting.getDynamicObject("costaccount");
        String billnos = setting.getString("billnos");
        if (!StringUtils.isEmpty((String)billnos)) {
            for (String billno : billnos.split("[\\s\\n\\r\\;]")) {
                if (StringUtils.isEmpty((String)billno)) continue;
                this.filter_billnos.add(billno);
            }
        }
        if ((bizentityobject = setting.getDynamicObject("bizentityobject")) != null) {
            this.filter_bizEntityObject = bizentityobject.getString("id");
        }
        DynamicObjectCollection materials = (DynamicObjectCollection)setting.get("materials");
        for (DynamicObject materail : materials) {
            this.filter_MaterailIds.add(materail.getDynamicObject("fbasedataid").getLong("id"));
        }
        this.filter_StartDate = setting.getDate("startdate");
        this.filter_EndDate = setting.getDate("enddate");
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency.amtprecision", (QFilter[])new QFilter("id", "=", this.filter_CostAccount.getPkValue()).toArray());
        this.amtPrecison = costAccount.getInt("calpolicy.currency.amtprecision");
    }
}

