/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountTypeDuplicateValidator
extends AbstractValidator {
    private String entity = "cal_bd_accounttype";

    public void validate() {
        this.doInnerValidate();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.doValidate(dataEntity);
        }
    }

    private void doInnerValidate() {
        if (this.dataEntities.length <= 1) {
            return;
        }
        HashSet<String> dupSet = new HashSet<String>();
        HashSet<String> set = new HashSet<String>(32);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
            DynamicObject calRange = info.getDynamicObject("calrange");
            for (DynamicObject entry : coll) {
                StringBuilder sBuilder = new StringBuilder(calRange.getPkValue().toString());
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                if (material == null && materialGroup == null) continue;
                if (material != null) {
                    sBuilder.append(material.getPkValue());
                } else {
                    sBuilder.append(materialGroup.getPkValue());
                }
                set.add(sBuilder.toString());
            }
            for (String key : set) {
                if (dupSet.contains(key)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u9009\u62e9\u7684\u5176\u4ed6\u6570\u636e\u5b58\u5728\u76f8\u540c\u201c\u6838\u7b97\u8303\u56f4+\u7269\u6599\u6216\u6838\u7b97\u8303\u56f4+\u7269\u6599\u201d\u5206\u7ec4\u7ef4\u5ea6\u3002", (String)"AccountTypeDuplicateValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    break;
                }
                dupSet.add(key);
            }
            set.clear();
        }
    }

    private void doValidate(ExtendedDataEntity dataEntity) {
        DynamicObject info = dataEntity.getDataEntity();
        DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
        DynamicObject calRange = info.getDynamicObject("calrange");
        int i = 0;
        for (DynamicObject entry : coll) {
            String msg;
            QFilter q = new QFilter("calrange", "=", calRange.getPkValue());
            q.and("id", "<>", info.getPkValue());
            q.and("enable", "=", (Object)"1");
            q.and("status", "in", (Object)new String[]{"B", "C"});
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
            if (material == null && materialGroup == null) continue;
            if (material != null) {
                q.and("entry.material", "=", material.getPkValue());
                if (QueryServiceHelper.exists((String)this.entity, (QFilter[])new QFilter[]{q})) {
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u201c\u6838\u7b97\u8303\u56f4+\u7269\u6599\u201d\u3002", (String)"AccountTypeDuplicateValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(dataEntity, msg);
                }
            } else {
                q.and("entry.materialgroup", "=", materialGroup.getPkValue());
                if (QueryServiceHelper.exists((String)this.entity, (QFilter[])new QFilter[]{q})) {
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u201c\u6838\u7b97\u8303\u56f4+\u7269\u6599\u5206\u7ec4\u201d\u3002", (String)"AccountTypeDuplicateValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(dataEntity, msg);
                }
            }
            ++i;
        }
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }
}

