/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class AcctPeriodValidator
extends AbstractValidator {
    private String acctField = "costaccount";
    private String periodField = "periodid";
    private String periodNumField = "period";

    public AcctPeriodValidator() {
    }

    public AcctPeriodValidator(String acctField, String periodField, String periodNumField) {
        this.acctField = acctField;
        this.periodField = periodField;
        this.periodNumField = periodNumField;
    }

    public void validate() {
        Boolean isCheckPeriod = CalDbParamServiceHelper.getBoolean((String)"fallprice_period_check");
        if (!isCheckPeriod.booleanValue()) {
            return;
        }
        HashSet<Long> acctIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billDyc = entity.getDataEntity();
            DynamicObject acctDyc = billDyc.getDynamicObject(this.acctField);
            DynamicObject billlPeriodDyc = billDyc.getDynamicObject(this.periodField);
            int billPeriodNum = billDyc.getInt(this.periodNumField);
            if (acctDyc == null || billlPeriodDyc == null || billPeriodNum == 0) continue;
            Long acctPk = (Long)acctDyc.getPkValue();
            acctIds.add(acctPk);
        }
        Map acctPeriodsMap = PeriodHelper.getCurrentPeriods(acctIds);
        for (ExtendedDataEntity entity : this.dataEntities) {
            boolean isBeforePeriod;
            DynamicObject curPeriodDyc;
            DynamicObject billDyc = entity.getDataEntity();
            DynamicObject acctDyc = billDyc.getDynamicObject(this.acctField);
            DynamicObject billlPeriodDyc = billDyc.getDynamicObject(this.periodField);
            int billPeriodNum = billDyc.getInt(this.periodNumField);
            if (acctDyc == null || billlPeriodDyc == null || billPeriodNum == 0 || (curPeriodDyc = (DynamicObject)acctPeriodsMap.get(acctDyc.getPkValue())) == null) continue;
            int currentPeriodNum = curPeriodDyc.getInt("periodyear") * 100 + curPeriodDyc.getInt("periodnumber");
            boolean bl = isBeforePeriod = billPeriodNum < currentPeriodNum;
            if (!isBeforePeriod) continue;
            String msgFmt = ResManager.loadKDString((String)"\u53ea\u80fd\u201c%1$s\u201d\u5f53\u671f\u53ca\u4ee5\u540e\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u201c%1$s\u201d\u5f80\u671f\u7684\u5355\u636e\u3002", (String)"AcctPeriodValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, String.format(msgFmt, this.getOperationName()));
        }
    }
}

