/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;

public class BalanceImportValidator
extends AbstractValidator {
    public void validate() {
        int entityLen = this.dataEntities.length;
        if (entityLen == 0) {
            return;
        }
        ArrayList<DynamicObject> dataEntityList = new ArrayList<DynamicObject>(entityLen);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject calInfo = entity.getDataEntity();
            Long materialId = calInfo.getDynamicObject("material").getLong("id");
            materialIds.add(materialId);
            dataEntityList.add(calInfo);
        }
        if (materialIds.isEmpty()) {
            return;
        }
        Map<Long, Integer> materialQtyPrecisionMap = this.getQtyPrecisionMap(materialIds);
        AccountTypeHelperNew helper = new AccountTypeHelperNew(dataEntityList.toArray(new DynamicObject[entityLen]), Boolean.TRUE);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject calInfo = dataEntity.getDataEntity();
            Object calRangeId = helper.getCalRangeId((Object)calInfo.getLong("costaccount.id"), calInfo, true);
            String accType = helper.getAccountType(calInfo, calRangeId);
            if (AccountTypeEnum.FIN_FOUT.getValue().equals(accType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5148\u8fdb\u5148\u51fa\u6cd5\u65f6\u4e0d\u53ef\u901a\u8fc7\u4f59\u989d\u521d\u59cb\u5316\u5f15\u5165\uff0c\u8bf7\u901a\u8fc7\u521d\u59cb\u6838\u7b97\u5355\u505a\u521d\u59cb\u6570\u636e\u3002", (String)"BalanceImportValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            Long materialId = calInfo.getDynamicObject("material").getLong("id");
            int unitPrecison = materialQtyPrecisionMap.get(materialId);
            int amtPrecison = calInfo.getDynamicObject("calpolicy").getInt("currency.amtprecision");
            BigDecimal periodbeginqty = (BigDecimal)calInfo.get("periodbeginqty");
            BigDecimal beginstandardcost = (BigDecimal)calInfo.get("beginstandardcost");
            BigDecimal periodbegincostdiff = (BigDecimal)calInfo.get("periodbegincostdiff");
            BigDecimal periodbeginactualcost = (BigDecimal)calInfo.get("periodbeginactualcost");
            BigDecimal afterperiodbeginqty = periodbeginqty.setScale(unitPrecison, RoundingMode.HALF_UP);
            BigDecimal afterbeginstandardcost = beginstandardcost.setScale(amtPrecison, RoundingMode.HALF_UP);
            BigDecimal afterperiodbegincostdiff = periodbegincostdiff.setScale(amtPrecison, RoundingMode.HALF_UP);
            BigDecimal afterperiodbeginactualcost = periodbeginactualcost.setScale(amtPrecison, RoundingMode.HALF_UP);
            if (periodbeginqty.compareTo(afterperiodbeginqty) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u6570\u91cf\u7684\u7cbe\u5ea6\u4e0d\u7b26\u5408\u7269\u6599\u57fa\u672c\u5355\u4f4d\u7684\u7cbe\u5ea6\u8981\u6c42\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BalanceImportValidator_10", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
            if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accType)) {
                this.checkStdField(dataEntity, calInfo, beginstandardcost, periodbegincostdiff);
            }
            if (beginstandardcost.compareTo(afterbeginstandardcost) == 0 && periodbegincostdiff.compareTo(afterperiodbegincostdiff) == 0 && periodbeginactualcost.compareTo(afterperiodbeginactualcost) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u91d1\u989d\u7684\u7cbe\u5ea6\u4e0d\u7b26\u5408\u672c\u4f4d\u5e01\u7684\u91d1\u989d\u7cbe\u5ea6\u8981\u6c42\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BalanceImportValidator_11", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkStdField(ExtendedDataEntity dataEntity, DynamicObject calInfo, BigDecimal beginstandardcost, BigDecimal periodbegincostdiff) {
        StringBuilder msg = new StringBuilder();
        BigDecimal yearinstandradcost = (BigDecimal)calInfo.get("yearinstandradcost");
        BigDecimal yearincostdiff = (BigDecimal)calInfo.get("yearincostdiff");
        BigDecimal yearissuestandradcost = (BigDecimal)calInfo.get("yearissuestandradcost");
        BigDecimal yearissuecostdiff = (BigDecimal)calInfo.get("yearissuecostdiff");
        String seperator = ResManager.loadKDString((String)"\u3001", (String)"BalanceImportValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        if (beginstandardcost.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u671f\u521d\u6807\u51c6\u6210\u672c", (String)"BalanceImportValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (periodbegincostdiff.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u671f\u521d\u6210\u672c\u5dee\u5f02", (String)"BalanceImportValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (yearinstandradcost.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6807\u51c6\u6210\u672c", (String)"BalanceImportValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (yearincostdiff.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6210\u672c\u5dee\u5f02", (String)"BalanceImportValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (yearissuestandradcost.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6807\u51c6\u6210\u672c", (String)"BalanceImportValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (yearissuecostdiff.compareTo(BigDecimal.ZERO) != 0) {
            msg.append(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6210\u672c\u5dee\u5f02", (String)"BalanceImportValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0])).append(seperator);
        }
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7269\u6599\u4e0d\u53ef\u5f55\u5165%1$s", (String)"BalanceImportValidator_8", (String)"fi-cal-opplugin", (Object[])new Object[0]), msg.substring(0, msg.length() - 1)));
        }
    }

    private Map<Long, Integer> getQtyPrecisionMap(Set<Long> materialIds) {
        QFilter materialFilter = new QFilter("id", "in", materialIds);
        HashMap<Long, Integer> materialQtyPrecisionMap = new HashMap<Long, Integer>(16);
        try (DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit.precision", (QFilter[])materialFilter.toArray(), null);){
            for (Row row : materialDataSet) {
                materialQtyPrecisionMap.put(row.getLong("id"), row.getInteger("baseunit.precision"));
            }
        }
        return materialQtyPrecisionMap;
    }
}

