/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.BalanceDistinctValidatorHelper;

public class BalanceInitValidator
extends AbstractValidator {
    private boolean isInit = true;

    public BalanceInitValidator(boolean isInit) {
        this.isInit = isInit;
    }

    public void validate() {
        HashMap<Long, Set> orgMap = new HashMap<Long, Set>();
        HashMap<Long, String> orgName = new HashMap<Long, String>();
        HashMap<Long, String> accountName = new HashMap<Long, String>();
        ExtendedDataEntity[] entrys = this.getDataEntities();
        for (int i = 0; i < entrys.length; ++i) {
            ExtendedDataEntity data = entrys[i];
            DynamicObject info = data.getDataEntity();
            Long orgID = info.getLong("org.id");
            DynamicObjectCollection entryInfos = info.getDynamicObjectCollection("entry");
            for (int k = 0; k < entryInfos.size(); ++k) {
                DynamicObject entryInfo = (DynamicObject)entryInfos.get(k);
                Set costAccountSet = this.getCostAccountSetByOrgID(orgID, orgMap);
                costAccountSet.add(entryInfo.get("costaccount.id"));
                orgMap.put(orgID, costAccountSet);
                orgName.put(orgID, info.getString("org.name"));
                accountName.put(entryInfo.getLong("costaccount.id"), entryInfo.getString("costaccount.name"));
            }
            if (this.isInit) {
                this.validatorInit(data, orgID, orgName, accountName, orgMap);
                BalanceDistinctValidatorHelper helper = new BalanceDistinctValidatorHelper(accountName.keySet());
                helper.mergeDuplicateDimensions();
                helper.distinctValidator();
                continue;
            }
            this.validatorUnInit(data, orgID, orgName, accountName, orgMap);
        }
    }

    private void validatorUnInit(ExtendedDataEntity data, Long orgID, Map<Long, String> orgName, Map<Long, String> accountName, Map<Long, Set> orgMap) {
        DynamicObject sysCtrlInfo = this.getSysCtrlInfo(orgID);
        if (sysCtrlInfo == null) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u6838\u7b97\u671f\u95f4\u4fe1\u606f\u3002", (String)"BalanceInitValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String content = String.format(msg, orgName.get(orgID));
            this.addFatalErrorMessage(data, content);
            return;
        }
        DynamicObjectCollection entrys = sysCtrlInfo.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject o = (DynamicObject)entrys.get(i);
            long costAccountID = o.getLong("costaccount.id");
            if (!o.getBoolean("isenabled")) {
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u7684\u6210\u672c\u8d26\u7c3f%2$s\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316\u3002", (String)"BalanceInitValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                String content = String.format(msg, orgName.get(orgID), accountName.get(costAccountID));
                this.addFatalErrorMessage(data, content);
                break;
            }
            DynamicObject startperiod = o.getDynamicObject("startperiod");
            DynamicObject currentperiod = o.getDynamicObject("currentperiod");
            if (currentperiod == null || startperiod.getString("number").equals(currentperiod.getString("number"))) continue;
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"BalanceInitValidator_8", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String content = String.format(msg, orgName.get(orgID), accountName.get(costAccountID));
            this.addFatalErrorMessage(data, content);
            break;
        }
    }

    private DynamicObject getSysCtrlInfo(Long orgID) {
        String fields = "id,number,name,entry,entry.costaccount,entry.isenabled,entry.startperiod,entry.currentperiod";
        DynamicObject retValue = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgID)});
        return retValue;
    }

    private void validatorInit(ExtendedDataEntity data, Long orgID, Map<Long, String> orgName, Map<Long, String> accountName, Map<Long, Set> orgMap) {
        DynamicObject sysCtrlInfo = this.getSysCtrlInfo(orgID);
        if (sysCtrlInfo == null) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u6838\u7b97\u671f\u95f4\u4fe1\u606f\u3002", (String)"BalanceInitValidator_9", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String content = String.format(msg, orgName.get(orgID));
            this.addFatalErrorMessage(data, content);
            return;
        }
        Set ids = orgMap.get(orgID);
        DynamicObjectCollection entrys = sysCtrlInfo.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject o = (DynamicObject)entrys.get(i);
            long costAccountID = o.getLong("costaccount.id");
            DynamicObject startperiod = o.getDynamicObject("startperiod");
            if (!ids.contains(costAccountID)) {
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f%2$s\u7684\u6838\u7b97\u671f\u95f4\u4fe1\u606f\u3002", (String)"BalanceInitValidator_10", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                String content = String.format(msg, orgName.get(orgID), accountName.get(costAccountID));
                this.addFatalErrorMessage(data, content);
                break;
            }
            if (o.getBoolean("isenabled")) {
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u7684\u6210\u672c\u8d26\u7c3f%2$s\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"BalanceInitValidator_11", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                String content = String.format(msg, orgName.get(orgID), accountName.get(costAccountID));
                this.addFatalErrorMessage(data, content);
                break;
            }
            if (startperiod != null) continue;
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u7684\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u672a\u7ef4\u62a4\u542f\u7528\u671f\u95f4\u4fe1\u606f\u3002", (String)"BalanceInitValidator_12", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String content = String.format(msg, orgName.get(orgID), accountName.get(costAccountID));
            this.addFatalErrorMessage(data, content);
            break;
        }
    }

    private Set getCostAccountSetByOrgID(Long orgID, Map<Long, Set> orgMap) {
        Set value = orgMap.get(orgID);
        if (value != null) {
            return value;
        }
        return new HashSet();
    }
}

