/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class BalanceSaveValidator
extends AbstractValidator {
    public void validate() {
        Object info;
        HashSet<Long> materialIdSet = new HashSet<Long>(512);
        HashSet<Long> storageorgIdSet = new HashSet<Long>(16);
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        HashSet<String> storageorgNumSet = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            info = dataEntity.getDataEntity();
            DynamicObject material = info.getDynamicObject("material");
            DynamicObject costAccount = info.getDynamicObject("costaccount");
            DynamicObject storageorgUnit = info.getDynamicObject("storageorgunit");
            if (material == null || costAccount == null || storageorgUnit == null) continue;
            costAccountIdSet.add(costAccount.getLong("id"));
            materialIdSet.add(material.getLong("id"));
            storageorgIdSet.add(storageorgUnit.getLong("id"));
            storageorgNumSet.add(storageorgUnit.getString("number"));
        }
        HashMap<String, DynamicObject> material2InvInf = new HashMap<String, DynamicObject>(materialIdSet.size());
        HashMap<String, DynamicObject> material2GlobalInvInf = new HashMap<String, DynamicObject>(materialIdSet.size());
        Iterator iterator = storageorgIdSet.iterator();
        while (iterator.hasNext()) {
            long storageId = (Long)iterator.next();
            DynamicObjectCollection materialInvInfs = MaterialHelper.getMaterialInvInfs(materialIdSet, (long)storageId);
            for (DynamicObject materialInv : materialInvInfs) {
                material2InvInf.put(materialInv.get("createorg") + "_" + materialInv.get("masterid"), materialInv);
                material2GlobalInvInf.put(storageId + "_" + materialInv.getLong("masterid"), materialInv);
            }
        }
        HashMap<Long, DynamicObject> costAcc2StartPeriod = new HashMap<Long, DynamicObject>(costAccountIdSet.size());
        HashMap<Long, Boolean> costAcc2EndInit = new HashMap<Long, Boolean>(costAccountIdSet.size());
        info = costAccountIdSet.iterator();
        while (info.hasNext()) {
            long costAccountId = (Long)info.next();
            costAcc2StartPeriod.put(costAccountId, PeriodHelper.getStartPeriod((Long)costAccountId));
            costAcc2EndInit.put(costAccountId, PeriodHelper.isEndInit((Long)costAccountId));
        }
        HashMap<String, Long[]> storageWarehs = new HashMap<String, Long[]>(16);
        for (String storageorgNum : storageorgNumSet) {
            storageWarehs.put(storageorgNum, SCMHelper.getAllInUseWarehouseIDs((String)storageorgNum));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String storageOrgNum;
            Long[] warehsInfos;
            boolean hasWarehs;
            long costAccountCalOrg;
            DynamicObject info2 = dataEntity.getDataEntity();
            String errorMsg = this.checkRecordQty(info2);
            if (errorMsg != null) {
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            DynamicObject material = info2.getDynamicObject("material");
            DynamicObject costAccount = info2.getDynamicObject("costaccount");
            DynamicObject storageorgUnit = info2.getDynamicObject("storageorgunit");
            if (material == null || costAccount == null || storageorgUnit == null) continue;
            long accountID = costAccount.getLong("id");
            String accountName = costAccount.getString("name");
            if (costAcc2StartPeriod.get(accountID) == null) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"BalanceSaveValidator_20", (String)"fi-cal-opplugin", (Object[])new Object[0]), accountName);
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            boolean isEndInit = (Boolean)costAcc2EndInit.get(accountID);
            if (isEndInit) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BalanceSaveValidator_19", (String)"fi-cal-opplugin", (Object[])new Object[0]), accountName);
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            long calOrgID = info2.getLong("calorg.id");
            if (calOrgID != (costAccountCalOrg = info2.getDynamicObject("costaccount.calorg").getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5fc5\u987b\u4e0e\u6210\u672c\u8d26\u7c3f\u91cc\u914d\u7f6e\u7684\u6838\u7b97\u7ec4\u7ec7\u4e00\u81f4\u3002", (String)"BalanceSaveValidator_17", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            String warehsNumber = info2.getString("warehouse.number");
            String storageOrgNumber = storageorgUnit.getString("number");
            long storageOrgId = storageorgUnit.getLong("id");
            String lot = info2.getString("lot");
            DynamicObject assist = info2.getDynamicObject("assist");
            String invKey = storageOrgId + "_" + material.getLong("id");
            DynamicObject materialInvInf = (DynamicObject)material2InvInf.get(invKey);
            if (materialInvInf == null) {
                materialInvInf = (DynamicObject)material2GlobalInvInf.get(invKey);
            }
            if (materialInvInf == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7269\u6599\u5e93\u5b58\u7b56\u7565\uff0c\u6216\u8005\u5df2\u8bbe\u7f6e\u4f46\u672a\u542f\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"BalanceSaveValidator_18", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean enablelot = materialInvInf.getBoolean("enablelot");
            if ((lot == null || " ".equals(lot) || StringUtils.isEmpty((String)lot)) && enablelot) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u7b56\u7565\u542f\u7528\u4e86\u6279\u53f7\u7ba1\u7406\uff0c\u4f46\u662f\u6ca1\u6709\u5f55\u5165\u6279\u53f7\u3002", (String)"BalanceSaveValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isNotEmpty((String)lot) && !enablelot) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u7b56\u7565\u6ca1\u6709\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u4f46\u662f\u5f55\u5165\u4e86\u6279\u53f7\u3002", (String)"BalanceSaveValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (this.isUseauxpty(material) && assist == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u542f\u7528\u4e86\u8f85\u52a9\u7ba1\u7406\uff0c\u4f46\u662f\u6ca1\u6709\u5f55\u5165\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"BalanceSaveValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
            if (!(hasWarehs = OrgHelper.checkWarehs((Long[])(warehsInfos = (Long[])storageWarehs.get(storageOrgNum = storageorgUnit.getString("number"))), (long)info2.getLong("warehouse.id")))) {
                String msg = String.format(ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5c5e\u4e8e\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u3002", (String)"BalanceSaveValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), storageOrgNumber, warehsNumber);
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            this.checkLocation(dataEntity, info2);
        }
    }

    private void checkLocation(ExtendedDataEntity dataEntity, DynamicObject info) {
        long warehsID = info.getLong("warehouse.id");
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id,isopenlocation", (QFilter[])new QFilter("id", "=", (Object)warehsID).toArray());
        boolean isopenlocation = warehouse.getBoolean("isopenlocation");
        long locationId = info.getLong("location.id");
        if (isopenlocation) {
            if (locationId == 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406,\u4f46\u662f\u6ca1\u6709\u5f55\u5165\u4ed3\u4f4d\u503c\u3002", (String)"BalanceSaveValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            } else {
                Long[] locations;
                boolean isValid = false;
                Long[] longArray = locations = SCMHelper.getAllLocationIDs((Object[])new Object[]{warehsID});
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long location = longArray[i];
                    if (location != locationId) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406,\u4f46\u662f\u5f55\u5165\u7684\u4ed3\u4f4d\u503c\u5e76\u4e0d\u5c5e\u4e8e\u8be5\u4ed3\u5e93\u7ba1\u7406\u7684\u4ed3\u4f4d\u3002", (String)"BalanceSaveValidator_8", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (!isopenlocation && locationId != 0L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u4ed3\u5e93\u6ca1\u6709\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406,\u4f46\u662f\u4ed3\u4f4d\u5374\u5f55\u5165\u4e86\u503c\u3002", (String)"BalanceSaveValidator_9", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isUseauxpty(DynamicObject material) {
        return material.getBoolean("isuseauxpty");
    }

    private String checkRecordQty(DynamicObject balanceInfo) {
        int costSignum;
        int qtySignum;
        BigDecimal perQty = balanceInfo.getBigDecimal("periodbeginqty");
        BigDecimal perActualCost = balanceInfo.getBigDecimal("periodbeginactualcost");
        BigDecimal yearInQty = balanceInfo.getBigDecimal("yearinqty");
        BigDecimal yearInCostDiff = balanceInfo.getBigDecimal("yearincostdiff");
        BigDecimal yearInActualCost = balanceInfo.getBigDecimal("yearinactualcost");
        BigDecimal yearIssueQty = balanceInfo.getBigDecimal("yearissueqty");
        BigDecimal yearIssueActualCost = balanceInfo.getBigDecimal("yearissueactualcost");
        if (perQty.compareTo(BigDecimal.ZERO) == 0 && perActualCost.compareTo(BigDecimal.ZERO) == 0 && yearInQty.compareTo(BigDecimal.ZERO) == 0 && yearInActualCost.compareTo(BigDecimal.ZERO) == 0 && yearIssueQty.compareTo(BigDecimal.ZERO) == 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) == 0) {
            return ResManager.loadKDString((String)"\u540c\u4e00\u5206\u5f55\u884c\u4e0d\u5141\u8bb8\u671f\u521d\u6570\u91cf\u3001\u671f\u521d\u5b9e\u9645\u6210\u672c\u3001\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u57fa\u672c\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u5b9e\u9645\u6210\u672c\u3001\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u57fa\u672c\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u5b9e\u9645\u6210\u672c\u4e0d\u80fd\u540c\u65f6\u4e3a0\u3002", (String)"BalanceSaveValidator_10", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        }
        if (perQty.compareTo(BigDecimal.ZERO) != 0 && perActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = perQty.signum()) != (costSignum = perActualCost.signum())) {
            return ResManager.loadKDString((String)"\u671f\u521d\u6570\u91cf\u4e0e\u671f\u521d\u5b9e\u9645\u6210\u672c\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"BalanceSaveValidator_14", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        }
        if (yearInQty.compareTo(BigDecimal.ZERO) != 0 && yearInActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearInQty.signum()) != (costSignum = yearInActualCost.signum())) {
            return ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u5b9e\u9645\u6210\u672c\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"BalanceSaveValidator_15", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        }
        if (yearIssueQty.compareTo(BigDecimal.ZERO) != 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearIssueQty.signum()) != (costSignum = yearIssueActualCost.signum())) {
            return ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u5b9e\u9645\u6210\u672c\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"BalanceSaveValidator_16", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

