/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;

public class BaseDataModifyValidator
extends AbstractValidator {
    private BasedataEntityType entityType;
    private OperateOption option;

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public void setEntityType(BasedataEntityType entityType) {
        this.entityType = entityType;
    }

    public void validate() {
        HashMap<Object, ExtendedDataEntity> objMap = new HashMap<Object, ExtendedDataEntity>(20);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            Object idValue = dataObj.getBillPkId();
            objMap.put(idValue, dataObj);
        }
        if (objMap.isEmpty()) {
            return;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        Set ignoreRefEntityIds = checker.getIgnoreRefEntityIds();
        ignoreRefEntityIds.add("cal_periodsettinglog");
        this.addIgnoreRefEntityIds(checker);
        Map checkResult = checker.checkRef(this.entityType, objMap.keySet().toArray());
        for (Map.Entry entry : checkResult.entrySet()) {
            ExtendedDataEntity dataObj = (ExtendedDataEntity)objMap.get(entry.getKey());
            if (dataObj == null) continue;
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
            if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            String tableName = refrenceResult.getRefenceKey().getRefTable();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (property instanceof IFieldHandle && StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                    fieldName = ((IFieldHandle)property).getDisplayName().toString();
                    break;
                }
                if (!this.equalsMulBasedataFieldName(property, tableName, fieldName)) continue;
                fieldName = property.getDisplayName().toString();
                break;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u4fee\u6539\uff1a\u3010%1$s\u3011\u7684\u5b57\u6bb5\u3010%2$s\u3011\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e", (String)"BaseDataModifyValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), billName, fieldName);
            this.addErrorMessage(dataObj, msg);
        }
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.option.tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        if (this.option.tryGetVariableValue("checkrefentityids", opValue = new RefObject()) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }

    private boolean equalsMulBasedataFieldName(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() == null || mulBasedataProp.getItemType().getAlias() == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
    }
}

