/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BillGroupSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] infos = this.getDataEntities();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityKey());
        int costFieldsLength = ((TextProp)entityType.getProperties().get((Object)"costfields")).getMaxLenth();
        int curIdLength = String.valueOf(DB.genGlobalLongId()).length();
        int maxCostFieldsSize = costFieldsLength / curIdLength;
        String subElementMaxSize = ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u9009\u62e9%1$s\u4e2a\u5b50\u8981\u7d20\uff0c\u5982\u9700\u9009\u62e9\u66f4\u591a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u5b57\u7b26\u957f\u5ea6\u3002", (String)"BillGroupSaveValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        String subElementMaxSizeMsg = String.format(subElementMaxSize, maxCostFieldsSize);
        for (ExtendedDataEntity entity : infos) {
            Object msg;
            boolean isBillEntryProp = false;
            boolean isRBillEntryProp = false;
            DynamicObject setting = entity.getDataEntity();
            Object bizplugin = setting.get("bizplugin");
            DynamicObject bill = setting.getDynamicObject("bill");
            DynamicObject relateionBill = setting.getDynamicObject("relationbill");
            DynamicObjectCollection entrys = setting.getDynamicObjectCollection("entryentity");
            int subCalElementSize = setting.getDynamicObjectCollection("subcalelement").size();
            if (subCalElementSize > maxCostFieldsSize) {
                this.addErrorMessage(entity, subElementMaxSizeMsg);
                continue;
            }
            if (entrys.size() == 0 && bizplugin == null) {
                msg = ResManager.loadKDString((String)"\u5904\u7406\u63d2\u4ef6\u548c\u5355\u636e\u6210\u7ec4\u5173\u7cfb\u5206\u5f55\uff08\u5173\u8054\u5173\u7cfb\uff09\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"BillGroupSaveValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(entity, (String)msg);
                continue;
            }
            if (entrys.size() > 0) {
                for (DynamicObject entry : entrys) {
                    String field = entry.get("billfield").toString();
                    String rbillfield = entry.get("rbillfield").toString();
                    if (field != null && !isBillEntryProp && bill != null) {
                        isBillEntryProp = this.isEntryProp(bill.getString("number"), field);
                    }
                    if (rbillfield == null || isRBillEntryProp || relateionBill == null) continue;
                    isRBillEntryProp = this.isEntryProp(relateionBill.getString("number"), field);
                }
                if (!isBillEntryProp || !isRBillEntryProp) {
                    msg = ResManager.loadKDString((String)"\u5355\u636e\u6210\u7ec4\u5173\u7cfb\u5206\u5f55\uff08\u5173\u8054\u5173\u7cfb\uff09\u5fc5\u987b\u6307\u5b9a\u5230\u5206\u5f55\u5c5e\u6027\u3002", (String)"BillGroupSaveValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(entity, (String)msg);
                }
            }
            int priority = setting.getInt("priority");
            String enable = setting.getString("enable");
            Long settingId = setting.getLong("id");
            QFilter q = new QFilter("priority", "=", (Object)priority);
            q.and("enable", "=", (Object)Character.valueOf('1'));
            q.and("id", "!=", (Object)settingId);
            if (!"1".equals(enable) || !QueryServiceHelper.exists((String)"cal_billgroupsetting", (QFilter[])q.toArray())) continue;
            String msg2 = ResManager.loadKDString((String)"\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\u7684\u4f18\u5148\u7ea7\u91cd\u590d\u3002\u8bf7\u5148\u7981\u7528\u76f8\u540c\u4f18\u5148\u7ea7\u7684\u6210\u7ec4\u5173\u7cfb\u5b9a\u4e49\uff0c\u6216\u8005\u4fee\u6539\u4f18\u5148\u7ea7\u3002", (String)"BillGroupSaveValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(entity, msg2);
        }
    }

    private boolean isEntryProp(String billType, String filed) {
        String entryName = this.getEntryEntityName(billType, filed);
        return entryName != null;
    }

    private String getEntryEntityName(String typeNumber, String propName) {
        MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)typeNumber);
        IDataEntityProperty dataEntity = billDataEntity.findProperty(propName.split("\\.")[0]);
        if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
            return dataEntity.getParent().getName();
        }
        return null;
    }
}

