/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CostAdjustBillOpHelper;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.MustInputDimHelper;
import kd.fi.cal.common.model.CalSpDimension;
import kd.fi.cal.common.util.CommonUtils;

public class CalBillMustInputValidator
extends AbstractValidator {
    private Map<String, IDataEntityProperty> billProperties;
    private Map<Long, Set<String>> orgAndDiffDimsMap = new HashMap<Long, Set<String>>(16);
    private Map<Long, Set<String>> accountDivideDimsMap = new HashMap<Long, Set<String>>(16);
    private Map<String, Boolean> privateEnableLotMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> publiceEnableLotMap = new HashMap<String, Boolean>(16);
    private Set<Long> noPassValBills = new HashSet<Long>(16);
    private Map<String, Long> unionKeyAndStorageInvId = null;
    private Map<Object, String> storageInvIdAndNoUpdateStr = null;

    public void validate() {
        this.initDimFileds();
        this.initEnableLotMap();
        this.doValDivideOrDiffDim();
        if (!"cal_stdcostdiffbill".equals(this.getEntityKey())) {
            HashMap<Long, ExtendedDataEntity> passDataEntityMap = new HashMap<Long, ExtendedDataEntity>(16);
            HashSet<DynamicObject> passBillDyms = new HashSet<DynamicObject>(16);
            for (ExtendedDataEntity billInfo : this.dataEntities) {
                DynamicObject billDym = billInfo.getDataEntity();
                if (this.noPassValBills.contains(billDym.getLong("id"))) continue;
                passBillDyms.add(billDym);
                passDataEntityMap.put(billDym.getLong("id"), billInfo);
            }
            if (passBillDyms.size() > 0) {
                DynamicObject[] passBillDymArr = passBillDyms.toArray(new DynamicObject[0]);
                if ("cal_costadjust_subentity".equals(this.getEntityKey())) {
                    CostAdjustBillOpHelper helper = new CostAdjustBillOpHelper(passBillDymArr);
                    helper.handleBillCalRange(passBillDymArr);
                }
                this.doValDimensionDim(passBillDymArr, passDataEntityMap);
            }
        }
    }

    private void doValDimensionDim(DynamicObject[] passBillDymArr, Map<Long, ExtendedDataEntity> passDataEntityMap) {
        HashSet<Long> accountIdSet = new HashSet<Long>(16);
        HashSet<Long> calrangeIdSet = new HashSet<Long>(16);
        for (DynamicObject billDym : passBillDymArr) {
            Long accountId = billDym.getLong("costaccount.id");
            accountIdSet.add(accountId);
            for (DynamicObject entry : billDym.getDynamicObjectCollection("entryentity")) {
                Object calrangObj = entry.get("calrange");
                if (calrangObj == null) continue;
                if (calrangObj instanceof DynamicObject) {
                    calrangeIdSet.add(((DynamicObject)calrangObj).getLong("id"));
                    continue;
                }
                calrangeIdSet.add((Long)calrangObj);
            }
        }
        HashMap<Long, CalSpDimension> calSpDimensionMap = new HashMap<Long, CalSpDimension>(16);
        for (Long costAccountId : accountIdSet) {
            calSpDimensionMap.put(costAccountId, new CalSpDimension(costAccountId));
        }
        Map calrangeDimsMap = MustInputDimHelper.getCalrangeDimensions(calrangeIdSet);
        block13: for (DynamicObject billDym : passBillDymArr) {
            ExtendedDataEntity billInfo = passDataEntityMap.get(billDym.getLong("id"));
            CalSpDimension calSpDimension = (CalSpDimension)calSpDimensionMap.get(billDym.getLong("costAccount.id"));
            for (DynamicObject entry : billDym.getDynamicObjectCollection("entryentity")) {
                String spCaldimension;
                if ("cal_initbill".equals(this.getEntityKey()) && AccountTypeEnum.STANDARDCOST.getValue().equals(entry.get("accounttype"))) continue;
                int seq = entry.getInt("seq");
                Long calrangeId = null;
                Object calrangObj = entry.get("calrange");
                if (calrangObj != null) {
                    calrangeId = calrangObj instanceof DynamicObject ? Long.valueOf(((DynamicObject)calrangObj).getLong("id")) : (Long)calrangObj;
                }
                if (calrangeId == null || Long.compare(calrangeId, 0L) == 0) {
                    this.addErrorMessage(billInfo, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c:\u672a\u627e\u5230\u6838\u7b97\u8303\u56f4", (String)"CalBillMustInputValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq));
                    continue block13;
                }
                Long matId = entry.getLong("material.id");
                DynamicObject groupDym = entry.getDynamicObject("material").getDynamicObject("group");
                String matGroupNumber = null;
                if (groupDym != null) {
                    matGroupNumber = groupDym.getString("longnumber");
                }
                if (StringUtils.isEmpty((String)(spCaldimension = calSpDimension.getSpCaldimension(calrangeId.toString(), matId.toString(), matGroupNumber)))) {
                    spCaldimension = (String)calrangeDimsMap.get(calrangeId);
                    if (spCaldimension == null) {
                        continue;
                    }
                } else {
                    spCaldimension = spCaldimension.split("@")[1];
                }
                String[] stringArray = CommonUtils.trimComma((String)spCaldimension).split(",");
                int n = stringArray.length;
                block15: for (int i = 0; i < n; ++i) {
                    String dim;
                    switch (dim = stringArray[i]) {
                        case "lot": {
                            StringBuilder sBuilder = new StringBuilder(32);
                            sBuilder.append(entry.getDynamicObject("storageorgunit").getLong("id"));
                            sBuilder.append('_');
                            sBuilder.append(entry.getDynamicObject("material").getLong("id"));
                            Boolean enableLot = this.privateEnableLotMap.get(sBuilder.toString());
                            if (enableLot == null) {
                                enableLot = this.publiceEnableLotMap.get(sBuilder.toString());
                            }
                            if (enableLot == null) {
                                enableLot = false;
                            }
                            this.addErrorMsg(seq, billInfo, entry, dim, enableLot);
                            continue block15;
                        }
                        case "assist": {
                            boolean isuseauxpty = entry.getDynamicObject("material").getBoolean("isuseauxpty");
                            this.addErrorMsg(seq, billInfo, entry, dim, isuseauxpty);
                            continue block15;
                        }
                        case "configuredcode": {
                            String configProperStr;
                            if (this.storageInvIdAndNoUpdateStr == null) {
                                MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
                                this.unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(passBillDymArr);
                                this.storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(this.unionKeyAndStorageInvId, this.getEntityKey(), "entryentity");
                            }
                            long materialId = entry.getDynamicObject("material").getLong("id");
                            long storageOrgId = entry.getDynamicObject("storageorgunit").getLong("id");
                            String curUnionKey = storageOrgId + "#" + materialId;
                            Long storageInvId = this.unionKeyAndStorageInvId.get(curUnionKey);
                            String noUpdateStr = this.storageInvIdAndNoUpdateStr.get(storageInvId);
                            boolean isUpdateConfig = true;
                            if (!StringUtils.isEmpty((String)noUpdateStr)) {
                                isUpdateConfig = !noUpdateStr.contains("configuredcode");
                            }
                            boolean isConfig = "2".equals(configProperStr = entry.getDynamicObject("material").getString("configproperties")) || "3".equals(configProperStr);
                            this.addErrorMsg(seq, billInfo, entry, dim, isConfig && isUpdateConfig);
                            continue block15;
                        }
                    }
                }
            }
        }
    }

    private void doValDivideOrDiffDim() {
        this.billProperties = MetadataServiceHelper.getDataEntityType((String)this.getEntityKey()).getAllFields();
        Set<String> mustInputDims = null;
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject billDym = billInfo.getDataEntity();
            Long billId = billDym.getLong("id");
            if (!"cal_initbill".equals(this.getEntityKey()) && !billDym.getBoolean("isupdatecost")) {
                this.noPassValBills.add(billId);
                continue;
            }
            mustInputDims = "cal_stdcostdiffbill".equals(this.getEntityKey()) ? this.orgAndDiffDimsMap.get(billDym.getLong("calorg.id")) : this.accountDivideDimsMap.get(billDym.getLong("costaccount.id"));
            if (mustInputDims == null || mustInputDims.isEmpty()) {
                this.noPassValBills.add(billId);
                continue;
            }
            for (DynamicObject entry : billDym.getDynamicObjectCollection("entryentity")) {
                int seq = entry.getInt("seq");
                if ("cal_initbill".equals(this.getEntityKey())) {
                    if (AccountTypeEnum.STANDARDCOST.getValue().equals(entry.get("accounttype"))) {
                        mustInputDims = this.orgAndDiffDimsMap.get(billDym.getLong("calorg.id"));
                        if (mustInputDims == null) {
                            continue;
                        }
                    } else {
                        mustInputDims = this.accountDivideDimsMap.get(billDym.getLong("costaccount.id"));
                    }
                }
                Iterator<String> iterator = mustInputDims.iterator();
                while (iterator.hasNext()) {
                    String dim;
                    switch (dim = iterator.next()) {
                        case "warehouse": {
                            this.addErrorMsg(seq, billInfo, entry, dim, true);
                            break;
                        }
                        case "location": {
                            DynamicObject warehouse = entry.getDynamicObject("warehouse");
                            if (warehouse == null) break;
                            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                            this.addErrorMsg(seq, billInfo, entry, dim, isopenlocation);
                            break;
                        }
                        case "lot": {
                            StringBuilder sBuilder = new StringBuilder(32);
                            sBuilder.append(entry.getDynamicObject("storageorgunit").getLong("id"));
                            sBuilder.append('_');
                            sBuilder.append(entry.getDynamicObject("material").getLong("id"));
                            Boolean enableLot = this.privateEnableLotMap.get(sBuilder.toString());
                            if (enableLot == null) {
                                enableLot = this.publiceEnableLotMap.get(sBuilder.toString());
                            }
                            if (enableLot == null) {
                                enableLot = false;
                            }
                            this.addErrorMsg(seq, billInfo, entry, dim, enableLot);
                            break;
                        }
                        case "assist": {
                            boolean isuseauxpty = entry.getDynamicObject("material").getBoolean("isuseauxpty");
                            this.addErrorMsg(seq, billInfo, entry, dim, isuseauxpty);
                            break;
                        }
                        case "configuredcode": {
                            String configProperStr;
                            if (this.storageInvIdAndNoUpdateStr == null) {
                                HashSet<DynamicObject> bills = new HashSet<DynamicObject>(16);
                                for (ExtendedDataEntity billEntity : this.dataEntities) {
                                    bills.add(billEntity.getDataEntity());
                                }
                                MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
                                this.unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(bills.toArray(new DynamicObject[0]));
                                this.storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(this.unionKeyAndStorageInvId, this.getEntityKey(), "entryentity");
                            }
                            long materialId = entry.getDynamicObject("material").getLong("id");
                            long storageOrgId = entry.getDynamicObject("storageorgunit").getLong("id");
                            String curUnionKey = storageOrgId + "#" + materialId;
                            Long storageInvId = this.unionKeyAndStorageInvId.get(curUnionKey);
                            String noUpdateStr = this.storageInvIdAndNoUpdateStr.get(storageInvId);
                            boolean isUpdateConfig = true;
                            if (!StringUtils.isEmpty((String)noUpdateStr)) {
                                isUpdateConfig = !noUpdateStr.contains("configuredcode");
                            }
                            boolean isConfig = "2".equals(configProperStr = entry.getDynamicObject("material").getString("configproperties")) || "3".equals(configProperStr);
                            this.addErrorMsg(seq, billInfo, entry, dim, isConfig && isUpdateConfig);
                            break;
                        }
                    }
                }
            }
        }
    }

    private void addErrorMsg(int seq, ExtendedDataEntity billInfo, DynamicObject entry, String dim, boolean otherJudge) {
        boolean isNullValue;
        Object dimValue = entry.get(dim);
        boolean bl = isNullValue = dimValue == null;
        if (!isNullValue && this.billProperties.get(dim) instanceof TextProp) {
            isNullValue = StringUtils.isEmpty((String)((String)dimValue));
        }
        if (isNullValue && otherJudge) {
            this.noPassValBills.add((Long)billInfo.getBillPkId());
            String format = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c:\u8bf7\u6309\u8981\u6c42\u586b\u5199%2$s", (String)"CalBillMustInputValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(billInfo, String.format(format, seq, this.billProperties.get(dim).getDisplayName().getLocaleValue()));
        }
    }

    private void initEnableLotMap() {
        HashMap<Long, HashSet<Long>> storgMaterialsMap = new HashMap<Long, HashSet<Long>>(16);
        for (ExtendedDataEntity billInfo : this.getDataEntities()) {
            DynamicObject bill = billInfo.getDataEntity();
            for (DynamicObject dynamicObject : bill.getDynamicObjectCollection("entryentity")) {
                Long storageorgunitId = dynamicObject.getLong("storageorgunit.id");
                Long materialId = dynamicObject.getLong("material.id");
                HashSet<Long> materials = (HashSet<Long>)storgMaterialsMap.get(storageorgunitId);
                if (materials == null) {
                    materials = new HashSet<Long>(16);
                    storgMaterialsMap.put(storageorgunitId, materials);
                }
                materials.add(materialId);
            }
        }
        for (Map.Entry entry : storgMaterialsMap.entrySet()) {
            Long stoId = (Long)entry.getKey();
            Set matIds = (Set)entry.getValue();
            QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)qFilter, (String)"id,masterid,createorg,enablelot");
            for (DynamicObject dynamicObject : stockMaterialInfos) {
                Object createOrg;
                Object material = dynamicObject.get("masterid");
                if (material instanceof DynamicObject) {
                    material = ((DynamicObject)material).get("id");
                }
                if ((createOrg = dynamicObject.get("createorg")) instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrg).get("id");
                }
                String key = stoId + "_" + material;
                boolean enableLot = dynamicObject.getBoolean("enablelot");
                if (stoId.equals(createOrg)) {
                    this.privateEnableLotMap.put(key, enableLot);
                    continue;
                }
                this.publiceEnableLotMap.put(key, enableLot);
            }
        }
    }

    private void initDimFileds() {
        DynamicObject billDym;
        if ("cal_stdcostdiffbill".equals(this.getEntityKey()) || "cal_initbill".equals(this.getEntityKey())) {
            HashSet<Long> orgIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity billInfo : this.dataEntities) {
                billDym = billInfo.getDataEntity();
                Long orgId = billDym.getLong("calorg.id");
                orgIdSet.add(orgId);
            }
            this.orgAndDiffDimsMap = MustInputDimHelper.getOrgAndDiffDims(orgIdSet);
        }
        if ("cal_costadjust_subentity".equals(this.getEntityKey()) || "cal_initbill".equals(this.getEntityKey())) {
            HashSet<Long> accountIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity billInfo : this.dataEntities) {
                billDym = billInfo.getDataEntity();
                Long accountId = billDym.getLong("costaccount.id");
                accountIdSet.add(accountId);
            }
            this.accountDivideDimsMap = MustInputDimHelper.getAccountDivideDims(accountIdSet);
        }
    }
}

