/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.CalDiffGroupBillHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalDiffBill4VoucherValidator
extends AbstractValidator {
    public void validate() {
        CalDiffGroupBillHelper diffHelper = new CalDiffGroupBillHelper();
        if (!diffHelper.getIsgroupdiff()) {
            return;
        }
        ExtendedDataEntity[] billInfos = this.getDataEntities();
        HashMap<Long, HashSet<Long>> diffBillGroupBillMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> allGroupBillIds = new HashSet<Long>(16);
        for (ExtendedDataEntity billInfo : billInfos) {
            Long diffBillId = billInfo.getDataEntity().getLong("id");
            DynamicObjectCollection entrys = billInfo.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long groupDiffBillId = entry.getLong("groupdiffbillid");
                if (groupDiffBillId == null || Long.compare(groupDiffBillId, 0L) == 0) continue;
                HashSet<Long> groupBillIds = (HashSet<Long>)diffBillGroupBillMap.get(diffBillId);
                if (groupBillIds == null) {
                    groupBillIds = new HashSet<Long>(16);
                }
                groupBillIds.add(groupDiffBillId);
                diffBillGroupBillMap.put(diffBillId, groupBillIds);
                allGroupBillIds.add(groupDiffBillId);
            }
        }
        if (allGroupBillIds.isEmpty()) {
            return;
        }
        DataSet diffBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)"id,billno,entryentity.groupdiffbillid as groupdiffbillid", (QFilter[])new QFilter("entryentity.groupdiffbillid", "in", allGroupBillIds).toArray(), null);
        diffBillDS = diffBillDS.groupBy(new String[]{"id", "groupdiffbillid", "billno"}).finish();
        HashMap<Long, HashSet<Long>> groupBillAndAlldiffBillMap = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, String> diffBillNoMap = new HashMap<Long, String>(16);
        for (Row row : diffBillDS) {
            HashSet<Long> diffBills = (HashSet<Long>)groupBillAndAlldiffBillMap.get(row.getLong("groupdiffbillid"));
            if (diffBills == null) {
                diffBills = new HashSet<Long>(16);
            }
            diffBills.add(row.getLong("id"));
            groupBillAndAlldiffBillMap.put(row.getLong("groupdiffbillid"), diffBills);
            diffBillNoMap.put(row.getLong("id"), row.getString("billno"));
        }
        Set hasVoucherDiffBillIds = CalDiffGroupBillHelper.getHasVoucherDiffBill(allGroupBillIds, diffBillGroupBillMap);
        for (ExtendedDataEntity billInfo : billInfos) {
            Long diffBillId = billInfo.getDataEntity().getLong("id");
            if (hasVoucherDiffBillIds.contains(diffBillId)) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u4e0b\u5df2\u6709\u751f\u6210\u51ed\u8bc1\u7684\u5408\u5e76\u5355\u3002", (String)"CalDiffBill4VoucherValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entrys = billInfo.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long groupDiffBillId = entry.getLong("groupdiffbillid");
                if (groupDiffBillId == null || Long.compare(groupDiffBillId, 0L) == 0) continue;
                Set diffBills = (Set)groupBillAndAlldiffBillMap.get(groupDiffBillId);
                StringBuilder billNoBuilder = null;
                for (Long billId : diffBills) {
                    if (diffBillGroupBillMap.containsKey(billId)) continue;
                    if (billNoBuilder == null) {
                        billNoBuilder = new StringBuilder();
                    }
                    billNoBuilder.append((String)diffBillNoMap.get(billId));
                    billNoBuilder.append(',');
                }
                if (billNoBuilder == null) continue;
                this.addErrorMessage(billInfo, String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5408\u5e76\u5355\u4e0b\u7684\u5dee\u5f02\u5355\u5fc5\u987b\u540c\u65f6\u53cd\u5ba1\u6838\uff0c\u5b58\u5728\u672a\u52fe\u9009\u7684\u5355\u636e\uff1a%1$s", (String)"CalDiffBill4VoucherValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), CommonUtils.trimComma((String)billNoBuilder.toString())));
            }
        }
    }
}

