/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CalRangeDuplicateValidator
extends AbstractValidator {
    public void validate() {
        Set<ExtendedDataEntity> errDataEntities = this.doInnerValidate();
        HashSet<Long> curCalrangeIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            curCalrangeIds.add(info.getLong("id"));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (errDataEntities != null && errDataEntities.contains(dataEntity)) continue;
            this.doValidate(dataEntity, curCalrangeIds);
        }
    }

    private Set<ExtendedDataEntity> doInnerValidate() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)"cal_bd_calrange");
        HashSet<ExtendedDataEntity> entitySet = new HashSet<ExtendedDataEntity>();
        HashSet dupSet = new HashSet();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (entitySet.contains(dataEntity)) continue;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject costAccount = info.getDynamicObject("costaccount");
            DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
            Map fieldsMap = bizEntityType.getAllFields();
            Set keySet = fieldsMap.keySet();
            String[] keys = keySet.toArray(new String[0]);
            if (coll.size() > 0) {
                HashSet<String> valueSet = new HashSet<String>();
                for (DynamicObject entry : coll) {
                    StringBuilder sBuilder = new StringBuilder(costAccount.getPkValue().toString());
                    for (String key : keys) {
                        if (!(((IDataEntityProperty)fieldsMap.get(key)).getParent() instanceof EntryType)) continue;
                        Object value = entry.get(key);
                        sBuilder.append(this.getCompareValue(key, value, fieldsMap));
                    }
                    String valueStr = sBuilder.toString();
                    if (valueSet.contains(valueStr)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u8303\u56f4\u5b58\u5728\u76f8\u540c\u7684\u5206\u5f55\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalRangeDuplicateValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        entitySet.add(dataEntity);
                        valueSet.clear();
                        break;
                    }
                    if (dupSet.contains(valueStr)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u9009\u62e9\u7684\u5176\u4ed6\u6570\u636e\u5b58\u5728\u76f8\u540c\u7684\u201c\u6210\u672c\u8d26\u7c3f+\u5206\u5f55\u7ef4\u5ea6\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalRangeDuplicateValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        entitySet.add(dataEntity);
                        valueSet.clear();
                        break;
                    }
                    valueSet.add(valueStr);
                }
                dupSet.addAll(valueSet);
                continue;
            }
            String valueStr = costAccount.getPkValue().toString();
            if (dupSet.contains(valueStr)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u9009\u62e9\u7684\u5176\u4ed6\u6570\u636e\u5b58\u5728\u76f8\u540c\u7684\u6210\u672c\u8d26\u7c3f+\u7a7a\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalRangeDuplicateValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                entitySet.add(dataEntity);
                continue;
            }
            dupSet.add(valueStr);
        }
        return entitySet;
    }

    private void doValidate(ExtendedDataEntity dataEntity, Set<Long> curCalrangeIds) {
        block10: {
            QFilter q;
            block9: {
                DynamicObject info = dataEntity.getDataEntity();
                DynamicObject costAccount = info.getDynamicObject("costaccount");
                long costaccId = costAccount.getLong("id");
                MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)"cal_bd_calrange");
                Map fieldsMap = bizEntityType.getAllFields();
                Set keySet = fieldsMap.keySet();
                String[] keys = keySet.toArray(new String[0]);
                StringBuilder rangeSelSb = new StringBuilder();
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!(((IDataEntityProperty)entry.getValue()).getParent() instanceof EntryType)) continue;
                    rangeSelSb.append("entry.").append(key).append(",");
                }
                q = new QFilter("id", "<>", info.getPkValue());
                q.and("costaccount", "=", (Object)costaccId);
                q.and("id", "not in", curCalrangeIds);
                DataSet calRangeDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_calrange", (String)(rangeSelSb + "number"), (QFilter[])new QFilter[]{q}, null);
                HashSet<String> calRangeSet = new HashSet<String>(256);
                HashMap<String, String> calRange4Num = new HashMap<String, String>(256);
                for (Row row : calRangeDs) {
                    StringBuilder calrangeSb = new StringBuilder();
                    for (Map.Entry entry : fieldsMap.entrySet()) {
                        String[] key = (String[])entry.getKey();
                        IDataEntityProperty entityPro = (IDataEntityProperty)entry.getValue();
                        if (!(entityPro.getParent() instanceof EntryType)) continue;
                        if (entityPro instanceof BasedataProp) {
                            calrangeSb.append(row.getLong("entry." + (String)key)).append("|");
                            continue;
                        }
                        if (!(entityPro instanceof TextProp)) continue;
                        calrangeSb.append(row.getString("entry." + (String)key)).append("|");
                    }
                    String calrangeStr = calrangeSb.toString();
                    calRangeSet.add(calrangeStr);
                    calRange4Num.put(calrangeStr, row.getString("number"));
                }
                DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
                if (coll.size() <= 0) break block9;
                if (calRangeSet.isEmpty()) {
                    return;
                }
                int i = 0;
                for (DynamicObject entry : coll) {
                    StringBuilder verifyCurSb = new StringBuilder();
                    for (String key : keys) {
                        if (!(((IDataEntityProperty)fieldsMap.get(key)).getParent() instanceof EntryType)) continue;
                        Object value = entry.get(key);
                        verifyCurSb.append(this.getCompareValue(key, value, fieldsMap)).append("|");
                    }
                    String curRangeStr = verifyCurSb.toString();
                    if (calRangeSet.contains(curRangeStr)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6210\u672c\u8d26\u7c3f\u4e0e\u5206\u5f55\u7ef4\u5ea6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u7f16\u7801\u4e3a%2$s", (String)"CalRangeDuplicateValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1, calRange4Num.get(curRangeStr)));
                    }
                    ++i;
                }
                break block10;
            }
            DynamicObject[] existColl = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"number,entry.id", (QFilter[])new QFilter[]{q});
            if (existColl.length <= 0) break block10;
            for (DynamicObject existInfo : existColl) {
                DynamicObjectCollection entryColl = existInfo.getDynamicObjectCollection("entry");
                if (entryColl != null && entryColl.size() != 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6210\u672c\u8d26\u7c3f\u4e14\u7a7a\u5206\u5f55\u7684\u6838\u7b97\u8303\u56f4\uff0c\u7f16\u7801\u4e3a%1$s", (String)"CalRangeDuplicateValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), existInfo.get("number")));
                return;
            }
        }
    }

    private Object getCompareValue(String key, Object value, Map<String, IDataEntityProperty> fieldsMap) {
        Object newValue = value;
        if (fieldsMap.get(key) instanceof BasedataProp) {
            newValue = value != null ? ((DynamicObject)value).getPkValue() : Integer.valueOf(0);
        }
        if (fieldsMap.get(key) instanceof TextProp && StringUtils.isEmpty((String)((String)value))) {
            newValue = " ";
        }
        return newValue;
    }
}

