/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.util.CommonUtils;

public class CalRangeWarehouseValidator
extends AbstractValidator {
    public void validate() {
        this.doValidate();
    }

    private void doValidate() {
        Object dividebasisId;
        HashSet<Object> dividebasisIdSet = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject divideBasis = (DynamicObject)dataEntity.getValue("dividebasis");
            if (divideBasis != null) continue;
            dividebasisId = dataEntity.getValue("dividebasis_id");
            dividebasisIdSet.add(dividebasisId);
        }
        HashMap<Object, String> dividebasisMap = new HashMap<Object, String>(16);
        if (!dividebasisIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", dividebasisIdSet);
            DynamicObjectCollection dividebasisColl = QueryServiceHelper.query((String)"cal_bd_dividebasis", (String)"id,dividebasis", (QFilter[])qFilter.toArray());
            for (DynamicObject dividebasis : dividebasisColl) {
                dividebasisId = dividebasis.getLong("id");
                String dividebasisStr = dividebasis.getString("dividebasis");
                dividebasisMap.put(dividebasisId, dividebasisStr);
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryCollection = dataEntity.getDataEntity().getDynamicObjectCollection("entry");
            DynamicObject divideBasis = (DynamicObject)dataEntity.getValue("dividebasis");
            String divideBasisStr = null;
            if (divideBasis == null) {
                Object dividebasisId2 = dataEntity.getValue("dividebasis_id");
                if (dividebasisId2 != null) {
                    Long id = Long.parseLong(String.valueOf(dividebasisId2));
                    divideBasisStr = (String)dividebasisMap.get(id);
                }
            } else {
                divideBasisStr = divideBasis.getString("dividebasis");
            }
            if (!StringUtils.isNotEmpty((String)divideBasisStr)) continue;
            divideBasisStr = CommonUtils.trimComma((String)divideBasisStr);
            boolean flag = false;
            for (String showColName : divideBasisStr.split(",")) {
                if (!"warehouse".equals(showColName)) continue;
                flag = true;
            }
            if (!flag) continue;
            for (DynamicObject entry : entryCollection) {
                if (null == entry.get("storageorgunit") || null != entry.get("warehouse")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7\uff0c\u8bf7\u586b\u5199\u4ed3\u5e93\u3002", (String)"CalRangeWarehouseValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

