/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostAccountIsMainValidator
extends AbstractValidator {
    public void validate() {
        this.doInnerValid();
        this.doNewValid();
        this.doValid();
    }

    private void doValid() {
        boolean ismainaccount = true;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            boolean isMain = info.getBoolean("ismainaccount");
            if (isMain) {
                DynamicObject orgpattern = info.getDynamicObject("calorg").getDynamicObject("orgpattern");
                String calOrgType = (orgpattern = QueryServiceHelper.queryOne((String)"bos_org_pattern", (String)"id,patterntype", (QFilter[])new QFilter[]{new QFilter("id", "=", orgpattern.get("id"))})).getString("patterntype");
                if (!"1".equals(calOrgType) && !"2".equals(calOrgType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f62\u6001\u7c7b\u578b\u4e3a\u6cd5\u4eba\u4f01\u4e1a\u6216\u6cd5\u4eba\u5206\u652f\u673a\u6784\u7684\u6838\u7b97\u7ec4\u7ec7\u624d\u5141\u8bb8\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"CostAccountIsMainValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    continue;
                }
                QFilter q = new QFilter("calorg", "=", info.getDynamicObject("calorg").get("id"));
                q.and("ismainaccount", "=", (Object)ismainaccount);
                q.and("enable", "=", (Object)"1");
                q.and("id", "<>", info.get("id"));
                if (QueryServiceHelper.exists((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{q})) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u4e3b\u8d26\u7c3f\uff0c\u540c\u4e00\u4e2a\u6838\u7b97\u7ec4\u7ec7\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u4e3b\u8d26\u7c3f\u3002", (String)"CostAccountIsMainValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String taxPayerType = info.getDynamicObject("calorg").getString("taxpayertype");
                if (taxPayerType == null || "".equals(taxPayerType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u8d26\u7c3f\u9700\u5148\u7ef4\u62a4\u4e1a\u52a1\u5355\u5143\u4e2d\u6838\u7b97\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u3002", (String)"CostAccountIsMainValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (info.getDynamicObject("calsystem") == null) continue;
            Long calorgId = info.getDynamicObject("calorg").getLong("id");
            Long calsystemId = info.getDynamicObject("calsystem").getLong("id");
            QFilter qFilter = new QFilter("bizorgentry.bizacctorg", "=", (Object)calorgId);
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("id", "=", (Object)calsystemId);
            if (QueryServiceHelper.exists((String)"bd_accountingsys", (QFilter[])qFilter.toArray())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u4f53\u7cfb\u4e0d\u5c5e\u4e8e\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalRangeImportOp_11", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }

    private void doInnerValid() {
        if (this.dataEntities.length <= 1) {
            return;
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            long calOrgId = info.getDynamicObject("calorg").getLong("id");
            boolean isMain = info.getBoolean("ismainaccount");
            if (!isMain) continue;
            Boolean value = (Boolean)map.get(calOrgId);
            if (value != null && value.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u5b58\u5728\u591a\u4e2a\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u90fd\u662f\u4e3b\u8d26\u7c3f\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAccountIsMainValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                break;
            }
            map.put(calOrgId, isMain);
        }
    }

    private void doNewValid() {
        boolean ismainaccount = true;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject orgpattern = info.getDynamicObject("calorg").getDynamicObject("orgpattern");
            orgpattern = QueryServiceHelper.queryOne((String)"bos_org_pattern", (String)"id,patterntype", (QFilter[])new QFilter[]{new QFilter("id", "=", orgpattern.get("id"))});
            String calOrgType = orgpattern.getString("patterntype");
            boolean isLegal = false;
            if ("1".equals(calOrgType) || "2".equals(calOrgType)) {
                isLegal = true;
            }
            long calOrgId = info.getDynamicObject("calorg").getLong("id");
            boolean isMain = info.getBoolean("ismainaccount");
            QFilter q = new QFilter("calorg", "=", (Object)calOrgId);
            q.and("ismainaccount", "=", (Object)ismainaccount);
            q.and("enable", "=", (Object)"1");
            q.and("id", "<>", info.get("id"));
            if (!isLegal || isMain || QueryServiceHelper.exists((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{q})) continue;
            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u68c0\u67e5\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u4e3b\u8d26\u7c3f\uff0c\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u4e3b\u8d26\u7c3f\u3002", (String)"CostAccountIsMainValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }
}

