/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;

public class CostAccountUniqueValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entitys = this.getDataEntities();
        StringBuilder sb = new StringBuilder();
        for (ExtendedDataEntity entity : entitys) {
            HashSet<Long> costAccId = new HashSet<Long>(16);
            DynamicObjectCollection entrys = entity.getDataEntity().getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                DynamicObject costAccount = entry.getDynamicObject("costaccount");
                if (costAccId.add(costAccount.getLong("id"))) continue;
                sb.append('\u3010').append(costAccount.getString("name")).append('\u3011');
            }
        }
        if (sb.length() > 0) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a{0}\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\u3002", (String)"CostAccountUniqueValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), sb.toString());
            throw new KDBizException(errorMsg);
        }
    }
}

