/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;

public class CostAdjustBillAuditValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject billInfo = extendedDataEntity.getDataEntity();
            Long costAccount = billInfo.getLong("costaccount_id");
            costAccountIds.add(costAccount);
        }
        Map costAccountPeriodMap = PeriodHelper.getCurrentPeriods(costAccountIds);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject currency;
            DynamicObject billInfo = extendedDataEntity.getDataEntity();
            String diffType = billInfo.getString("difftype");
            Date bookdate = billInfo.getDate("bookdate");
            Long costAccount = billInfo.getLong("costaccount_id");
            DynamicObject currentPeriod = (DynamicObject)costAccountPeriodMap.get(costAccount);
            String srcsys = billInfo.getString("srcsys");
            if (currentPeriod != null && bookdate.before(currentPeriod.getDate("begindate")) && (StringUtils.isEmpty((String)srcsys) || !"C".equals(srcsys))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u4e3a\u5f80\u671f\u6570\u636e\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"CostAdjustBillAuditValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
            if ((currency = billInfo.getDynamicObject("currency")) == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u7ed1\u5b9a\u7684\u6838\u7b97\u653f\u7b56\u4e2d\u7684\u672c\u4f4d\u5e01\u5b57\u6bb5\u3002", (String)"CostAdjustBillAuditValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entry = billInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                String accountType = dynamicObject.getString("accounttype");
                int rowNumber = dynamicObject.getInt("seq");
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) || !CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(diffType)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8ba1\u4ef7\u65b9\u6cd5\u662f\u6807\u51c6\u6210\u672c\u6cd5\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u65b0\u589e\u3001\u624b\u5de5\u5bfc\u5165\u3002", (String)"CostAdjustBillSubmitOp_22", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowNumber);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

