/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.PeriodHelper;

public class CostAdjustBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject billInfo = extendedDataEntity.getDataEntity();
            Long costAccount = billInfo.getLong("costaccount_id");
            costAccountIds.add(costAccount);
        }
        Map costAccountPeriodMap = PeriodHelper.getCurrentPeriods(costAccountIds);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject billInfo = extendedDataEntity.getDataEntity();
            Date bookdate = billInfo.getDate("bookdate");
            Long costAccount = billInfo.getLong("costaccount_id");
            DynamicObject currentPeriod = (DynamicObject)costAccountPeriodMap.get(costAccount);
            String srcsys = billInfo.getString("srcsys");
            if (currentPeriod == null || !bookdate.before(currentPeriod.getDate("begindate")) || !StringUtils.isEmpty((String)srcsys) && "C".equals(srcsys)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u4e3a\u5f80\u671f\u6570\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostAdjustBillUnAuditValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }
}

