/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CostUpdateApplyBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] billInfos = this.getDataEntities();
        HashSet<Long> costaccountIds = new HashSet<Long>(billInfos.length);
        for (ExtendedDataEntity billInfo : billInfos) {
            DynamicObject bill = billInfo.getDataEntity();
            Long costaccountId = bill.getLong("costaccount.id");
            if (costaccountId == null || costaccountId == 0L) continue;
            costaccountIds.add(costaccountId);
        }
        QFilter q = new QFilter("billstatus", "=", (Object)Character.valueOf('B'));
        q.and("costaccount", "in", costaccountIds);
        DataSet currSubmitBill = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costupdateapplybill", (String)"billno,entryentity.baldetailid", (QFilter[])q.toArray(), null);
        HashMap<Long, String> baldetailBillnoMap = new HashMap<Long, String>(1024);
        for (Row row : currSubmitBill) {
            Long baldetailid = row.getLong("entryentity.baldetailid");
            String billno = row.getString("billno");
            if (!StringUtils.isNotEmpty((String)billno) || baldetailid == null) continue;
            baldetailBillnoMap.put(baldetailid, billno);
        }
        for (ExtendedDataEntity billInfo : billInfos) {
            DynamicObject bill = billInfo.getDataEntity();
            String billno = bill.getString("billno");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            int size = entrys.size();
            HashMap<Long, String> newbaldetailBillnoMap = new HashMap<Long, String>(size);
            boolean needPutAll = true;
            HashSet<String> needAsditBillnoSet = new HashSet<String>(16);
            for (int i = 0; i < size; ++i) {
                int rowNumber = i + 1;
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                BigDecimal newUnitCost = entryInfo.getBigDecimal("newunitcost");
                Long baldetailid = entryInfo.getLong("baldetailid");
                if (newUnitCost != null && newUnitCost.compareTo(BigDecimal.ZERO) < 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u65b0\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CostUpdateApplyBillSubmitValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), rowNumber);
                    this.addErrorMessage(billInfo, msg);
                    needPutAll = false;
                }
                if (baldetailid == null) continue;
                String currBillno = (String)baldetailBillnoMap.get(baldetailid);
                if (StringUtils.isNotEmpty((String)currBillno)) {
                    needPutAll = false;
                    needAsditBillnoSet.add(currBillno);
                    continue;
                }
                if (!needPutAll) continue;
                newbaldetailBillnoMap.put(baldetailid, billno);
            }
            if (needPutAll) {
                baldetailBillnoMap.putAll(newbaldetailBillnoMap);
                continue;
            }
            if (needAsditBillnoSet.isEmpty()) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5355\u636e\uff1a%1$s\u6b63\u5728\u8fdb\u884c\u6210\u672c\u66f4\u65b0\uff0c\u9700\u8981\u76f8\u5173\u5355\u636e\u5148\u5ba1\u6838\u624d\u80fd\u63d0\u4ea4\u5f53\u524d\u5355\u636e\u3002", (String)"CostUpdateApplyBillSubmitValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", needAsditBillnoSet));
            this.addErrorMessage(billInfo, msg);
        }
    }
}

