/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FallPriceBillDimValidator
extends AbstractValidator {
    private int curPeriodNumber = 0;

    public void validate() {
        HashMap indexDulBillsMap = new HashMap(16);
        try (DataSet billDs = this.getCheckDulDs();){
            for (Row row : billDs) {
                Integer index = row.getInteger("index");
                Integer seq = row.getInteger("seq");
                indexDulBillsMap.putIfAbsent(index, new HashMap(16));
                Map seqDulBillsMap = (Map)indexDulBillsMap.get(index);
                seqDulBillsMap.putIfAbsent(seq, row.getString("dbbillno"));
            }
        }
        for (Map.Entry indexEntry : indexDulBillsMap.entrySet()) {
            StringBuilder msgSb = new StringBuilder();
            String msgFmt = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u8ba1\u63d0\u5355\u201c%2$s\u201d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FallPriceBillDimValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            for (Map.Entry seqEntry : ((Map)indexEntry.getValue()).entrySet()) {
                msgSb.append(String.format(msgFmt, seqEntry.getKey(), StringUtils.join((Object[])new String[]{(String)seqEntry.getValue()})));
            }
            this.addErrorMessage(this.getDataEntities()[(Integer)indexEntry.getKey()], msgSb.toString());
        }
        this.checkWareDulInBIll();
    }

    private void checkWareDulInBIll() {
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject billDyc = billInfo.getDataEntity();
            DynamicObjectCollection entryDycs = billDyc.getDynamicObjectCollection("entry");
            HashMap<String, Integer> record = new HashMap<String, Integer>();
            ArrayList<String> dims = new ArrayList<String>(16);
            ArrayList<String> entryDims = new ArrayList<String>(16);
            this.getDims(dims, entryDims);
            dims.add("material");
            dims.add("warehousegroup");
            dims.add("invagefrom");
            dims.add("invageto");
            dims.add("expirydatefrom");
            dims.add("expirydateto");
            int rowCount = 0;
            for (DynamicObject entryDyc : entryDycs) {
                ++rowCount;
                StringBuilder dimKeySb = new StringBuilder();
                for (String dim : dims) {
                    Object dimValue = entryDyc.get(dim);
                    if (dimValue instanceof DynamicObject) {
                        dimValue = ((DynamicObject)dimValue).getPkValue();
                    }
                    dimKeySb.append(dimValue);
                    dimKeySb.append(',');
                }
                String key = dimKeySb.toString();
                if (record.containsKey(key)) {
                    this.addErrorMessage(billInfo, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u7ef4\u5ea6\u91cd\u590d\uff0c \u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), record.get(key), rowCount));
                    continue;
                }
                record.put(key, rowCount);
            }
        }
    }

    private DataSet getCheckDulDs() {
        String[] fieldNames;
        ArrayList<String> dims = new ArrayList<String>(16);
        ArrayList<String> entryDims = new ArrayList<String>(16);
        this.getDims(dims, entryDims);
        HashSet<Object> calOrgs = new HashSet<Object>(16);
        HashSet<Object> accts = new HashSet<Object>(16);
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject billDyc = billInfo.getDataEntity();
            DynamicObject orgDyc = billDyc.getDynamicObject("org");
            DynamicObject acctDyc = billDyc.getDynamicObject("costaccount");
            if (orgDyc == null || acctDyc == null || billDyc.getInt("period") != this.curPeriodNumber) continue;
            calOrgs.add(orgDyc.getPkValue());
            accts.add(acctDyc.getPkValue());
        }
        String entryDimSelects = StringUtils.join((Object[])entryDims.toArray(new String[0]), (String)",");
        entryDimSelects = "0 index,entry.seq seq,billno,org,costaccount,entry.material material,entry.warehousegroup warehousegroup,entry.invagefrom invagefrom,entry.invageto invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto," + entryDimSelects;
        ArrayList<QFilter> billfs = new ArrayList<QFilter>(16);
        QFilter calOrgf = new QFilter("org", "in", calOrgs);
        QFilter acctsf = new QFilter("costaccount", "in", accts);
        if (this.curPeriodNumber != 0) {
            QFilter periodNumf = new QFilter("period", "=", (Object)this.curPeriodNumber);
            billfs.add(periodNumf);
        }
        billfs.add(calOrgf);
        billfs.add(acctsf);
        DataSet provDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getSimpleName() + "cal_price_provbill"), (String)"cal_price_provbill", (String)entryDimSelects, (QFilter[])billfs.toArray(new QFilter[0]), null);
        DataSet matAndGroupProvDs = provDs.copy().filter("warehousegroup <> null");
        DataSetBuilder builder = Algo.create((String)((Object)((Object)this)).getClass().getSimpleName()).createDataSetBuilder(provDs.getRowMeta());
        DataSetBuilder wareGroupBuilder = Algo.create((String)((Object)((Object)this)).getClass().getSimpleName()).createDataSetBuilder(provDs.getRowMeta());
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject billDyc = billInfo.getDataEntity();
            DynamicObject orgDyc = billDyc.getDynamicObject("org");
            DynamicObject acctDyc = billDyc.getDynamicObject("costaccount");
            if (orgDyc == null || acctDyc == null || billDyc.getInt("period") != this.curPeriodNumber) continue;
            DynamicObjectCollection entryDycs = billDyc.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                ArrayList<Object> curBills = new ArrayList<Object>(entryDims.size() + 7);
                curBills.add(billInfo.getDataEntityIndex());
                curBills.add(entryDyc.get("seq"));
                curBills.add(billInfo.getBillNo());
                curBills.add(orgDyc.getPkValue());
                curBills.add(acctDyc.getPkValue());
                curBills.add(this.getDycValueOrId(entryDyc, "material"));
                curBills.add(this.getDycValueOrId(entryDyc, "warehousegroup"));
                curBills.add(entryDyc.get("invagefrom"));
                curBills.add(entryDyc.get("invageto"));
                curBills.add(entryDyc.get("expirydatefrom"));
                curBills.add(entryDyc.get("expirydateto"));
                for (String dim : dims) {
                    curBills.add(this.getDycValueOrId(entryDyc, dim));
                }
                DynamicObject warehouseGroup = entryDyc.getDynamicObject("warehousegroup");
                if (warehouseGroup != null) {
                    wareGroupBuilder.append(curBills.toArray(new Object[0]));
                    continue;
                }
                builder.append(curBills.toArray(new Object[0]));
            }
        }
        JoinDataSet dbJoinCurDs = builder.build().join(provDs);
        JoinDataSet wareDbJoinCurDs = wareGroupBuilder.build().join(matAndGroupProvDs);
        for (String field : fieldNames = provDs.getRowMeta().getFieldNames()) {
            if ("index".equals(field) || "seq".equals(field) || "billno".equals(field)) continue;
            dbJoinCurDs.on(field, field);
            wareDbJoinCurDs.on(field, field);
        }
        provDs = dbJoinCurDs.select(fieldNames, new String[]{"billno dbbillno", "seq dbseq", "org dborg"}).finish().filter("dborg is not null and billno <> dbbillno");
        matAndGroupProvDs = wareDbJoinCurDs.select(fieldNames, new String[]{"billno dbbillno", "seq dbseq", "org dborg"}).finish().filter("dborg is not null and billno <> dbbillno");
        return provDs.union(matAndGroupProvDs);
    }

    private void getDims(List<String> dims, List<String> entryDims) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_fallprice_setting");
        List setDimensions = ((MulComboProp)dataEntityType.getAllFields().get("setdimension")).getComboItems();
        HashSet<String> dimsSet = new HashSet<String>(16);
        for (ValueMapItem dim : setDimensions) {
            String value = dim.getValue();
            if ("x".equals(value) || dimsSet.contains(value)) continue;
            dims.add(value);
            entryDims.add("entry." + value + " as " + value);
            dimsSet.add(value);
        }
    }

    private Object getDycValueOrId(DynamicObject entryDyc, String key) {
        Object matDyc = entryDyc.get(key);
        IDataEntityProperty property = (IDataEntityProperty)entryDyc.getDataEntityType().getProperties().get((Object)key);
        if (property instanceof BasedataProp) {
            matDyc = matDyc == null ? Long.valueOf(0L) : ((DynamicObject)matDyc).getPkValue();
        }
        return matDyc;
    }
}

