/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FallPriceCalOrgAcctValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Boolean> calOrgAcctEmptyMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, List<Integer>> calOrgAcctIndexMap = new HashMap<Long, List<Integer>>(16);
        HashSet<Long> calOrgAcctErrorIds = new HashSet<Long>(16);
        HashSet<Long> calOrgAcctIds = new HashSet<Long>(16);
        this.getCheckInfo(calOrgAcctEmptyMap, calOrgAcctIndexMap, calOrgAcctErrorIds, calOrgAcctIds);
        this.getCheckInfoFromDb(calOrgAcctEmptyMap, calOrgAcctErrorIds, calOrgAcctIds);
        this.addErrorMsg(calOrgAcctIndexMap, calOrgAcctErrorIds);
    }

    private void getCheckInfo(Map<Long, Boolean> calOrgAcctEmptyMap, Map<Long, List<Integer>> calOrgAcctIndexMap, Set<Long> calOrgAcctErrorIds, Set<Long> calOrgAcctIds) {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject settingDyc = entity.getDataEntity();
            DynamicObject calOrgDyc = settingDyc.getDynamicObject("calorg");
            DynamicObject costAccountDyc = settingDyc.getDynamicObject("costaccount");
            if (calOrgDyc == null) continue;
            Long calOrgId = (Long)calOrgDyc.getPkValue();
            calOrgAcctIds.add(calOrgId);
            if (calOrgAcctErrorIds.contains(calOrgId)) continue;
            calOrgAcctIds.add(calOrgId);
            Boolean acctEmpty = costAccountDyc == null;
            calOrgAcctIndexMap.putIfAbsent(calOrgId, new ArrayList(16));
            calOrgAcctIndexMap.get(calOrgId).add(entity.getDataEntityIndex());
            Boolean preAcctEmpty = calOrgAcctEmptyMap.get(calOrgId);
            if (preAcctEmpty != null) {
                if (acctEmpty.equals(preAcctEmpty)) continue;
                calOrgAcctErrorIds.add(calOrgId);
                calOrgAcctEmptyMap.remove(calOrgId);
                continue;
            }
            calOrgAcctEmptyMap.put(calOrgId, acctEmpty);
        }
    }

    private void getCheckInfoFromDb(Map<Long, Boolean> calOrgAcctEmptyMap, Set<Long> calOrgAcctErrorIds, Set<Long> calOrgAcctIds) {
        String matSelects = "number, calorg, costaccount";
        QFilter idf = new QFilter("calorg", "not in", calOrgAcctErrorIds);
        idf.and(new QFilter("calorg", "in", calOrgAcctIds));
        try (DataSet settingDbDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fallprice_setting", (String)matSelects, (QFilter[])new QFilter[]{idf}, null);){
            for (Row row : settingDbDs) {
                Long calOrg = row.getLong("calorg");
                Boolean acctIsEmpty = calOrgAcctEmptyMap.get(calOrg);
                Long costaAccount = row.getLong("costaccount");
                boolean error = acctIsEmpty != false && !costaAccount.equals(0L) || acctIsEmpty == false && costaAccount.equals(0L);
                if (!error) continue;
                calOrgAcctErrorIds.add(calOrg);
            }
        }
    }

    private void addErrorMsg(Map<Long, List<Integer>> calOrgAcctIndexMap, Set<Long> calOrgAcctErrorIds) {
        for (Long calOrg : calOrgAcctErrorIds) {
            List<Integer> errorIndexs = calOrgAcctIndexMap.get(calOrg);
            if (errorIndexs == null) continue;
            for (Integer index : errorIndexs) {
                this.addErrorMessage(this.dataEntities[index], ResManager.loadKDString((String)"\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u65e2\u6309\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u53c8\u6309\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f\u201d\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FallPriceCalOrgAcctValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

