/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.enums.ProvisionWayEnum;

public class FallPriceDimValidator
extends AbstractValidator {
    private Map<Integer, List<Long>> billMaterialMap = new HashMap<Integer, List<Long>>(16);
    private Map<Long, DynamicObject> materialDycMap = new HashMap<Long, DynamicObject>(16);
    private Map<Integer, List<DynamicObject>> billIndexMatGroupNumMap = new HashMap<Integer, List<DynamicObject>>(16);
    private Map<Integer, List<DynamicObject>> billIndexWareGroupNumMap = new HashMap<Integer, List<DynamicObject>>(16);
    private Map<Integer, String> billIndexCalOrgAccountMap = new HashMap<Integer, String>(16);
    private List<Long> settingIds = new ArrayList<Long>(16);

    public void validate() {
        this.checkCurOpSetting();
        HashMap<String, Map<String, List<Long>>> calOrgAcctSettingMatDbMap = new HashMap<String, Map<String, List<Long>>>(16);
        HashMap<String, String> settingNumNameDbMap = new HashMap<String, String>(16);
        HashMap<String, DynamicObject> settingNumMatDycMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Map<String, List<DynamicObject>>> calOrgAcctMatSettingGroupDbMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        HashMap<String, Map<String, List<DynamicObject>>> calOrgAcctSettingWareGroupDbMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        this.querySettingDbMap(calOrgAcctSettingMatDbMap, settingNumMatDycMap, calOrgAcctMatSettingGroupDbMap, calOrgAcctSettingWareGroupDbMap, settingNumNameDbMap);
        this.checkMatBetweenSetting(calOrgAcctSettingMatDbMap, settingNumNameDbMap);
        this.checkMatGroupBetweenSetting(calOrgAcctMatSettingGroupDbMap);
        this.checkWareGroupBetweenSetting(calOrgAcctSettingWareGroupDbMap);
    }

    private void checkCurOpSetting() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            Integer dataIndex = entity.getDataEntityIndex();
            HashMap<String, List<Integer[]>> dimAgeMap = new HashMap<String, List<Integer[]>>(16);
            DynamicObject settingDyc = entity.getDataEntity();
            String provisionWay = settingDyc.getString("provisionway");
            this.getSettingInfo(dataIndex, settingDyc);
            DynamicObjectCollection entryDycs = settingDyc.getDynamicObjectCollection("entry");
            if (entryDycs.isEmpty()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FallPriceDimValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.checkDimOverlap(entity, dimAgeMap, provisionWay);
            this.getMatAndGroupInfo(dataIndex, settingDyc, provisionWay);
        }
        this.validateEntryMaterial();
        this.validateEntryWarehouseGroup();
    }

    private void validateEntryWarehouseGroup() {
        HashMap longNumberMap = new HashMap(this.billIndexWareGroupNumMap.size());
        ArrayList<String> groupLongNumList = new ArrayList<String>(16);
        for (Map.Entry<Integer, List<DynamicObject>> billWarehouseGroup : this.billIndexWareGroupNumMap.entrySet()) {
            List<DynamicObject> warehouseGroupList = billWarehouseGroup.getValue();
            Integer key = billWarehouseGroup.getKey();
            if (warehouseGroupList == null || key == null) continue;
            longNumberMap.put(key, new ArrayList(warehouseGroupList.size()));
            for (DynamicObject dynamicObject : warehouseGroupList) {
                ((List)longNumberMap.get(key)).add(dynamicObject.getString("longnumber"));
                groupLongNumList.add(dynamicObject.getString("longnumber"));
            }
        }
        for (int i = 0; i < groupLongNumList.size(); ++i) {
            String numberOne = (String)groupLongNumList.get(i);
            for (int j = 0; j < groupLongNumList.size(); ++j) {
                String numberTwo;
                if (i == j || !numberOne.startsWith(numberTwo = (String)groupLongNumList.get(j)) || numberOne.equals(numberTwo)) continue;
                for (Map.Entry entry : longNumberMap.entrySet()) {
                    if (!((List)entry.getValue()).contains(numberOne)) continue;
                    this.addErrorMessage(this.dataEntities[(Integer)entry.getKey()], ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5185\u4ed3\u5e93\u5206\u7ec4\u4e0d\u5141\u8bb8\u5b58\u5728\u5305\u542b\u5173\u7cfb\u3002", (String)"FallPriceDimValidator_8", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void validateEntryMaterial() {
        String longNumberDLM = FallPriceHelper.getMatGroupDLM();
        HashMap longNumberMap = new HashMap(this.billIndexMatGroupNumMap.size());
        ArrayList<String> groupLongNumList = new ArrayList<String>(16);
        for (Map.Entry<Integer, List<DynamicObject>> billMaterialGroup : this.billIndexMatGroupNumMap.entrySet()) {
            List<DynamicObject> materialGroupList = billMaterialGroup.getValue();
            Integer key = billMaterialGroup.getKey();
            if (materialGroupList == null || key == null) continue;
            longNumberMap.put(key, new ArrayList(materialGroupList.size()));
            for (DynamicObject dynamicObject : materialGroupList) {
                ((List)longNumberMap.get(key)).add(dynamicObject.getString("longnumber"));
                groupLongNumList.add(dynamicObject.getString("longnumber"));
            }
        }
        for (int i = 0; i < groupLongNumList.size(); ++i) {
            String numberOne = (String)groupLongNumList.get(i);
            for (int j = 0; j < groupLongNumList.size(); ++j) {
                String numberTwo;
                if (i == j || !numberOne.startsWith((numberTwo = (String)groupLongNumList.get(j)) + longNumberDLM) || numberOne.equals(numberTwo)) continue;
                for (Map.Entry entry : longNumberMap.entrySet()) {
                    if (!((List)entry.getValue()).contains(numberOne)) continue;
                    this.addErrorMessage(this.dataEntities[(Integer)entry.getKey()], ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5185\u7269\u6599\u5206\u7c7b\u4e0d\u5141\u8bb8\u5b58\u5728\u5305\u542b\u5173\u7cfb\u3002", (String)"FallPriceDimValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void getSettingInfo(Integer dataIndex, DynamicObject settingDyc) {
        DynamicObject calOrgDyc = settingDyc.getDynamicObject("calorg");
        DynamicObject accountDyc = settingDyc.getDynamicObject("costaccount");
        if (calOrgDyc != null) {
            String calOrgAccountStr = calOrgDyc.getPkValue() + ",";
            calOrgAccountStr = accountDyc == null ? calOrgAccountStr + "0" : calOrgAccountStr + accountDyc.getPkValue();
            this.billIndexCalOrgAccountMap.put(dataIndex, calOrgAccountStr);
        }
        if (settingDyc.getDataEntityState().getFromDatabase()) {
            this.settingIds.add((Long)settingDyc.getPkValue());
        }
    }

    private void getMatAndGroupInfo(Integer dataIndex, DynamicObject settingDyc, String provisionWay) {
        for (DynamicObject entry : settingDyc.getDynamicObjectCollection("entry")) {
            DynamicObject wareGroupDyc;
            if (ProvisionWayEnum.MATERIAL.getValue().equals(provisionWay)) {
                DynamicObject materialDyc = entry.getDynamicObject("material");
                if (materialDyc == null) continue;
                this.billMaterialMap.putIfAbsent(dataIndex, new ArrayList(16));
                this.billMaterialMap.get(dataIndex).add((Long)materialDyc.getPkValue());
                this.materialDycMap.put((Long)materialDyc.getPkValue(), materialDyc);
                continue;
            }
            if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(provisionWay)) {
                DynamicObject matGroupDyc = entry.getDynamicObject("materialgroup");
                if (matGroupDyc == null) continue;
                this.billIndexMatGroupNumMap.putIfAbsent(dataIndex, new ArrayList(16));
                this.billIndexMatGroupNumMap.get(dataIndex).add(matGroupDyc);
                continue;
            }
            if (!ProvisionWayEnum.WAREHOUSEGROUP.getValue().equals(provisionWay) || (wareGroupDyc = entry.getDynamicObject("warehousegroup")) == null) continue;
            this.billIndexWareGroupNumMap.putIfAbsent(dataIndex, new ArrayList(16));
            this.billIndexWareGroupNumMap.get(dataIndex).add(wareGroupDyc);
        }
    }

    private void checkWareGroupBetweenSetting(Map<String, Map<String, List<DynamicObject>>> calOrgAcctSettingWareGroupNoMatDbMap) {
        for (Map.Entry<Integer, List<DynamicObject>> billWareGroupNoMat : this.billIndexWareGroupNumMap.entrySet()) {
            List<DynamicObject> warehouseGroupDycs = billWareGroupNoMat.getValue();
            String calOrgAcctStr = this.billIndexCalOrgAccountMap.get(billWareGroupNoMat.getKey());
            for (DynamicObject warehouseGroupDyc : warehouseGroupDycs) {
                String curNum = warehouseGroupDyc.getString("number");
                String curLNum = warehouseGroupDyc.getString("longnumber");
                int curLevel = warehouseGroupDyc.getInt("level");
                for (Map.Entry<Integer, List<DynamicObject>> billWareGroupNoMatOther : this.billIndexWareGroupNumMap.entrySet()) {
                    StringBuilder matrialGroupNumNameSb = new StringBuilder();
                    boolean calOrgAccountEqual = this.billIndexCalOrgAccountMap.get(billWareGroupNoMat.getKey()).equals(this.billIndexCalOrgAccountMap.get(billWareGroupNoMatOther.getKey()));
                    if (billWareGroupNoMat.getKey().equals(billWareGroupNoMatOther.getKey()) || !calOrgAccountEqual) continue;
                    List<DynamicObject> warehouseGroupOtherDycs = billWareGroupNoMatOther.getValue();
                    for (DynamicObject warehouseGroupOtherDyc : warehouseGroupOtherDycs) {
                        String otherNum = warehouseGroupOtherDyc.getString("number");
                        String otherLNum = warehouseGroupOtherDyc.getString("longnumber");
                        int otherLevel = warehouseGroupOtherDyc.getInt("level");
                        boolean curContainOther = curNum.equals(otherNum) || curLNum.startsWith(otherLNum) && curLevel > otherLevel;
                        boolean otherContainCur = curNum.equals(otherNum) || otherLNum.startsWith(curLNum) && otherLevel > curLevel;
                        DynamicObject otherBillDyc = this.dataEntities[billWareGroupNoMatOther.getKey()].getDataEntity();
                        String settingNumber = otherBillDyc.getString("number");
                        String settingName = otherBillDyc.getString("name");
                        if (!curContainOther && !otherContainCur) continue;
                        if (matrialGroupNumNameSb.length() <= 0) {
                            String settingFmt = ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%1$s\uff0c\u65b9\u6848\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                            matrialGroupNumNameSb.append(String.format(settingFmt, settingNumber, settingName));
                        }
                        String matgroupFmt = ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801\uff1a%1$s\uff0c\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_9", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                        matrialGroupNumNameSb.append("\uff0c");
                        matrialGroupNumNameSb.append(String.format(matgroupFmt, warehouseGroupDyc.getString("number"), warehouseGroupDyc.getString("name")));
                    }
                    this.addDulError(matrialGroupNumNameSb, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u91cd\u590d\u4ed3\u5e93\u5206\u7ec4\u201c%1$s\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_14", (String)"fi-cal-opplugin", (Object[])new Object[0]), billWareGroupNoMat.getKey());
                }
                Map<String, List<DynamicObject>> settingNumWareGroupNoMatDbsMap = calOrgAcctSettingWareGroupNoMatDbMap.get(calOrgAcctStr);
                if (settingNumWareGroupNoMatDbsMap == null) continue;
                for (Map.Entry<String, List<DynamicObject>> settingNumWareGroupNoMatDbs : settingNumWareGroupNoMatDbsMap.entrySet()) {
                    StringBuilder warehouseGroupNumNameSb = new StringBuilder();
                    for (DynamicObject settingNumWareGroupNoMatDb : settingNumWareGroupNoMatDbs.getValue()) {
                        String otherNum = settingNumWareGroupNoMatDb.getString("warehousegroupnum");
                        String otherLNum = settingNumWareGroupNoMatDb.getString("warehousegrouplnum");
                        int otherLevel = settingNumWareGroupNoMatDb.getInt("level");
                        boolean curContainOther = curNum.equals(otherNum) || curLNum.startsWith(otherLNum) && curLevel > otherLevel;
                        boolean otherContainCur = curNum.equals(otherNum) || otherLNum.startsWith(curLNum) && otherLevel > curLevel;
                        String settingNumber = settingNumWareGroupNoMatDb.getString("settingnumber");
                        String settingName = settingNumWareGroupNoMatDb.getString("settingname");
                        String warehouseGroupName = settingNumWareGroupNoMatDb.getString("warehousegroupname");
                        if (!curContainOther && !otherContainCur) continue;
                        if (warehouseGroupNumNameSb.length() <= 0) {
                            String settingFmt = ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%1$s\uff0c\u65b9\u6848\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                            warehouseGroupNumNameSb.append(String.format(settingFmt, settingNumber, settingName));
                        }
                        String wareGroupFmt = ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801\uff1a%1$s\uff0c\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_9", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                        warehouseGroupNumNameSb.append("\uff0c");
                        warehouseGroupNumNameSb.append(String.format(wareGroupFmt, otherNum, warehouseGroupName));
                    }
                    this.addDulError(warehouseGroupNumNameSb, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u91cd\u590d\u4ed3\u5e93\u5206\u7ec4\u201c%1$s\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_14", (String)"fi-cal-opplugin", (Object[])new Object[0]), billWareGroupNoMat.getKey());
                }
            }
        }
    }

    private void checkMatGroupBetweenSetting(Map<String, Map<String, List<DynamicObject>>> calOrgAcctMatSettingGroupDbMap) {
        String longNumberDLM = FallPriceHelper.getMatGroupDLM();
        for (Map.Entry<Integer, List<DynamicObject>> billMaterialGroup : this.billIndexMatGroupNumMap.entrySet()) {
            DynamicObject curSettingDyc = this.dataEntities[billMaterialGroup.getKey()].getDataEntity();
            Object curMgs = curSettingDyc.getDynamicObject("materialgroupstandard");
            curMgs = curMgs == null ? 730148448254487552L : curMgs.getLong("id");
            List<DynamicObject> materialGroupDycs = billMaterialGroup.getValue();
            String calOrgAcctStr = this.billIndexCalOrgAccountMap.get(billMaterialGroup.getKey());
            for (DynamicObject materialGroupDyc : materialGroupDycs) {
                String curNum = materialGroupDyc.getString("number");
                String curLNum = materialGroupDyc.getString("longnumber");
                int curLevel = materialGroupDyc.getInt("level");
                for (Map.Entry<Integer, List<DynamicObject>> billMaterialGroupOther : this.billIndexMatGroupNumMap.entrySet()) {
                    StringBuilder matrialGroupNumNameSb = new StringBuilder();
                    boolean calOrgAccountEqual = this.billIndexCalOrgAccountMap.get(billMaterialGroup.getKey()).equals(this.billIndexCalOrgAccountMap.get(billMaterialGroupOther.getKey()));
                    if (billMaterialGroup.getKey().equals(billMaterialGroupOther.getKey()) || !calOrgAccountEqual) continue;
                    DynamicObject otherSettingDyc = this.dataEntities[billMaterialGroupOther.getKey()].getDataEntity();
                    Object otherMgs = otherSettingDyc.getDynamicObject("materialgroupstandard");
                    otherMgs = otherMgs == null ? 730148448254487552L : otherMgs.getLong("id");
                    List<DynamicObject> materialGroupOtherDycs = billMaterialGroupOther.getValue();
                    for (DynamicObject materialGroupOtherDyc : materialGroupOtherDycs) {
                        String otherNum = materialGroupOtherDyc.getString("number");
                        String otherLNum = materialGroupOtherDyc.getString("longnumber");
                        int otherLevel = materialGroupOtherDyc.getInt("level");
                        boolean curContainOther = curNum.equals(otherNum) || curLNum.startsWith(otherLNum + longNumberDLM) && curLevel > otherLevel;
                        boolean otherContainCur = curNum.equals(otherNum) || otherLNum.startsWith(curLNum + longNumberDLM) && otherLevel > curLevel;
                        DynamicObject otherBillDyc = this.dataEntities[billMaterialGroupOther.getKey()].getDataEntity();
                        String settingNumber = otherBillDyc.getString("number");
                        String settingName = otherBillDyc.getString("name");
                        boolean curMgsEqualsOtherMgs = curMgs.equals(otherMgs);
                        if (!curMgsEqualsOtherMgs || !curContainOther && !otherContainCur) continue;
                        if (matrialGroupNumNameSb.length() <= 0) {
                            String settingFmt = ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%1$s\uff0c\u65b9\u6848\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                            matrialGroupNumNameSb.append(String.format(settingFmt, settingNumber, settingName));
                        }
                        String matgroupFmt = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a%1$s\uff0c\u7269\u6599\u5206\u7c7b\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                        matrialGroupNumNameSb.append("\uff0c");
                        matrialGroupNumNameSb.append(String.format(matgroupFmt, materialGroupDyc.getString("number"), materialGroupDyc.getString("name")));
                    }
                    this.addDulError(matrialGroupNumNameSb, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u91cd\u590d\u7269\u6599\u5206\u7c7b\u201c%1$s\u201d\uff0c \u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_13", (String)"fi-cal-opplugin", (Object[])new Object[0]), billMaterialGroup.getKey());
                }
                Map<String, List<DynamicObject>> settingNumMatGroupDbsMap = calOrgAcctMatSettingGroupDbMap.get(calOrgAcctStr);
                if (settingNumMatGroupDbsMap == null) continue;
                for (Map.Entry<String, List<DynamicObject>> settingNumMatGroupDbs : settingNumMatGroupDbsMap.entrySet()) {
                    StringBuilder matrialGroupNumNameSb = new StringBuilder();
                    for (DynamicObject settingNumMatGroupDb : settingNumMatGroupDbs.getValue()) {
                        String otherNum = settingNumMatGroupDb.getString("materialgroupnum");
                        String otherLNum = settingNumMatGroupDb.getString("materialgrouplnum");
                        int otherLevel = settingNumMatGroupDb.getInt("level");
                        boolean curContainOther = curNum.equals(otherNum) || curLNum.startsWith(otherLNum + longNumberDLM) && curLevel > otherLevel;
                        boolean otherContainCur = curNum.equals(otherNum) || otherLNum.startsWith(curLNum + longNumberDLM) && otherLevel > curLevel;
                        String settingNumber = settingNumMatGroupDb.getString("settingnumber");
                        String settingName = settingNumMatGroupDb.getString("settingname");
                        String materialGroupName = settingNumMatGroupDb.getString("materialgroupname");
                        long otherDbMgs = settingNumMatGroupDb.getLong("materialgroupstandard");
                        boolean curMgsEqualsOtherMgs = curMgs.equals(otherDbMgs = otherDbMgs == 0L ? 730148448254487552L : otherDbMgs);
                        if (!curMgsEqualsOtherMgs || !curContainOther && !otherContainCur) continue;
                        if (matrialGroupNumNameSb.length() <= 0) {
                            String settingFmt = ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%1$s\uff0c\u65b9\u6848\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                            matrialGroupNumNameSb.append(String.format(settingFmt, settingNumber, settingName));
                        }
                        String matgroupFmt = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a%1$s\uff0c\u7269\u6599\u5206\u7c7b\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                        matrialGroupNumNameSb.append("\uff0c");
                        matrialGroupNumNameSb.append(String.format(matgroupFmt, otherNum, materialGroupName));
                    }
                    this.addDulError(matrialGroupNumNameSb, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u91cd\u590d\u7269\u6599\u5206\u7c7b\u201c%1$s\u201d\uff0c \u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_13", (String)"fi-cal-opplugin", (Object[])new Object[0]), billMaterialGroup.getKey());
                }
            }
        }
    }

    private void addDulError(StringBuilder matrialGroupNumNameSb, String msgFormat, Integer index) {
        String materialGroupMsg = matrialGroupNumNameSb.toString();
        if (materialGroupMsg.length() > 0) {
            this.addErrorMessage(this.dataEntities[index], String.format(msgFormat, materialGroupMsg));
        }
    }

    private void checkMatBetweenSetting(Map<String, Map<String, List<Long>>> calOrgAcctSettingMatDbMap, Map<String, String> settingNumNameDbMap) {
        for (Map.Entry<Integer, List<Long>> billMaterial : this.billMaterialMap.entrySet()) {
            ArrayList<Long> materialIds;
            StringBuilder matrialNumNameSb;
            String calOrgAcctStr = this.billIndexCalOrgAccountMap.get(billMaterial.getKey());
            for (Map.Entry<Integer, List<Long>> billMaterialOther : this.billMaterialMap.entrySet()) {
                boolean calOrgAccountEqual = calOrgAcctStr.equals(this.billIndexCalOrgAccountMap.get(billMaterialOther.getKey()));
                if (billMaterial.getKey().equals(billMaterialOther.getKey()) || !calOrgAccountEqual) continue;
                matrialNumNameSb = new StringBuilder();
                materialIds = new ArrayList(billMaterial.getValue());
                materialIds.retainAll((Collection)billMaterialOther.getValue());
                DynamicObject otherBillDyc = this.dataEntities[billMaterialOther.getKey()].getDataEntity();
                String settingNumber = otherBillDyc.getString("number");
                String settingName = otherBillDyc.getString("name");
                this.addDulMatError(materialIds, matrialNumNameSb, settingNumber, settingName, billMaterial.getKey());
            }
            Map<String, List<Long>> settingNumMatDbIdsMap = calOrgAcctSettingMatDbMap.get(calOrgAcctStr);
            if (settingNumMatDbIdsMap == null) continue;
            for (Map.Entry<String, List<Long>> settingNumMatDbIds : settingNumMatDbIdsMap.entrySet()) {
                matrialNumNameSb = new StringBuilder();
                materialIds = new ArrayList<Long>((Collection)billMaterial.getValue());
                materialIds.retainAll((Collection)settingNumMatDbIds.getValue());
                String settingNo = settingNumMatDbIds.getKey();
                this.addDulMatError(materialIds, matrialNumNameSb, settingNo, settingNumNameDbMap.get(settingNo), billMaterial.getKey());
            }
        }
    }

    private void addDulMatError(List<Long> materialIds, StringBuilder matrialNumNameSb, String settingNo, String settingName, Integer index) {
        if (materialIds.size() > 0) {
            String settingFmt = ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\uff1a%1$s\uff0c\u65b9\u6848\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_6", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            matrialNumNameSb.append(String.format(settingFmt, settingNo, settingName));
            for (Long materialId : materialIds) {
                DynamicObject materialDyc = this.materialDycMap.get(materialId);
                if (materialDyc == null) continue;
                matrialNumNameSb.append("\uff0c");
                matrialNumNameSb.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a%1$s\uff0c\u7269\u6599\u540d\u79f0\uff1a%2$s", (String)"FallPriceDimValidator_11", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialDyc.getString("number"), materialDyc.getString("name")));
            }
        }
        this.addDulError(matrialNumNameSb, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u201c%1$s\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_12", (String)"fi-cal-opplugin", (Object[])new Object[0]), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void querySettingDbMap(Map<String, Map<String, List<Long>>> calOrgAcctSettingMatDbMap, Map<String, DynamicObject> settingNumMatDycMap, Map<String, Map<String, List<DynamicObject>>> calOrgAcctMatSettingGroupDbMap, Map<String, Map<String, List<DynamicObject>>> calOrgAcctSettingWareGroupDbMap, Map<String, String> settingNumNameDbMap) {
        String settingNumber;
        String calOrgAccountStr;
        String matSelects = "number as settingnumber, name as settingname, calorg, costaccount, provisionway, entry.material as material,entry.material.number as materialnum, entry.materialgroup as materialgroup, entry.materialgroup.level as level,entry.materialgroup.number as materialgroupnum, entry.materialgroup.name as  materialgroupname, entry.materialgroup.longnumber as materialgrouplnum,provisiontomat,entry.warehousegroup as warehousegroup, entry.warehousegroup.level as warehousegrouplevel,entry.warehousegroup.number as warehousegroupnum, entry.warehousegroup.name as  warehousegroupname, entry.warehousegroup.longnumber as warehousegrouplnum,materialgroupstandard";
        QFilter idNotInf = new QFilter("id", "not in", this.settingIds);
        idNotInf.and("enable", "=", (Object)"1");
        DataSet settingDbDs = null;
        DataSet matDbDs = null;
        DataSet matGroupDbDs = null;
        DataSet wareGroupDbDs = null;
        DynamicObjectCollection matDycs = new DynamicObjectCollection();
        DynamicObjectCollection matGroupDycs = new DynamicObjectCollection();
        DynamicObjectCollection wareGroupDycs = new DynamicObjectCollection();
        try {
            settingDbDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fallprice_setting", (String)matSelects, (QFilter[])new QFilter[]{idNotInf}, null);
            settingDbDs = settingDbDs.addField("Cast(calorg as String) + ',' + Cast(costaccount as String)", "calorgaccount");
            QFilter calOrgAccountf = new QFilter("calorgaccount", "in", this.billIndexCalOrgAccountMap.values());
            settingDbDs = settingDbDs.filter(calOrgAccountf.toString());
            QFilter matf = new QFilter("provisionway", "=", (Object)ProvisionWayEnum.MATERIAL.getValue());
            matDbDs = settingDbDs.copy().filter(matf.toString());
            matDycs = ORM.create().toPlainDynamicObjectCollection(matDbDs);
            QFilter matGroupf = new QFilter("provisionway", "=", (Object)ProvisionWayEnum.MATERIALGROUP.getValue());
            matGroupDbDs = settingDbDs.copy().filter(matGroupf.toString());
            matGroupDycs = ORM.create().toPlainDynamicObjectCollection(matGroupDbDs);
            QFilter wareGroupf = new QFilter("provisionway", "=", (Object)ProvisionWayEnum.WAREHOUSEGROUP.getValue());
            wareGroupDbDs = settingDbDs.copy().filter(wareGroupf.toString());
            wareGroupDycs = ORM.create().toPlainDynamicObjectCollection(wareGroupDbDs);
        }
        finally {
            if (settingDbDs != null) {
                settingDbDs.close();
            }
            if (matDbDs != null) {
                matDbDs.close();
            }
            if (matGroupDbDs != null) {
                matGroupDbDs.close();
            }
            if (wareGroupDbDs != null) {
                wareGroupDbDs.close();
            }
        }
        for (DynamicObject matDyc : matDycs) {
            calOrgAccountStr = matDyc.getString("calorgaccount");
            calOrgAcctSettingMatDbMap.putIfAbsent(calOrgAccountStr, new HashMap(16));
            Map<String, List<Long>> calOrgAcctMatDbMap = calOrgAcctSettingMatDbMap.get(calOrgAccountStr);
            settingNumber = matDyc.getString("settingnumber");
            calOrgAcctMatDbMap.putIfAbsent(settingNumber, new ArrayList(16));
            calOrgAcctMatDbMap.get(settingNumber).add(matDyc.getLong("material"));
            settingNumMatDycMap.put(settingNumber, matDyc);
            settingNumNameDbMap.put(settingNumber, matDyc.getString("settingname"));
        }
        for (DynamicObject matGroupDyc : matGroupDycs) {
            calOrgAccountStr = matGroupDyc.getString("calorgaccount");
            calOrgAcctMatSettingGroupDbMap.putIfAbsent(calOrgAccountStr, new HashMap(16));
            Map<String, List<DynamicObject>> calOrgAcctMatGroupDbMap = calOrgAcctMatSettingGroupDbMap.get(calOrgAccountStr);
            settingNumber = matGroupDyc.getString("settingnumber");
            calOrgAcctMatGroupDbMap.putIfAbsent(settingNumber, new ArrayList(16));
            calOrgAcctMatGroupDbMap.get(settingNumber).add(matGroupDyc);
        }
        for (DynamicObject wareGroupDyc : wareGroupDycs) {
            calOrgAccountStr = wareGroupDyc.getString("calorgaccount");
            calOrgAcctSettingWareGroupDbMap.putIfAbsent(calOrgAccountStr, new HashMap(16));
            Map<String, List<DynamicObject>> settingWareGroupDbMap = calOrgAcctSettingWareGroupDbMap.get(calOrgAccountStr);
            settingNumber = wareGroupDyc.getString("settingnumber");
            settingWareGroupDbMap.putIfAbsent(settingNumber, new ArrayList(16));
            settingWareGroupDbMap.get(settingNumber).add(wareGroupDyc);
        }
    }

    private void checkDimOverlap(ExtendedDataEntity entity, Map<String, List<Integer[]>> dimAgeMap, String provisionWay) {
        DynamicObject settingDyc = entity.getDataEntity();
        String dimensionStr = settingDyc.getString("setdimension");
        dimensionStr = FallPriceHelper.getDropdownListStr((String)dimensionStr);
        String provisionWayVal = "";
        if (provisionWay.equals(ProvisionWayEnum.MATERIAL.getValue())) {
            provisionWayVal = "material";
        } else if (provisionWay.equals(ProvisionWayEnum.MATERIALGROUP.getValue())) {
            provisionWayVal = "materialgroup";
        } else if (provisionWay.equals(ProvisionWayEnum.WAREHOUSEGROUP.getValue())) {
            provisionWayVal = "warehousegroup";
            boolean provisiontomat = settingDyc.getBoolean("provisiontomat");
            if (provisiontomat) {
                provisionWayVal = provisionWayVal + ",material";
            }
        }
        dimensionStr = dimensionStr.isEmpty() ? provisionWayVal : provisionWayVal + "," + dimensionStr;
        String[] dims = dimensionStr.split(",");
        for (DynamicObject entry : settingDyc.getDynamicObjectCollection("entry")) {
            StringBuilder dimKeySb = new StringBuilder();
            for (String dim : dims) {
                if ("x".equals(dim)) continue;
                Object dimValue = entry.get(dim);
                if (dimValue instanceof DynamicObject) {
                    dimValue = ((DynamicObject)dimValue).getPkValue();
                }
                dimKeySb.append(dimValue);
                dimKeySb.append(',');
            }
            String dimKey = dimKeySb.toString();
            List<Integer[]> seqAgeAndSeqs = dimAgeMap.get(dimKey);
            Integer ageFrom = entry.getInt("invagefrom");
            Integer ageTo = entry.getInt("invageto");
            Boolean enableShelfLife = settingDyc.getBoolean("enableshelflife");
            if (enableShelfLife.booleanValue()) {
                ageFrom = entry.getInt("expirydatefrom");
                ageTo = entry.getInt("expirydateto");
            }
            Integer seq = entry.getInt("seq");
            if (seqAgeAndSeqs == null) {
                seqAgeAndSeqs = new ArrayList<Integer[]>(16);
                seqAgeAndSeqs.add(new Integer[]{ageFrom, ageTo, seq});
                dimAgeMap.put(dimKey, seqAgeAndSeqs);
                continue;
            }
            for (Integer[] seqAgeAndSeq : seqAgeAndSeqs) {
                boolean curContainsAllOther;
                boolean ageFromOverlap = ageFrom >= seqAgeAndSeq[0] && ageFrom <= seqAgeAndSeq[1];
                boolean ageToOverlap = ageTo >= seqAgeAndSeq[0] && ageTo <= seqAgeAndSeq[1];
                boolean bl = curContainsAllOther = ageFrom <= seqAgeAndSeq[0] && ageTo >= seqAgeAndSeq[1];
                if (!ageFromOverlap && !ageToOverlap && !curContainsAllOther) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u7ef4\u5ea6\u91cd\u590d\uff0c \u8bf7\u786e\u8ba4\u3002", (String)"FallPriceDimValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, seqAgeAndSeq[2]));
            }
            seqAgeAndSeqs.add(new Integer[]{ageFrom, ageTo, seq});
        }
    }
}

