/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.enums.ProvisionWayEnum;

public class FallPriceExpiryDateValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length < 1) {
            return;
        }
        HashMap<Long, Set<Long>> stOrgIdMatIdsMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, ExtendedDataEntity> settingIdEntityMap = new HashMap<Long, ExtendedDataEntity>(16);
        HashMap<Long, Set<Long>> settingIdMatIdsMap = new HashMap<Long, Set<Long>>(16);
        this.collectData(stOrgIdMatIdsMap, settingIdEntityMap, settingIdMatIdsMap);
        Map<Long, Map<Long, Boolean>> stOrgMatIdEnableShelfLifeMap = this.queryMatEnableShelfLifeData(stOrgIdMatIdsMap);
        Set<Long> noInvOrgMatIds = this.getNoSetInvOrgMatIds();
        this.doCheck(settingIdEntityMap, stOrgMatIdEnableShelfLifeMap, noInvOrgMatIds);
    }

    private Set<Long> getNoSetInvOrgMatIds() {
        HashSet<Long> noInvOrgMatIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billDyc = entity.getDataEntity();
            String way = billDyc.getString("provisionway");
            Boolean enableShelfLife = billDyc.getBoolean("enableshelflife");
            boolean isMaterial = ProvisionWayEnum.MATERIAL.getValue().equals(way);
            String setDimension = billDyc.getString("setdimension");
            Set setDims = FallPriceHelper.getDropdownList((String)setDimension);
            if (!enableShelfLife.booleanValue() || !isMaterial || setDims.contains("storageorgunit")) continue;
            for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection("entry")) {
                DynamicObject matDyc = entryDyc.getDynamicObject("material");
                if (matDyc == null) continue;
                noInvOrgMatIds.add((Long)matDyc.getPkValue());
            }
        }
        if (noInvOrgMatIds.isEmpty()) {
            return noInvOrgMatIds;
        }
        QFilter masterIdsFilter = new QFilter("masterid", "in", noInvOrgMatIds);
        masterIdsFilter.and(new QFilter("enableshelflifemgr", "=", (Object)Boolean.TRUE));
        masterIdsFilter.and(new QFilter("status", "=", (Object)"C"));
        masterIdsFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        try (DataSet invMatInfoDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])masterIdsFilter.toArray(), null);){
            for (Row invMatInfoD : invMatInfoDs) {
                noInvOrgMatIds.remove(invMatInfoD.getLong("masterid"));
            }
        }
        return noInvOrgMatIds;
    }

    private void doCheck(Map<Long, ExtendedDataEntity> settingIdEntityMap, Map<Long, Map<Long, Boolean>> stOrgMatIdEnableShelfLifeMap, Set<Long> noInvOrgMatIds) {
        String format = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u975e\u4fdd\u8d28\u671f\u7269\u6599\u4e0d\u80fd\u7ef4\u62a4\u4fdd\u8d28\u671f\u4fe1\u606f\u3002", (String)"ExpiryDateValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        for (Map.Entry<Long, ExtendedDataEntity> settingIdEntity : settingIdEntityMap.entrySet()) {
            ArrayList<Integer> errorIndexs = new ArrayList<Integer>(16);
            ExtendedDataEntity entityData = settingIdEntity.getValue();
            DynamicObject billDyc = entityData.getDataEntity();
            String setDimension = billDyc.getString("setdimension");
            Set setDims = FallPriceHelper.getDropdownList((String)setDimension);
            for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection("entry")) {
                DynamicObject stOrgDyc = entryDyc.getDynamicObject("storageorgunit");
                DynamicObject matDyc = entryDyc.getDynamicObject("material");
                int seq = entryDyc.getInt("seq");
                if (matDyc == null) {
                    errorIndexs.add(seq);
                    continue;
                }
                if (setDims.contains("storageorgunit")) {
                    if (stOrgDyc == null) {
                        errorIndexs.add(seq);
                        continue;
                    }
                    Map<Long, Boolean> matIdEnableShelfLifeMap = stOrgMatIdEnableShelfLifeMap.get((Long)stOrgDyc.getPkValue());
                    if (matIdEnableShelfLifeMap == null) {
                        errorIndexs.add(seq);
                        continue;
                    }
                    Boolean enableShelfLife = matIdEnableShelfLifeMap.get((Long)matDyc.getPkValue());
                    if (enableShelfLife != null && enableShelfLife.booleanValue()) continue;
                    errorIndexs.add(seq);
                    continue;
                }
                if (!noInvOrgMatIds.contains((Long)matDyc.getPkValue())) continue;
                errorIndexs.add(seq);
            }
            for (Integer errorIndex : errorIndexs) {
                String entryIndexStr = StringUtils.join((Object[])new Serializable[]{errorIndex, "\u3001"});
                if (StringUtils.isNotEmpty((CharSequence)entryIndexStr)) {
                    entryIndexStr = entryIndexStr.substring(0, entryIndexStr.length() - 1);
                }
                this.addErrorMessage(entityData, String.format(format, entryIndexStr));
            }
        }
    }

    private Map<Long, Map<Long, Boolean>> queryMatEnableShelfLifeData(Map<Long, Set<Long>> stOrgIdMatIdsMap) {
        HashMap<Long, Map<Long, Boolean>> stOrgMatIdEnableShelfLifeMap = new HashMap<Long, Map<Long, Boolean>>(16);
        for (Map.Entry<Long, Set<Long>> stOrgIdMatIdsEntry : stOrgIdMatIdsMap.entrySet()) {
            QFilter masterIdf = new QFilter("masterid", "in", stOrgIdMatIdsEntry.getValue());
            masterIdf.and(new QFilter("status", "=", (Object)"C"));
            masterIdf.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            Long stOrgId = stOrgIdMatIdsEntry.getKey();
            DynamicObjectCollection invMatDycs = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stOrgId, (QFilter)masterIdf, (String)"masterid,enableshelflifemgr");
            for (DynamicObject invMatDyc : invMatDycs) {
                long materiaId = invMatDyc.getLong("masterid");
                boolean enableShelfLifeMgr = invMatDyc.getBoolean("enableshelflifemgr");
                Map matIdEnableShelfLifeMap = stOrgMatIdEnableShelfLifeMap.computeIfAbsent(stOrgId, k -> new HashMap(16));
                matIdEnableShelfLifeMap.put(materiaId, enableShelfLifeMgr);
            }
        }
        return stOrgMatIdEnableShelfLifeMap;
    }

    private void collectData(Map<Long, Set<Long>> stOrgIdMatIdsMap, Map<Long, ExtendedDataEntity> settingIdEntityMap, Map<Long, Set<Long>> settingIdMatIdsMap) {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billDyc = entity.getDataEntity();
            String way = billDyc.getString("provisionway");
            Boolean enableShelfLife = billDyc.getBoolean("enableshelflife");
            boolean isMaterial = ProvisionWayEnum.MATERIAL.getValue().equals(way);
            if (!enableShelfLife.booleanValue() || !isMaterial) continue;
            Long settingId = (Long)billDyc.getPkValue();
            for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection("entry")) {
                DynamicObject stOrgDyc = entryDyc.getDynamicObject("storageorgunit");
                DynamicObject matDyc = entryDyc.getDynamicObject("material");
                if (matDyc == null) continue;
                settingIdEntityMap.put(settingId, entity);
                Set settingMatIds = settingIdMatIdsMap.computeIfAbsent(settingId, k -> new HashSet(16));
                settingMatIds.add((Long)matDyc.getPkValue());
                if (stOrgDyc == null) continue;
                Set orgMatIds = stOrgIdMatIdsMap.computeIfAbsent((Long)stOrgDyc.getPkValue(), k -> new HashSet(16));
                orgMatIds.add((Long)matDyc.getPkValue());
            }
        }
    }
}

